/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.InternalErrorException;
import de.cni.common.exceptions.TechnicalException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileExporter {
    private static Log log = LogFactory.getLog(AbstractFileExporter.class);
    int cnt;
    String baseDir;
    String historyDir;
    File exportFile;
    File historyFile;
    StringBuffer line;

    public String getBaseDir() throws InternalErrorException {
        String baseDir = "csv";
        return baseDir;
    }

    public abstract String getBaseFilename();

    public abstract String getExtension();

    public int processObject(IBusinessObject object) throws TechnicalException {
        try {
            this.line = new StringBuffer();
            this.object2line(object);
            ++this.cnt;
        }
        catch (Exception e) {
            this.handleError(object, e);
        }
        return this.cnt;
    }

    public void writeHeaderLine() throws IOException {
        this.line = new StringBuffer();
        this.writeHeader();
    }

    public void writeHeader() throws IOException {
    }

    public String getLine() {
        return this.line.toString();
    }

    public void writeToken(String token) throws IOException {
        this.line.append(token);
        this.line.append(";");
    }

    public void writeToken(Date token) throws IOException {
        this.line.append(Converter.dateToString(token));
        this.line.append(";");
    }

    public void writeToken(double token) throws IOException {
        this.line.append(Converter.doubleToString(token));
        this.line.append(";");
    }

    public void writeToken(int token) throws IOException {
        this.line.append(Converter.intToString(token));
        this.line.append(";");
    }

    public void writeToken(boolean token) throws IOException {
        this.line.append(Converter.booleanTo01String(token));
        this.line.append(";");
    }

    public void writeNewLine() throws IOException {
        this.line.append("\r\n");
    }

    public void handleError(IBusinessObject object, Exception e) throws TechnicalException {
        StringBuffer text = new StringBuffer();
        text.append("Fehler beim Export.\n");
        if (this.cnt >= 0) {
            text.append("Zeile: ");
            text.append(this.cnt + 1);
            text.append("\n");
        }
        if (object != null) {
            text.append("Objekt: ");
            text.append(object.getId());
            text.append("\n");
        }
        text.append("Fehlertyp: ");
        text.append(e.getClass().getCanonicalName());
        text.append("\n");
        text.append("Fehlermeldung: " + e.getMessage());
        TechnicalException exception = new TechnicalException(text.toString());
        throw exception;
    }

    public void preExport() {
    }

    public void postExport() {
    }

    public abstract void object2line(IBusinessObject var1) throws IOException;

    public String getFilename() throws InternalErrorException {
        return this.getBaseDir() + File.separator + this.getBaseFilename() + "." + this.getExtension();
    }

    public abstract String getDirParameterName();

    public abstract List<IBusinessObject> getObjectList();
}

