/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.io.AbstractExporter;
import de.cni.common.io.ExportFile;
import de.cni.common.io.ExportModule;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCsvExporter
extends AbstractExporter {
    private static Log log = LogFactory.getLog(AbstractCsvExporter.class);

    public AbstractCsvExporter(ExportModule module) {
        super(module);
    }

    @Override
    public void writeRecordToFile(ExportFile exportFile, AbstractExporter.Element[] ea, Object[] valueArray) throws IOException {
        for (int i = 0; i < ea.length; ++i) {
            AbstractExporter.Element element = ea[i];
            this.counter = i;
            if (valueArray[i] == null && element.type != 17) {
                exportFile.printCsv(element.format, element.len, "");
                continue;
            }
            switch (element.type) {
                case 1: {
                    String sValue;
                    Integer iValue;
                    if (valueArray[i] instanceof Integer) {
                        iValue = (Integer)valueArray[i];
                        if (element.intConverter > 0) {
                            String s = this.stringConverter(element.intConverter, Converter.intToString(iValue));
                            exportFile.printCsv(element.format, element.len, s);
                            break;
                        }
                        exportFile.printCsv(element.format, element.len, iValue);
                        break;
                    }
                    if (valueArray[i] instanceof BigInteger) {
                        int iValue2 = ((BigInteger)valueArray[i]).intValue();
                        if (element.intConverter > 0) {
                            String s = this.stringConverter(element.intConverter, Converter.intToString(iValue2));
                            exportFile.printCsv(element.format, element.len, s);
                            break;
                        }
                        exportFile.printCsv(element.format, element.len, iValue2);
                        break;
                    }
                    if (valueArray[i] instanceof byte[]) {
                        sValue = new String((byte[])valueArray[i]);
                        if (element.intConverter > 0) {
                            sValue = this.stringConverter(element.intConverter, sValue);
                        }
                        exportFile.printCsv(element.format, element.len, sValue);
                        break;
                    }
                    sValue = (String)valueArray[i];
                    if (element.intConverter > 0) {
                        sValue = this.stringConverter(element.intConverter, sValue);
                    }
                    exportFile.printCsv(element.format, element.len, sValue);
                    break;
                }
                case 16: {
                    Integer iValue;
                    if (valueArray[i] instanceof Integer) {
                        iValue = (Integer)valueArray[i];
                        if (element.intConverter > 0) {
                            String s = this.stringConverter(element.intConverter, Converter.intToString(iValue));
                            iValue = Converter.stringToInt(s);
                        }
                        exportFile.printCsv(element.format, element.len, iValue);
                        break;
                    }
                    String srValue = (String)valueArray[i];
                    if (element.intConverter > 0) {
                        srValue = this.stringConverter(element.intConverter, srValue);
                    }
                    exportFile.printCsv(element.format, element.len, srValue);
                    break;
                }
                case 3: {
                    if (!(valueArray[i] instanceof Integer)) break;
                    Integer iValue = (Integer)valueArray[i];
                    if (element.intConverter > 0) {
                        iValue = this.intConverter(element.intConverter, iValue);
                    }
                    exportFile.printCsv(element.format, element.len, Converter.intToNotNullString(iValue));
                    break;
                }
                case 2: {
                    Number bigValue;
                    Integer iValue;
                    if (valueArray[i] instanceof Integer) {
                        iValue = (Integer)valueArray[i];
                        if (element.intConverter > 0) {
                            iValue = this.intConverter(element.intConverter, iValue);
                        }
                        exportFile.printCsv(element.format, element.len, iValue);
                        break;
                    }
                    if (valueArray[i] instanceof Long) {
                        Long lValue = (Long)valueArray[i];
                        if (element.intConverter > 0) {
                            lValue = this.longConverter(element.intConverter, lValue);
                        }
                        exportFile.printCsv(element.format, element.len, lValue);
                        break;
                    }
                    if (valueArray[i] instanceof BigInteger) {
                        bigValue = (BigInteger)valueArray[i];
                        long lValue = ((BigInteger)bigValue).longValue();
                        if (element.intConverter > 0) {
                            lValue = this.longConverter(element.intConverter, lValue);
                        }
                        exportFile.printCsv(element.format, element.len, lValue);
                        break;
                    }
                    if (valueArray[i] instanceof BigDecimal) {
                        bigValue = (BigDecimal)valueArray[i];
                        long lValue = ((BigDecimal)bigValue).longValue();
                        if (element.intConverter > 0) {
                            lValue = this.longConverter(element.intConverter, lValue);
                        }
                        exportFile.printCsv(element.format, element.len, lValue);
                        break;
                    }
                    String sValue = valueArray[i] instanceof byte[] ? new String((byte[])valueArray[i]) : (String)valueArray[i];
                    if (element.intConverter > 0) {
                        sValue = Converter.intToString(this.intConverter(element.intConverter, Converter.stringToInt(sValue)));
                    }
                    exportFile.printCsv(element.format, element.len, Long.parseLong(sValue));
                    break;
                }
                case 8: {
                    if (element.intConverter > 0) {
                        exportFile.printCsv(Converter.dateToLongString(this.dateConverter(element.intConverter, null)));
                        break;
                    }
                    Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : Converter.stringToDate(new String((byte[])valueArray[i]));
                    String sValue = Converter.dateToSortableString(dValue);
                    exportFile.printCsv(sValue);
                    break;
                }
                case 9: {
                    if (element.intConverter > 0) {
                        exportFile.printCsv(Converter.dateToLongString(this.dateConverter(element.intConverter, null)));
                        break;
                    }
                    Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : Converter.stringToDate(new String((byte[])valueArray[i]));
                    String sValue = Converter.dateToLongString(dValue);
                    exportFile.printCsv(sValue);
                    break;
                }
                case 10: {
                    if (element.intConverter > 0) {
                        exportFile.printCsv(Converter.dateToString(this.dateConverter(element.intConverter, null)));
                        break;
                    }
                    Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : (valueArray[i] instanceof String ? Converter.stringToDate((String)valueArray[i]) : Converter.stringToDate(new String((byte[])valueArray[i])));
                    String sValue = Converter.dateToString(dValue);
                    exportFile.printCsv(sValue);
                    break;
                }
                case 11: {
                    Date dValue = (Date)valueArray[i];
                    String sValue = Converter.timeToSortableString(dValue);
                    exportFile.printCsv(sValue + "0");
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    double nValue = 0.0;
                    nValue = valueArray[i] instanceof BigDecimal ? Double.valueOf(((BigDecimal)valueArray[i]).doubleValue()) : (valueArray[i] instanceof BigInteger ? Double.valueOf(((BigInteger)valueArray[i]).doubleValue()).doubleValue() : ((Double)valueArray[i]).doubleValue());
                    if (element.intConverter > 0) {
                        nValue = this.doubleConverter(element.intConverter, nValue);
                    }
                    exportFile.printCsv(element.format, element.len, nValue);
                    break;
                }
                case 13: {
                    Integer keyKurz = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                    String kurztext = this.mappings.getForceKurztext(element.domain, keyKurz);
                    if (element.intConverter > 0) {
                        kurztext = this.stringConverter(element.intConverter, kurztext);
                    }
                    exportFile.printCsv(element.format, element.len, kurztext);
                    break;
                }
                case 14: {
                    Integer keyKurz = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                    String kurztext = this.mappings.getForceKurztext(element.domain, keyKurz);
                    if (element.intConverter > 0) {
                        kurztext = this.stringConverter(element.intConverter, kurztext);
                    }
                    exportFile.printCsv(Converter.stringToForceLeading0String(kurztext, element.len));
                    break;
                }
                case 15: {
                    Integer keyLang = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                    String langtext = this.mappings.getForceText(element.domain, keyLang);
                    exportFile.printCsv(element.format, element.len, langtext);
                    break;
                }
                case 12: {
                    if (valueArray[i] instanceof BigInteger) {
                        int booleanValue = ((BigInteger)valueArray[i]).intValue();
                        exportFile.printCsv(booleanValue == 0 ? "N" : "J");
                        break;
                    }
                    if (valueArray[i] instanceof Integer) {
                        int booleanValue = (Integer)valueArray[i];
                        exportFile.printCsv(booleanValue == 0 ? "N" : "J");
                        break;
                    }
                    Boolean bValue = (Boolean)valueArray[i];
                    exportFile.printCsv(bValue == false ? "N" : "J");
                    break;
                }
                case 17: {
                    int iValue = 0;
                    if (valueArray[i] instanceof BigInteger) {
                        iValue = ((BigInteger)valueArray[i]).intValue();
                    } else if (valueArray[i] instanceof Integer) {
                        iValue = (Integer)valueArray[i];
                    }
                    this.intConverter(element.intConverter, iValue);
                }
            }
            exportFile.print(FIELD_SEPARATOR);
        }
        exportFile.print(RECORD_SEPARATOR);
    }

    @Override
    protected void writeHeaderToFile(ExportFile exportFile) throws IOException {
        AbstractExporter.Element[] ea;
        if (!this.withHeader()) {
            return;
        }
        for (AbstractExporter.Element e : ea = this.getElementArray(0)) {
            if (e.type == 17) continue;
            exportFile.printCsv(e.ueberschrift);
        }
        exportFile.newLine();
    }

    protected abstract boolean withHeader();

    public String getStringValue(int i, AbstractExporter.Element[] ea, Object[] valueArray) throws IOException {
        AbstractExporter.Element element = ea[i];
        if (valueArray[i] == null) {
            return null;
        }
        switch (element.type) {
            case 1: {
                if (valueArray[i] instanceof Integer) {
                    Integer iValue = (Integer)valueArray[i];
                    if (element.intConverter > 0) {
                        String s = this.stringConverter(element.intConverter, Converter.intToString(iValue));
                        iValue = Converter.stringToInt(s);
                    }
                    return Converter.intToString(iValue);
                }
                if (valueArray[i] instanceof byte[]) {
                    String sValue = new String((byte[])valueArray[i]);
                    if (element.intConverter > 0) {
                        sValue = this.stringConverter(element.intConverter, sValue);
                    }
                    return sValue;
                }
                String sValue = (String)valueArray[i];
                if (element.intConverter > 0) {
                    sValue = this.stringConverter(element.intConverter, sValue);
                }
                return sValue;
            }
            case 16: {
                if (valueArray[i] instanceof Integer) {
                    Integer iValue = (Integer)valueArray[i];
                    if (element.intConverter > 0) {
                        String s = this.stringConverter(element.intConverter, Converter.intToString(iValue));
                        iValue = Converter.stringToInt(s);
                    }
                    return Converter.intToString(iValue);
                }
                String srValue = (String)valueArray[i];
                if (element.intConverter > 0) {
                    srValue = this.stringConverter(element.intConverter, srValue);
                }
                return srValue;
            }
            case 3: {
                if (!(valueArray[i] instanceof Integer)) break;
                Integer iValue = (Integer)valueArray[i];
                if (element.intConverter > 0) {
                    iValue = this.intConverter(element.intConverter, iValue);
                }
                return Converter.intToNotNullString(iValue);
            }
            case 8: {
                Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : Converter.stringToDate(new String((byte[])valueArray[i]));
                if (element.intConverter > 0) {
                    dValue = this.dateConverter(element.intConverter, dValue);
                }
                String sValue = Converter.dateToSortableString(dValue);
                return sValue;
            }
            case 9: {
                Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : Converter.stringToDate(new String((byte[])valueArray[i]));
                if (element.intConverter > 0) {
                    dValue = this.dateConverter(element.intConverter, dValue);
                }
                String sValue = Converter.dateToLongString(dValue);
                return sValue;
            }
            case 10: {
                Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : Converter.stringToDate(new String((byte[])valueArray[i]));
                if (element.intConverter > 0) {
                    dValue = this.dateConverter(element.intConverter, dValue);
                }
                String sValue = Converter.dateToString(dValue);
                return sValue;
            }
            case 11: {
                Date dValue = (Date)valueArray[i];
                String sValue = Converter.timeToSortableString(dValue);
                return sValue + "0";
            }
            case 13: {
                Integer keyKurz = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                String kurztext = this.mappings.getForceKurztext(element.domain, keyKurz);
                if (element.intConverter > 0) {
                    kurztext = this.stringConverter(element.intConverter, kurztext);
                }
                return kurztext;
            }
            case 14: {
                Integer keyKurz = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                String kurztext = this.mappings.getForceKurztext(element.domain, keyKurz);
                if (element.intConverter > 0) {
                    kurztext = this.stringConverter(element.intConverter, kurztext);
                }
                return Converter.stringToForceLeading0String(kurztext, element.len);
            }
            case 15: {
                Integer keyLang = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                String langtext = this.mappings.getForceText(element.domain, keyLang);
                return langtext;
            }
            case 12: {
                if (valueArray[i] instanceof BigInteger) {
                    int booleanValue = ((BigInteger)valueArray[i]).intValue();
                    return booleanValue == 0 ? "N" : "J";
                }
                if (valueArray[i] instanceof Integer) {
                    int booleanValue = (Integer)valueArray[i];
                    return booleanValue == 0 ? "N" : "J";
                }
                Boolean bValue = (Boolean)valueArray[i];
                return bValue == false ? "N" : "J";
            }
        }
        return null;
    }

    public Long getLongValue(int i, AbstractExporter.Element[] ea, Object[] valueArray) throws IOException {
        AbstractExporter.Element element = ea[i];
        switch (element.type) {
            case 2: {
                if (valueArray[i] instanceof Integer) {
                    Integer iValue = (Integer)valueArray[i];
                    if (element.intConverter > 0) {
                        iValue = this.intConverter(element.intConverter, iValue);
                    }
                    return iValue.longValue();
                }
                if (valueArray[i] instanceof Long) {
                    Long lValue = (Long)valueArray[i];
                    if (element.intConverter > 0) {
                        lValue = this.longConverter(element.intConverter, lValue);
                    }
                    return lValue;
                }
                if (valueArray[i] instanceof BigInteger) {
                    BigInteger bigValue = (BigInteger)valueArray[i];
                    long lValue = bigValue.longValue();
                    if (element.intConverter > 0) {
                        lValue = this.longConverter(element.intConverter, bigValue.longValue());
                    }
                    return lValue;
                }
                String sValue = valueArray[i] instanceof byte[] ? new String((byte[])valueArray[i]) : (String)valueArray[i];
                if (element.intConverter > 0) {
                    sValue = Converter.intToString(this.intConverter(element.intConverter, Converter.stringToInt(sValue)));
                }
                return Long.parseLong(sValue);
            }
            case 4: {
                Double nValue = (Double)valueArray[i];
                if (element.intConverter > 0) {
                    nValue = this.doubleConverter(element.intConverter, nValue);
                }
                return nValue.longValue();
            }
            case 5: {
                Double nValue = (Double)valueArray[i];
                if (element.intConverter > 0) {
                    nValue = this.doubleConverter(element.intConverter, nValue);
                }
                return nValue.longValue();
            }
            case 6: {
                Double nValue = (Double)valueArray[i];
                if (element.intConverter > 0) {
                    nValue = this.doubleConverter(element.intConverter, nValue);
                }
                return nValue.longValue();
            }
            case 7: {
                Double nValue = (Double)valueArray[i];
                if (element.intConverter > 0) {
                    nValue = this.doubleConverter(element.intConverter, nValue);
                }
                return nValue.longValue();
            }
        }
        return null;
    }
}

