/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.ftp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpFacade {
    private static Log log = LogFactory.getLog(FtpFacade.class);

    public static void getDataFiles(String server, String username, String password, String folder, String destinationFolder, Calendar start, Calendar end) {
        try {
            FTPClient ftp = new FTPClient();
            ftp.connect(server);
            ftp.login(username, password);
            log.debug((Object)("Connected to " + server + "."));
            System.out.print(ftp.getReplyString());
            ftp.changeWorkingDirectory(folder);
            FTPFile[] files = ftp.listFiles();
            log.debug((Object)("Number of files in dir: " + files.length));
            DateFormat df = DateFormat.getDateInstance(3);
            for (int i = 0; i < files.length; ++i) {
                Date fileDate = files[i].getTimestamp().getTime();
                if (start != null && fileDate.compareTo(start.getTime()) < 0 || end != null && fileDate.compareTo(end.getTime()) > 0) continue;
                System.out.print(df.format(files[i].getTimestamp().getTime()));
                log.debug((Object)("\t" + files[i].getName()));
                File file = new File(destinationFolder + File.separator + files[i].getName());
                FileOutputStream fos = new FileOutputStream(file);
                ftp.retrieveFile(files[i].getName(), (OutputStream)fos);
                fos.close();
                file.setLastModified(fileDate.getTime());
            }
            ftp.logout();
            ftp.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FtpFacade.getDataFiles("nikel.homeip.net", "Jana", "Josephine", ".", "e:\\tmp", null, null);
    }
}

