/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.exceptions;

import de.cni.common.core.ClassUtils;
import de.cni.common.core.Util;

public class ReportException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorType errorType;
    private String details = null;
    private String report = null;

    public ReportException(ErrorType errorType, String report, String details) {
        this.errorType = errorType;
        this.report = report;
        this.details = details;
    }

    public ReportException(ErrorType errorType, String report) {
        this(errorType, report, "");
    }

    public ReportException(ErrorType errorType, String report, Exception e) {
        this(errorType, report);
        this.details = !Util.isEmpty(e.getMessage()) ? e.getMessage() : ClassUtils.getClassName(e.getClass());
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        switch (this.errorType) {
            case TechnicalError: {
                sb.append("Beim Erstellen des Reports ist ein technischer Fehler aufgetreten.");
            }
        }
        if (!Util.isEmpty(this.details)) {
            if (this.report != null) {
                sb.append(" Report: ");
                sb.append(this.report);
            }
            sb.append("\n" + Util.NotNull(this.details));
        }
        return sb.toString();
    }

    public ErrorType getErrorCode() {
        return this.errorType;
    }

    public static enum ErrorType {
        TechnicalError;

    }
}

