/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.exceptions;

public class InternalErrorException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorType errorType;
    private String filename;
    private String details;
    private int id;

    public InternalErrorException(ErrorType errorType, int id) {
        this.errorType = errorType;
        this.details = "";
    }

    public InternalErrorException(ErrorType errorType, String filename) {
        this.errorType = errorType;
        this.filename = filename;
        this.details = "";
    }

    public InternalErrorException(ErrorType errorType, String filename, String details) {
        this.errorType = errorType;
        this.filename = filename;
        this.details = details;
    }

    @Override
    public String getMessage() {
        switch (this.errorType) {
            case fileNotFound: {
                return "Die Datei '" + this.filename + "' existiert nicht. " + this.details;
            }
            case parameterNotFound: {
                return "Der Parameter mit der ID '" + this.id + "' existiert nicht.";
            }
            case stringParameterNotFound: {
                return "Der Parameter '" + this.details + "' existiert nicht.";
            }
            case pdfError: {
                return "Fehler beim Erzeugen des PDF Dokuments. " + this.details;
            }
        }
        return "";
    }

    public ErrorType getErrorCode() {
        return this.errorType;
    }

    public static enum ErrorType {
        fileNotFound,
        pdfError,
        parameterNotFound,
        stringParameterNotFound;

    }
}

