/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.encoding;

import de.cni.common.encoding.CheckDigit;

public class CheckISO7064Mod11_2
implements CheckDigit {
    @Override
    public String encode(String digits) {
        int c = this.computeCheck(digits);
        if (c == 10) {
            return digits + 'X';
        }
        return digits + c;
    }

    @Override
    public boolean verify(String digits) {
        try {
            return this.computeCheck(this.getData(digits)) == this.getCheckDigit(digits);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int computeCheck(String digits) {
        int p = 0;
        for (int i = 0; i < digits.length(); ++i) {
            int c = digits.charAt(i) - 48;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("'" + digits + "' has bad digit: '" + digits.charAt(i) + "'");
            }
            p = 2 * (p + c);
        }
        return (12 - (p %= 11)) % 11;
    }

    @Override
    public int getCheckDigit(String digits) {
        char c = digits.charAt(digits.length() - 1);
        if (c == 'X' || c == 'x') {
            return 10;
        }
        return c - 48;
    }

    @Override
    public String getData(String digits) {
        return digits.substring(0, digits.length() - 1);
    }
}

