/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.datamodel.admin;

import de.cni.common.core.Util;
import de.cni.common.datamodel.Basisdaten;
import de.cni.common.datamodel.admin.CoreAnalyse;
import de.cni.common.datamodel.admin.CustomAnalyse;

public abstract class Analyse
extends Basisdaten {
    private static final long serialVersionUID = 1L;
    public static final int LEN_HOROSKOP = 15;
    public static final int LEN_PLANET = 10;
    public static final int LEN_TKZ = 10;
    public static final int LEN_ASPEKT = 20;
    public static final int LEN_HAUS = 2;
    public static final int LEN_TEXT1 = 5000;
    public static final int LEN_TEXT2 = 5000;
    private String horoskop = "";
    private int sort1;
    private int sort2;
    private int stufe1;
    private int stufe2;
    private String planet1 = "";
    private String planet2 = "";
    private String tkz1 = "";
    private String tkz2 = "";
    private String aspekt = "";
    private String haus = "";
    private String text1 = "";
    private String text2 = "";
    private boolean foundAspekt;
    private boolean foundTkz;
    private boolean foundDoubleTkz;
    private boolean foundHaus;
    private boolean found3GradHaus;
    private boolean foundP2Haus;
    private boolean found3GradP2Haus;
    private boolean foundTkzHaus;
    private String textkey;
    private int lineNumber;

    public static Analyse newInstance(boolean core) {
        return core ? new CoreAnalyse() : new CustomAnalyse();
    }

    public void reset() {
        this.foundAspekt = false;
        this.foundTkz = false;
        this.foundDoubleTkz = false;
        this.foundHaus = false;
        this.found3GradHaus = false;
        this.foundP2Haus = false;
        this.found3GradP2Haus = false;
        this.foundTkzHaus = false;
    }

    public boolean isEmpty() {
        return Util.isEmpty(this.planet1) && Util.isEmpty(this.planet2) && Util.isEmpty(this.tkz1) && Util.isEmpty(this.tkz2) && Util.isEmpty(this.aspekt) && Util.isEmpty(this.haus) && Util.isEmpty(this.text1) && Util.isEmpty(this.text2);
    }

    public boolean hasFound() {
        return this.foundAspekt || this.foundTkz || this.foundDoubleTkz || this.foundHaus || this.found3GradHaus || this.foundP2Haus || this.found3GradP2Haus || this.foundP2Haus || this.found3GradP2Haus || this.foundTkzHaus;
    }

    public String toString() {
        return "Planet1=" + this.planet1 + ", Planet2=" + this.planet2 + ", Tkz1=" + this.tkz1 + ", Tkz2=" + this.tkz2 + ", Aspekt=" + this.aspekt + ", Haus=" + this.haus;
    }

    public boolean isValid() {
        return this.isRelevantAspekt() || this.isRelevantTkz() || this.isRelevantDoubleTkz() || this.isRelevantHaus() || this.isRelevantP2Haus() || this.isRelevantTkzHaus() || this.isOnlyText1();
    }

    public static String hint() {
        return "Folgende Kombinationen sind erlaubt:\nAspekt:      \tPlanet 1 + Planet 2 + Aspekt\nTkz:         \tPlanet 1 + Tkz 1\nTKz-Tkz:     \tPlanet 1 + Tkz 1 + Planet 2 + Tkz 2\nPlanet-Haus: \tPlanet 1 + Haus\nPlanet2-Haus: \tPlanet 2 + Haus\nTkz-Haus:    \tTkz 1    + Haus\nThematik:      Thematik";
    }

    public boolean isRelevantAspekt() {
        return !Util.isEmpty(this.planet1) && !Util.isEmpty(this.planet2) && !Util.isEmpty(this.aspekt) && Util.isEmpty(this.tkz1) && Util.isEmpty(this.tkz2) && Util.isEmpty(this.haus);
    }

    public boolean isRelevantTkz() {
        return !Util.isEmpty(this.planet1) && !Util.isEmpty(this.tkz1) && Util.isEmpty(this.planet2) && Util.isEmpty(this.tkz2) && Util.isEmpty(this.haus) && Util.isEmpty(this.aspekt);
    }

    public boolean isRelevantDoubleTkz() {
        return !Util.isEmpty(this.planet1) && !Util.isEmpty(this.tkz1) && !Util.isEmpty(this.planet2) && !Util.isEmpty(this.tkz2) && Util.isEmpty(this.haus) && Util.isEmpty(this.aspekt);
    }

    public boolean isRelevantHaus() {
        return !Util.isEmpty(this.planet1) && !Util.isEmpty(this.haus) && Util.isEmpty(this.planet2) && Util.isEmpty(this.tkz1) && Util.isEmpty(this.tkz2) && Util.isEmpty(this.aspekt);
    }

    public boolean isRelevantP2Haus() {
        return Util.isEmpty(this.planet1) && !Util.isEmpty(this.haus) && !Util.isEmpty(this.planet2) && Util.isEmpty(this.tkz1) && Util.isEmpty(this.tkz2) && Util.isEmpty(this.aspekt);
    }

    public boolean isRelevantTkzHaus() {
        return !Util.isEmpty(this.tkz1) && !Util.isEmpty(this.haus) && Util.isEmpty(this.tkz2) && Util.isEmpty(this.planet1) && Util.isEmpty(this.planet2) && Util.isEmpty(this.aspekt);
    }

    public boolean isOnlyText1() {
        return !Util.isEmpty(this.text1) && Util.isEmpty(this.tkz1) && Util.isEmpty(this.haus) && Util.isEmpty(this.tkz2) && Util.isEmpty(this.planet1) && Util.isEmpty(this.planet2) && Util.isEmpty(this.aspekt);
    }

    public String getPlanet1() {
        return this.planet1;
    }

    public String getPlanet2() {
        return this.planet2;
    }

    public String getTkz1() {
        return this.tkz1;
    }

    public String getAspekt() {
        return this.aspekt;
    }

    public String getHaus() {
        return this.haus;
    }

    public String getText1() {
        return this.text1;
    }

    public String getText2() {
        return this.text2;
    }

    public void setPlanet1(String planet1) {
        this.planet1 = planet1;
    }

    public void setPlanet2(String planet2) {
        this.planet2 = planet2;
    }

    public void setTkz1(String tkz1) {
        this.tkz1 = tkz1;
    }

    public void setAspekt(String aspekt) {
        this.aspekt = aspekt;
    }

    public void setHaus(String haus) {
        this.haus = haus;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public boolean isFoundAspekt() {
        return this.foundAspekt;
    }

    public boolean isFoundTkz() {
        return this.foundTkz;
    }

    public boolean isFoundHaus() {
        return this.foundHaus;
    }

    public void setFoundAspekt(boolean foundAspekt) {
        this.foundAspekt = foundAspekt;
    }

    public void setFoundTkz(boolean foundTkz) {
        this.foundTkz = foundTkz;
    }

    public void setFoundHaus(boolean foundHaus) {
        this.foundHaus = foundHaus;
    }

    public String getTkz2() {
        return this.tkz2;
    }

    public void setTkz2(String tkz2) {
        this.tkz2 = tkz2;
    }

    public boolean isFoundDoubleTkz() {
        return this.foundDoubleTkz;
    }

    public void setFoundDoubleTkz(boolean foundDoubleTkz) {
        this.foundDoubleTkz = foundDoubleTkz;
    }

    public boolean isFoundTkzHaus() {
        return this.foundTkzHaus;
    }

    public void setFoundTkzHaus(boolean foundTkzHaus) {
        this.foundTkzHaus = foundTkzHaus;
    }

    public boolean isFound3GradHaus() {
        return this.found3GradHaus;
    }

    public void setFound3GradHaus(boolean found3GradHaus) {
        this.found3GradHaus = found3GradHaus;
    }

    public int getSort1() {
        return this.sort1;
    }

    public int getSort2() {
        return this.sort2;
    }

    public void setSort1(int sort1) {
        this.sort1 = sort1;
    }

    public void setSort2(int sort2) {
        this.sort2 = sort2;
    }

    public String getHoroskop() {
        return this.horoskop;
    }

    public int getStufe1() {
        return this.stufe1;
    }

    public int getStufe2() {
        return this.stufe2;
    }

    public void setHoroskop(String horoskop) {
        this.horoskop = horoskop;
    }

    public void setStufe1(int stufe1) {
        this.stufe1 = stufe1;
    }

    public void setStufe2(int stufe2) {
        this.stufe2 = stufe2;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getTextkey() {
        return this.textkey;
    }

    public void setTextkey(String textkey) {
        this.textkey = textkey;
    }

    public boolean isFoundP2Haus() {
        return this.foundP2Haus;
    }

    public boolean isFound3GradP2Haus() {
        return this.found3GradP2Haus;
    }

    public void setFoundP2Haus(boolean foundP2Haus) {
        this.foundP2Haus = foundP2Haus;
    }

    public void setFound3GradP2Haus(boolean found3GradP2Haus) {
        this.found3GradP2Haus = found3GradP2Haus;
    }
}

