/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Converter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Verschluesselung {
    private static Log log = LogFactory.getLog(Verschluesselung.class);
    private static final String key = "$dRt12Qw4.";
    public static final String basefolder = "D:/eclipse64_workspace/CosmicCompass/texte";
    public static final String newfolder = "D:/eclipse64_workspace/CosmicCompass/texte/generated";

    public static void main(String[] args) throws Exception {
        Verschluesselung v = new Verschluesselung();
        v.deleteFiles(newfolder);
        v.verzeichnisVerschluesseln(basefolder);
    }

    private void deleteFiles(String foldername) {
        File folder = new File(foldername);
        if (folder == null || !folder.exists()) {
            return;
        }
        for (File f : folder.listFiles()) {
            if (!f.getName().endsWith(".htmlc")) continue;
            f.delete();
        }
    }

    public void verzeichnisVerschluesseln_original(String path) throws IOException {
        String ext = "html";
        File folder = new File(path);
        Collection allFiles = FileUtils.listFiles((File)folder, (String[])new String[]{ext}, (boolean)false);
        for (File f : allFiles) {
            String content = FileUtils.readFileToString((File)f, (String)"UTF8");
            content = content.replace("<Body style=\"", "<Body style=\"-webkit-user-select: none;-moz-user-select: none;-khtml-user-select: none;-ms-user-select: none;user-select: none:");
            content = content.replace("</Body>", "<br><br>\u00a9 by Randolf Sch\u00e4fer</Body>");
            byte[] result = this.verschluesselnContent(content);
            String oldFilepath = f.getCanonicalPath();
            String newFilename = FilenameUtils.getBaseName((String)oldFilepath) + ".htmlc";
            File dest = new File("D:/eclipse64_workspace/CosmicCompass/texte/generated/" + newFilename);
            FileUtils.writeByteArrayToFile((File)dest, (byte[])result);
        }
    }

    public void verzeichnisVerschluesseln(String path) throws IOException {
        String ext = "html";
        File folder = new File(path);
        Collection allFiles = FileUtils.listFiles((File)folder, (String[])new String[]{ext}, (boolean)false);
        for (File f : allFiles) {
            String content = FileUtils.readFileToString((File)f);
            if (!content.contains("<body")) {
                content = content + "<br><br>\u00a9 by Randolf Sch\u00e4fer";
                content = "<Body style=\"-webkit-user-select: none;-moz-user-select: none;-khtml-user-select: none;-ms-user-select: none;user-select: none\">" + content + "</Body>";
            } else {
                content = content.replace("<body lang=DE style='", "<body lang=DE style='-webkit-user-select: none;-moz-user-select: none;-khtml-user-select: none;-ms-user-select: none;user-select: none;");
                content = content.replace("</body>", "<br><br>\u00a9 by Randolf M. Sch\u00e4fer</Body>");
            }
            content = Converter.stringToHtmlText(content);
            byte[] result = this.verschluesselnContent(content);
            String oldFilepath = f.getCanonicalPath();
            String newFilename = FilenameUtils.getBaseName((String)oldFilepath) + ".htmlc";
            File dest = new File("D:/eclipse64_workspace/CosmicCompass/texte/generated/" + newFilename);
            FileUtils.writeByteArrayToFile((File)dest, (byte[])result);
        }
    }

    public byte[] verschluesselnContent(String content) throws IOException {
        byte[] result = this.verschluesseln(key, content);
        return result;
    }

    public String entschluessel(String filename) throws IOException {
        byte[] bytes = null;
        File file = new File(filename);
        bytes = FileUtils.readFileToByteArray((File)file);
        String result = this.entschluesselnContent(bytes);
        return result;
    }

    public String fileToString(String filename) throws IOException {
        File file = new File(filename);
        String s = FileUtils.readFileToString((File)file);
        return s;
    }

    public String entschluesselnContent(byte[] bytes) throws IOException {
        String result = this.entschluesseln(key, bytes);
        return result;
    }

    private SecretKeySpec getKey(String keyStr) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] key = keyStr.getBytes("UTF-8");
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        key = sha.digest(key);
        key = Arrays.copyOf(key, 16);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        return secretKeySpec;
    }

    private byte[] verschluesseln(String keyStr, String text) {
        try {
            SecretKeySpec secretKeySpec = this.getKey(keyStr);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            byte[] encrypted = cipher.doFinal(text.getBytes());
            return encrypted;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String entschluesseln(String keyStr, byte[] encryptedText) {
        try {
            SecretKeySpec secretKeySpec = this.getKey(keyStr);
            Cipher cipher2 = Cipher.getInstance("AES");
            cipher2.init(2, secretKeySpec);
            byte[] cipherData2 = cipher2.doFinal(encryptedText);
            String erg = new String(cipherData2);
            return erg;
        }
        catch (Exception e) {
            return null;
        }
    }
}

