/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Util;

public class Trigo {
    public static boolean isBetween(double winkel, double von, double bis) {
        return von <= bis ? winkel >= von && winkel <= bis : winkel >= von || winkel <= bis;
    }

    public static double grad(double grad) {
        if ((grad %= 360.0) < 0.0) {
            grad += 360.0;
        }
        return grad;
    }

    public static double alphaDiff(double grad1, double grad2) {
        double alphaDiff = Math.abs(Trigo.grad(grad1) - Trigo.grad(grad2));
        if (alphaDiff > 180.0) {
            alphaDiff = 360.0 - alphaDiff;
        }
        return alphaDiff;
    }

    public static double average(double ... alpha) {
        double x = 0.0;
        double y = 0.0;
        double ret = 0.0;
        for (int i = 0; i < alpha.length; ++i) {
            x += Math.cos(alpha[i]);
            y += Math.sin(alpha[i]);
        }
        x = Util.round(x, -10000);
        y = Util.round(y, -10000);
        if (x == -0.0) {
            x = 0.0;
        }
        if (y == -0.0) {
            y = 0.0;
        }
        if (x == 0.0 && y == 0.0) {
            return alpha[0];
        }
        ret = Math.atan2(y, x);
        return ret;
    }

    public static double averageGrad(double ... grad) {
        double[] alpha = new double[grad.length];
        for (int i = 0; i < alpha.length; ++i) {
            alpha[i] = Trigo.grad2alpha(grad[i]);
        }
        double ret = Trigo.average(alpha);
        return Trigo.grad(Trigo.alpha2grad(ret));
    }

    public static double grad2alpha(double grad) {
        return grad / 360.0 * 2.0 * Math.PI;
    }

    public static double alpha2grad(double alpha) {
        return alpha * 360.0 / 2.0 / Math.PI;
    }

    public static int getDiagonale(int size) {
        return (int)Math.round(Math.sqrt(size * size + size * size));
    }
}

