/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Introspection;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.TechnicalException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenReplacer {
    public static String TOKEN_VORNAME = "VORNAME";
    public static String TOKEN_NACHNAME = "NACHNAME";
    public static String TOKEN_GEBURTSDATUM = "GEBURTSDATUM";
    public static String TOKEN_WAGNISMENGE_FORMATTED = "@WAGNISMENGE@";

    public static Map<String, String> getNewTokenMap(String text, String sign) {
        Pattern pattern = Pattern.compile(sign + "(.*?)" + sign);
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = pattern.matcher(text);
        while (m.find()) {
            String token = m.group(1);
            String value = sign + token + sign;
            map.put(token, value);
        }
        return map;
    }

    public static Map<String, String> addToTokenMap(Map<String, String> map, String text, String sign) {
        Pattern pattern = Pattern.compile(sign + "(.*?)" + sign);
        Matcher m = pattern.matcher(text);
        while (m.find()) {
            String token = m.group(1);
            String value = sign + token + sign;
            map.put(token, value);
        }
        return map;
    }

    public static String getTokenValue(String token, Object object) throws TechnicalException {
        String string = Introspection.getStringValue(object, token, 0, true);
        return string;
    }

    public static void setPredefinedValues(Map<String, String> map, Object object) {
        if (object instanceof Personendaten) {
            Personendaten obj = (Personendaten)object;
            if (map.containsKey(TOKEN_VORNAME) && !Util.isEmpty(obj.getVorname())) {
                map.put(TOKEN_VORNAME, obj.getVorname());
            }
            if (map.containsKey(TOKEN_NACHNAME) && !Util.isEmpty(obj.getNachname())) {
                map.put(TOKEN_NACHNAME, obj.getVorname());
            }
            if (map.containsKey(TOKEN_GEBURTSDATUM) && !Util.isEmpty(obj.getGeburtsdatum())) {
                map.put(TOKEN_GEBURTSDATUM, obj.getGeburtsdatumString());
            }
        }
    }

    public static String replaceTokens(String text, Map<String, String> map, String sign) {
        for (String key : map.keySet()) {
            String value = map.get(key);
            text = text.replace(sign + key + sign, value);
        }
        return text;
    }

    public static boolean areTokensToBeReplaced(Map<String, String> tokenmap, String sign) {
        if (tokenmap == null || tokenmap.values().size() == 0) {
            return false;
        }
        for (String value : tokenmap.values()) {
            if (!value.contains(sign)) continue;
            return true;
        }
        return false;
    }
}

