/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Settings;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax0.license3j.Feature;
import javax0.license3j.License;
import javax0.license3j.io.LicenseReader;

public class LicenseWrapper {
    private License license;
    Map<String, Feature> fMap;
    private static byte[] pubKey = new byte[]{82, 83, 65, 0, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -87, 16, 8, 80, 7, -2, -25, -67, -60, -113, -83, 1, -80, -103, 120, -69, -53, -28, -70, -95, 25, -85, -115, -126, -123, -82, -87, 84, -128, 26, 33, -57, -7, -23, -82, 91, -82, -53, 72, 38, 86, -97, -67, 98, -67, 65, 38, -43, 76, -68, -100, -81, 13, -4, -35, 104, -2, 96, -106, -107, -65, 105, 28, 74, 6, 69, 59, 103, -94, -89, -64, 122, -107, 119, 49, -29, 40, 70, -78, 9, 6, 23, 93, 105, 29, -64, 117, 29, -77, -5, 70, 24, 15, 93, 53, -105, 99, -24, -3, 7, -100, -20, 73, -88, 39, -93, -4, -121, -121, -60, 6, -122, -5, -71, -7, 86, -14, 116, -100, -29, -70, 57, 84, -115, 5, 52, -66, 43, 2, 3, 1, 0, 1};

    public void readLicenseFromFile(String filename) throws FileNotFoundException, IOException {
        LicenseReader reader = new LicenseReader(filename);
        this.license = reader.read();
        reader.close();
        this.fMap = this.license.getFeatures();
    }

    public void readLicenseFromDB() throws ClassNotFoundException, SQLException, IOException {
        SqLiteDatabase db = new SqLiteDatabase();
        byte[] byteArray = db.selectLicense();
        if (byteArray != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
            LicenseReader reader = new LicenseReader((InputStream)inputStream);
            this.license = reader.read();
            reader.close();
            ((InputStream)inputStream).close();
            this.fMap = this.license.getFeatures();
        } else {
            this.license = null;
            this.fMap = null;
        }
    }

    public void writeLicenseToDb() throws ClassNotFoundException, SQLException {
        if (this.license != null) {
            byte[] ba = this.license.serialized();
            SqLiteDatabase db = new SqLiteDatabase();
            db.saveLicense(ba);
            Settings settings = new Settings();
            List<IBusinessObject> list = db.select(settings);
            if (list != null && list.size() > 0) {
                settings = (Settings)list.get(0);
                settings.setName(this.getName());
                settings.setEmail(this.getEmail());
                settings.setKopfzeile(settings.generateKopfzeile());
                settings.setKopfzeileKurz(settings.generateKopfzeile());
                settings.generateFusszeile();
            }
            db.save(settings);
        }
    }

    public boolean isValid() {
        if (this.license == null) {
            return false;
        }
        return this.license.isOK(pubKey);
    }

    public boolean isExpired() {
        if (this.license == null) {
            return false;
        }
        if (Util.isEmpty(this.getGueltigBis())) {
            return false;
        }
        Date today = DateUtil.getToday();
        return DateUtil.compareDateWithoutTime(today, this.getGueltigBis()) > 0;
    }

    public boolean isLegal() {
        return this.isValid() && !this.isExpired();
    }

    public Date getGueltigBis() {
        String gueltigBis = this.getStringValue("gueltigBis");
        return Converter.stringToDate(gueltigBis);
    }

    public String getName() {
        return this.getStringValue("name");
    }

    public String getEmail() {
        return this.getStringValue("email");
    }

    public String getArt() {
        return this.getStringValue("art");
    }

    public String getErzeugt() {
        return this.getStringValue("erzeugt");
    }

    public String getStringValue(String key) {
        if (this.fMap == null) {
            return null;
        }
        Feature feature = this.fMap.get(key);
        if (feature == null) {
            return null;
        }
        String value = feature.valueString();
        return value;
    }
}

