/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.core.Util;
import de.cni.common.datamodel.batch.ReportSpec;
import de.cni.common.exceptions.ReportException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaTray;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JasperPrinterFacade {
    private static Log log = LogFactory.getLog(JasperPrinterFacade.class);

    public void print(JasperPrint jasperPrint, ReportSpec reportSpec, boolean printerEnabled) throws ReportException, JRException {
        try {
            if (!printerEnabled) {
                log.debug((Object)"Drucken ist deaktiviert");
                return;
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return;
        }
        if (reportSpec.getReportinfo().isDisabled()) {
            log.debug((Object)"Drucker ist f\u00fcr diesen Dokumenttypen deaktiviert.");
            return;
        }
        int anzSeiten = jasperPrint.getPages().size();
        if (anzSeiten == 0) {
            log.debug((Object)"Das Dokument hat keine Seiten.");
            return;
        }
        String printerName = reportSpec.getPrinterName();
        if (Util.isEmpty(printerName)) {
            log.debug((Object)"Default-Printer suchen:");
            PrintService service = PrintServiceLookup.lookupDefaultPrintService();
            printerName = service.getName();
        }
        String einzugsfachErsteSeite = this.getEinzugsfachErsteSeite(reportSpec.getEinzugsfach());
        String einzugsfachFolgeSeite = this.getEinzugsfachFolgeSeite(reportSpec.getEinzugsfach());
        for (int anz = 0; anz < reportSpec.getAnzahl(); ++anz) {
            if (anzSeiten == 1 || Util.equals(einzugsfachErsteSeite, einzugsfachFolgeSeite)) {
                log.debug((Object)("Alle Seiten aus Einzugsfach " + einzugsfachErsteSeite + " drucken"));
                if (!Util.isEmpty(einzugsfachErsteSeite)) {
                    reportSpec.setPrinterName(printerName + " " + einzugsfachErsteSeite);
                }
                log.debug((Object)("Drucker Name .........: " + reportSpec.getPrinterName()));
                this.printAusschnitt(jasperPrint, reportSpec, -1, -1);
                continue;
            }
            log.debug((Object)("Erste Seite aus Einzugsfach '" + einzugsfachErsteSeite + "' drucken"));
            if (!Util.isEmpty(einzugsfachErsteSeite)) {
                reportSpec.setPrinterName(printerName + " " + einzugsfachErsteSeite);
            }
            log.debug((Object)("Drucker Name .........: " + reportSpec.getPrinterName()));
            this.printAusschnitt(jasperPrint, reportSpec, 0, 0);
            log.debug((Object)("Zweite Seite aus Einzugsfach '" + einzugsfachFolgeSeite + "' drucken"));
            if (!Util.isEmpty(einzugsfachFolgeSeite)) {
                reportSpec.setPrinterName(printerName + " " + einzugsfachFolgeSeite);
            }
            log.debug((Object)("Drucker Name .........: " + reportSpec.getPrinterName()));
            this.printAusschnitt(jasperPrint, reportSpec, 1, anzSeiten - 1);
        }
    }

    private void printAusschnitt(JasperPrint jasperPrint, ReportSpec reportSpec, int von, int bis) throws JRException, ReportException {
        PrintService printService = this.getPrintService(reportSpec.getPrinterName());
        if (printService == null) {
            throw new ReportException(ReportException.ErrorType.TechnicalError, reportSpec.getDokumentname(), "Der konfigurierte Drucker '" + reportSpec.getPrinterName() + "' kann nicht gefunden werden. ");
        }
        log.debug((Object)"Druck-Attribute setzen");
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(new Copies(1));
        log.debug((Object)"Print-Exporter anlegen");
        JRPrintServiceExporter printExporter = new JRPrintServiceExporter();
        printExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
        configuration.setPrintService(printService);
        configuration.setPrintServiceAttributeSet(printService.getAttributes());
        configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)printRequestAttributeSet);
        configuration.setDisplayPageDialog(Boolean.valueOf(false));
        configuration.setDisplayPrintDialog(Boolean.valueOf(false));
        if (von >= 0) {
            printExporter.setParameter(JRPrintServiceExporterParameter.START_PAGE_INDEX, (Object)von);
        }
        if (bis >= 0) {
            printExporter.setParameter(JRPrintServiceExporterParameter.END_PAGE_INDEX, (Object)bis);
        }
        printExporter.setConfiguration((ExporterConfiguration)configuration);
        log.debug((Object)"Drucken...");
        long start = System.currentTimeMillis();
        printExporter.exportReport();
        log.debug((Object)("Report Drucken. Dauer= " + (System.currentTimeMillis() - start)));
    }

    private PrintService getPrintService(String printerName) {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            if (Util.isEmpty(printerName)) {
                log.debug((Object)"Default-Printer suchen:");
                PrintService service = PrintServiceLookup.lookupDefaultPrintService();
                if (service != null) {
                    log.debug((Object)("Default-Printer:" + service.getName()));
                } else {
                    log.debug((Object)"Es gibt keinen Default-Printer");
                }
                return service;
            }
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            if (services.length == 0) {
                return null;
            }
            int selectedService = -1;
            for (int i = 0; i < services.length; ++i) {
                log.debug((Object)("Service:" + services[i].getName()));
                if (!Util.equals(services[i].getName().toUpperCase(), printerName.toUpperCase())) continue;
                selectedService = i;
                log.debug((Object)("Drucker gefunden " + services[i].getName()));
                break;
            }
            if (selectedService == -1) {
                log.debug((Object)("Drucker nicht gefunden: " + printerName));
                return null;
            }
            job.setPrintService(services[selectedService]);
            return services[selectedService];
        }
        catch (PrinterException e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getEinzugsfachErsteSeite(String fachString) {
        if (Util.isEmpty(fachString)) {
            return "";
        }
        String[] stringArray = fachString.split(";");
        if (stringArray.length < 1) {
            return fachString;
        }
        return stringArray[0];
    }

    public String getEinzugsfachFolgeSeite(String fachString) {
        if (Util.isEmpty(fachString)) {
            return "";
        }
        String[] stringArray = fachString.split(";");
        if (stringArray.length < 2) {
            return stringArray[0];
        }
        return stringArray[1];
    }

    private Object getTray(String einzugsschacht) {
        MediaTray tray = null;
        if (Util.equals(einzugsschacht, "1")) {
            tray = MediaTray.BOTTOM;
        } else if (Util.equals(einzugsschacht, "2")) {
            tray = MediaTray.MIDDLE;
        } else if (Util.equals(einzugsschacht, "3")) {
            tray = MediaTray.TOP;
        } else if (Util.equals(einzugsschacht, "4")) {
            tray = MediaTray.ENVELOPE;
        } else if (Util.equals(einzugsschacht, "5")) {
            tray = MediaTray.LARGE_CAPACITY;
        } else if (Util.equals(einzugsschacht, "6")) {
            tray = MediaTray.SIDE;
        }
        return tray;
    }
}

