/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.astrologie.AspektTyp;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.Mappings;
import de.cni.common.core.ParameterStore;
import de.cni.common.core.Roles;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.AllUserRoles;
import de.cni.common.datamodel.admin.Monitoraufloesung;
import de.cni.common.datamodel.admin.Rolle;
import de.cni.common.datamodel.admin.Settings;
import de.cni.common.datamodel.admin.User;
import de.cni.common.ejb.IUserVerwaltung;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Font;

public class GlobalData {
    private static Log log = LogFactory.getLog(GlobalData.class);
    public static GlobalData instance = new GlobalData();
    private User user;
    private ParameterStore parameterStore;
    private Roles userRoles = new Roles();
    private boolean brandRandolf;
    private boolean brandCosmicCompass;
    private boolean brandOpen;
    private boolean alwaysEnabled;
    private Monitoraufloesung monitoraufloesung = null;
    private Font defaultFont = null;
    private Brand brand;
    private Settings settings;
    private boolean windows;
    private boolean macos;
    private String lizenzart;
    private int planetenzyklus_planet1;
    private int planetenzyklus_planet2;
    private Date planetenzyklus_date;
    private AspektTyp planetenzyklus_aspektTyp;

    private GlobalData() {
        this.user = new User();
        this.planetenzyklus_aspektTyp = AspektTyp.empty;
        this.parameterStore = new ParameterStore();
        try {
            this.parameterStore.initialize();
        }
        catch (Exception e) {
            log.fatal((Object)("ParameterStore kann nicht initialisert werden. Programmabbruch." + e.getMessage()));
            System.exit(1);
        }
        try {
            IUserVerwaltung bean = ServerConnection.getInstance().getUserVerwaltung();
            if (bean != null) {
                List<AllUserRoles> list = bean.getAllUserRoles();
                this.userRoles.setAllRoles(list);
            }
        }
        catch (Exception e) {
            log.fatal((Object)"Benutzer Rollen k\u00f6nnen nicht gelesen werden. Programmabbruch.");
            System.exit(1);
        }
    }

    public static GlobalData getInstance() {
        return instance;
    }

    public ParameterStore getParameterStore() {
        return this.parameterStore;
    }

    public void setParameterStore(ParameterStore parameterStore) {
        this.parameterStore = parameterStore;
    }

    public User getUser() {
        return this.user;
    }

    public void setOS(String osString) {
        if (Util.equalsIgnoreCase(osString, "WINDOWS")) {
            this.windows = true;
        }
        if (Util.equalsIgnoreCase(osString, "MAC") || Util.equalsIgnoreCase(osString, "MACOS")) {
            this.macos = true;
        }
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void recalculateMonitoraufloesung() {
        this.monitoraufloesung = null;
        int minWidth = 1024;
        int minHeight = 768;
        String sizeText = "1024 x 768";
        int xBorderSize = ApplicationProperties.getInstance().getIntProperty("client.window.x.border.size");
        int yBorderSize = ApplicationProperties.getInstance().getIntProperty("client.window.y.border.size");
        int yToolbarSize = ApplicationProperties.getInstance().getIntProperty("client.window.y.toolbar.size");
        if (this.user != null && this.user.getSettings() != null) {
            try {
                Mappings mappings = Mappings.getInstance();
                int width = Converter.stringToIntIgnoreChars(Formatter.getToken(sizeText, "x", 0).trim());
                int height = Converter.stringToIntIgnoreChars(Formatter.getToken(sizeText, "x", 1).trim());
                this.monitoraufloesung = new Monitoraufloesung(sizeText, Math.max(minWidth, width), Math.max(minHeight, height), 0.0, false, xBorderSize, yBorderSize, yToolbarSize);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (this.monitoraufloesung == null) {
            sizeText = ApplicationProperties.getInstance().getProperty("client.window.size");
            int width = Converter.stringToIntIgnoreChars(Formatter.getToken(sizeText, "x", 0).trim());
            int height = Converter.stringToIntIgnoreChars(Formatter.getToken(sizeText, "x", 1).trim());
            this.monitoraufloesung = new Monitoraufloesung(sizeText, Math.max(minWidth, width), Math.max(minHeight, height), 0.0, false, xBorderSize, yBorderSize, yToolbarSize);
        }
        if (this.defaultFont != null) {
            this.defaultFont.dispose();
        }
        this.defaultFont = null;
    }

    public boolean isHighResolution() {
        return this.monitoraufloesung.isHighResolution();
    }

    public Settings getUserSetting() {
        if (this.user == null) {
            return null;
        }
        return this.user.getSettings();
    }

    public boolean isAutoscale() {
        return true;
    }

    public boolean isExpandTree() {
        return false;
    }

    public boolean hasRole(Roles role) {
        for (Rolle r : this.user.getRolleList()) {
            if (!r.getRolle().equals(role.toString())) continue;
            return true;
        }
        return false;
    }

    public Roles getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(Roles userRoles) {
        this.userRoles = userRoles;
    }

    public boolean isBrandRandolf() {
        return this.brandRandolf;
    }

    public boolean isBrandOpen() {
        return this.brandOpen;
    }

    public boolean hasBrand(Brand brand) {
        if (brand == Brand.OPEN && this.brandOpen) {
            return true;
        }
        if (brand == Brand.RANDOLF && this.brandRandolf) {
            return true;
        }
        if (brand == Brand.COSMICCOMPASS && this.brandCosmicCompass) {
            return true;
        }
        return brand == Brand.ALL;
    }

    public Monitoraufloesung getMonitoraufloesung() {
        return this.monitoraufloesung;
    }

    public void setMonitoraufloesung(Monitoraufloesung monitoraufloesung) {
        this.monitoraufloesung = monitoraufloesung;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public Brand getBrand() {
        return this.brand;
    }

    public void setBrand(Brand brand) {
        this.brand = brand;
    }

    public void setBrandRandolf(boolean brandRandolf) {
        this.brandRandolf = brandRandolf;
    }

    public void setBrandOpen(boolean brandOpen) {
        this.brandOpen = brandOpen;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isAlwaysEnabled() {
        return this.alwaysEnabled;
    }

    public void setAlwaysEnabled(boolean alwaysEnabled) {
        this.alwaysEnabled = alwaysEnabled;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public boolean isMacos() {
        return this.macos;
    }

    public String getLizenzart() {
        return this.lizenzart;
    }

    public void setLizenzart(String lizenzart) {
        this.lizenzart = lizenzart;
    }

    public int getPlanetenzyklus_planet1() {
        return this.planetenzyklus_planet1;
    }

    public int getPlanetenzyklus_planet2() {
        return this.planetenzyklus_planet2;
    }

    public void setPlanetenzyklus_planet1(int planetenzyklus_planet1) {
        this.planetenzyklus_planet1 = planetenzyklus_planet1;
    }

    public void setPlanetenzyklus_planet2(int planetenzyklus_planet2) {
        this.planetenzyklus_planet2 = planetenzyklus_planet2;
    }

    public AspektTyp getPlanetenzyklus_aspektTyp() {
        return this.planetenzyklus_aspektTyp;
    }

    public void setPlanetenzyklus_aspektTyp(AspektTyp planetenzyklus_aspektTyp) {
        this.planetenzyklus_aspektTyp = planetenzyklus_aspektTyp;
    }

    public Date getPlanetenzyklus_date() {
        return this.planetenzyklus_date;
    }

    public void setPlanetenzyklus_date(Date planetenzyklus_date) {
        this.planetenzyklus_date = planetenzyklus_date;
    }

    public boolean isBrandCosmicCompass() {
        return this.brandCosmicCompass;
    }

    public void setBrandCosmicCompass(boolean brandCosmicCompass) {
        this.brandCosmicCompass = brandCosmicCompass;
    }
}

