/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Geodaten;
import de.cni.common.exceptions.CalculationException;
import java.util.ArrayList;
import java.util.List;
import org.geonames.Style;
import org.geonames.Timezone;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WebService;

public class GeoWebservice {
    private final String username = "carsten&.nikel";
    private final int maxRows = 25;

    public List<IBusinessObject> search(Geodaten filter) throws CalculationException {
        return this.search(filter.getKontinent(), filter.getLkz(), filter.getPlz(), filter.getOrt());
    }

    public List<IBusinessObject> search(String continent, String lkz, String plz, String name) throws CalculationException {
        try {
            if (Util.isEmpty(name) || name.length() < 3) {
                throw new CalculationException("Sie m\u00fcssen eine Ort mit mind. 3 Buchstaben vorgeben");
            }
            ArrayList<IBusinessObject> geodatenList = new ArrayList<IBusinessObject>();
            WebService.setUserName("carsten&.nikel");
            ToponymSearchCriteria searchCriteria = new ToponymSearchCriteria();
            if (!Util.isEmpty(continent)) {
                searchCriteria.setContinentCode(continent);
            }
            if (!Util.isEmpty(lkz)) {
                searchCriteria.setCountryCode(lkz);
            }
            if (!Util.isEmpty(name)) {
                searchCriteria.setName(name);
            }
            searchCriteria.setMaxRows(25);
            searchCriteria.setLanguage("DE");
            searchCriteria.setStyle(Style.FULL);
            ToponymSearchResult searchResult = WebService.search(searchCriteria);
            for (Toponym toponym : searchResult.getToponyms()) {
                Geodaten geodaten = new Geodaten();
                geodaten.setKontinent(toponym.getContinentCode());
                geodaten.setOrt(toponym.getName());
                geodaten.setLkz(toponym.getCountryCode());
                geodaten.setName1(toponym.getAdminName1());
                geodaten.setName2(toponym.getAdminName2());
                geodaten.setName3(toponym.getAdminName3());
                geodaten.setCode1(toponym.getAdminCode1());
                geodaten.setCode2(toponym.getAdminCode2());
                geodaten.setCode3(toponym.getAdminCode3());
                geodaten.setLatitude(Double.toString(toponym.getLatitude()).replace(",", "."));
                geodaten.setLongitude(Double.toString(toponym.getLongitude()).replace(",", "."));
                Timezone t = toponym.getTimezone();
                geodaten.setElevation(Formatter.reportNumber(toponym.getElevation()));
                geodaten.setPopulation(Formatter.reportNumber(toponym.getPopulation()));
                geodaten.setTimezoneId(t.getTimezoneId());
                geodatenList.add(geodaten);
            }
            return geodatenList;
        }
        catch (Exception e) {
            throw new CalculationException("Der Web-Service kann momentan nicht aufgerufen werden. Fehler: " + e.getMessage());
        }
    }
}

