/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import java.io.IOException;
import java.util.Date;

public class FormattedStringBuffer {
    StringBuffer sb = new StringBuffer();

    public void reset() {
        this.sb = new StringBuffer();
    }

    public void blank() throws IOException {
        this.sb.append(" ");
    }

    public void blank(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.sb.append(" ");
        }
    }

    public void repeat(String s, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.sb.append(s);
        }
    }

    public void newLine() throws IOException {
        this.sb.append("\r\n");
    }

    public void csvSeparator() throws IOException {
        this.sb.append(";");
    }

    public void print(String text) throws IOException {
        this.sb.append(text);
    }

    public void printQuoted(String text) throws IOException {
        this.sb.append("'" + text + "'");
    }

    public void printDoubleQuoted(String text) throws IOException {
        this.sb.append("\"" + text + "\"");
    }

    public void print(Date text) throws IOException {
        this.sb.append(Converter.dateToString(text));
    }

    public void printCsv(String text) throws IOException {
        this.sb.append(text.replace(";", ""));
        this.csvSeparator();
    }

    public void printCsv(int text) throws IOException {
        this.sb.append(text);
        this.csvSeparator();
    }

    public void printCsv(double text) throws IOException {
        this.sb.append(text);
        this.csvSeparator();
    }

    public void printCsv(long text) throws IOException {
        this.sb.append(text);
        this.csvSeparator();
    }

    public void printCsv(Date text) throws IOException {
        this.sb.append(text);
        this.csvSeparator();
    }

    public void printSql(String text) throws IOException {
        this.sb.append(text.replace("Constants.DOS_NEWLINE", "\r\n"));
    }

    public void print(int text) throws IOException {
        this.sb.append(Formatter.pReportNumber(text));
    }

    public void print(long text) throws IOException {
        this.sb.append(Formatter.pReportNumber(text));
    }

    public void print(double text) throws IOException {
        this.sb.append(Formatter.reportNumber(text));
    }

    public void println(String text) throws IOException {
        this.sb.append(text);
        this.newLine();
    }

    public void println(int text) throws IOException {
        this.sb.append(text);
        this.newLine();
    }

    public void println(long text) throws IOException {
        this.sb.append(text);
        this.newLine();
    }

    public void println(double text) throws IOException {
        this.sb.append(text);
        this.newLine();
    }

    public void lprint(String text, int len) throws IOException {
        this.sb.append(Converter.stringToTrailingBlankString(Util.NotNull(text), len));
    }

    public void rprint(String text, int len) throws IOException {
        this.sb.append(Converter.stringToLeadingBlankString(Util.NotNull(text), len));
    }

    public void lprint(int ntext, int len) throws IOException {
        this.sb.append(Converter.stringToTrailingBlankString(Converter.intToString(ntext), len));
    }

    public void rprint(int ntext, int len) throws IOException {
        this.sb.append(Converter.stringToLeadingBlankString(Converter.intToString(ntext), len));
    }

    public void printLeading0(int ntext, int len) throws IOException {
        this.sb.append(Converter.stringToForceLeading0String(Converter.intToString(ntext), len));
    }

    public void lprint(long ntext, int len) throws IOException {
        this.sb.append(Converter.stringToTrailingBlankString(Converter.longToString(ntext), len));
    }

    public void rprint(long ntext, int len) throws IOException {
        this.sb.append(Converter.stringToLeadingBlankString(Converter.longToString(ntext), len));
    }

    public void lprint(double ntext, int len) throws IOException {
        this.sb.append(Converter.stringToTrailingBlankString(Converter.doubleToString(ntext), len));
    }

    public void rprint(double ntext, int len) throws IOException {
        this.sb.append(Converter.stringToLeadingBlankString(Converter.doubleToString(ntext), len));
    }

    public String toString() {
        return this.sb.toString();
    }

    public String toUnixString() {
        return this.sb.toString().replace("\r\n", "\n");
    }

    public StringBuffer getStringBuffer() {
        return this.sb;
    }
}

