/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileViewer
extends ApplicationWindow {
    Text text;
    String content;
    String lineDelimiter;
    String path = null;
    String filename = null;
    Action actionReadFile = new Action("\u00d6ffnen", null){

        public void run() {
            String file = FileViewer.this.filename;
            if (file != null) {
                try {
                    String content = FileViewer.readFileAsAString(new File(file));
                    FileViewer.this.text.setText(content);
                    FileViewer.this.setStatus("Datei erfolgreich geladen: " + file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileViewer.this.setStatus("Fehler beim Laden der Datei: " + file);
                }
            }
        }
    };
    Action actionOpenFile = new Action("\u00d6ffnen", null){

        public void run() {
            String file = FileViewer.this.filename;
            FileDialog dialog = new FileDialog(FileViewer.this.getShell(), 4096);
            dialog.setFilterPath(FileViewer.this.path);
            file = dialog.open();
            if (file != null) {
                try {
                    String content = FileViewer.readFileAsAString(new File(file));
                    FileViewer.this.text.setText(content);
                    FileViewer.this.setStatus("Datei erfolgreich geladen: " + file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileViewer.this.setStatus("Fehler beim Laden der Datei: " + file);
                }
            }
        }
    };

    public void setPathAndFile(String path, String filename) {
        this.path = path;
        this.filename = filename;
    }

    public FileViewer(Shell parentShell) {
        super(parentShell);
        this.addMenuBar();
        this.addStatusLine();
        this.addToolBar(0x800000);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText("FileViewer");
        this.setStatus("Bereit");
        this.text = new Text(parent, 2818);
        this.text.setSize(300, 200);
        this.text.setEditable(false);
        if (this.filename != null) {
            this.actionReadFile.run();
        }
        return this.text;
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("");
        MenuManager fileMenuManager = new MenuManager("&Datei");
        fileMenuManager.add((IAction)this.actionOpenFile);
        menuManager.add((IContributionItem)fileMenuManager);
        return menuManager;
    }

    protected StatusLineManager createStatusLineManager() {
        return super.createStatusLineManager();
    }

    public static String readFileAsAString(File file) throws IOException {
        return new String(FileViewer.getBytesFromFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        try {
            int offset;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Die Datei ist zu gro\u00df! (Limit: 2GB)");
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Fehler beim Lesen der Datei " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static void open(String path, String filename) {
        FileViewer viewer = new FileViewer(MainApplicationWindow.getInstance().getShell());
        viewer.setPathAndFile(path, filename);
        viewer.setBlockOnOpen(true);
        viewer.open();
    }
}

