/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExeExecuter {
    private static Log log = LogFactory.getLog(ExeExecuter.class);
    private long timeout = Long.MAX_VALUE;

    public ExeExecuter() {
    }

    public ExeExecuter(long timeout) {
        this.timeout = timeout;
    }

    public String execute(String command, String[] env) throws IOException, TimeoutException {
        Process p = Runtime.getRuntime().exec(command, env);
        Timer timer = new Timer();
        timer.schedule((TimerTask)new InterruptScheduler(Thread.currentThread()), this.timeout * 1000L);
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            p.destroy();
            throw new TimeoutException(command + " hat den Timeout nach " + this.timeout + " Sekunden \u00fcberschritten.");
        }
        finally {
            timer.cancel();
        }
        StringBuilder buffer = new StringBuilder();
        BufferedInputStream br = new BufferedInputStream(p.getInputStream());
        while (br.available() != 0) {
            buffer.append((char)br.read());
        }
        String res = buffer.toString().trim();
        return res;
    }

    public static void main(String[] args) {
        ExeExecuter r = new ExeExecuter(3000L);
        try {
            log.debug((Object)r.execute("\"C:/Programme/Adobe/Reader 9.0/Reader/AcroRd32.exe\"", null));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }

    private class InterruptScheduler
    extends TimerTask {
        Thread target = null;

        public InterruptScheduler(Thread target) {
            this.target = target;
        }

        @Override
        public void run() {
            this.target.interrupt();
        }
    }
}

