/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.client.gui.popup.filter.PopupAnalyseSchluesselThemaTile;
import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.GlobalData;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.exceptions.CalculationException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Datensicherung {
    private static Log log = LogFactory.getLog(PopupAnalyseSchluesselThemaTile.class);

    public static void automatischeSicherung() {
        try {
            if (!GlobalData.getInstance().getSettings().isAutomatischeSicherung()) {
                return;
            }
            Date last = GlobalData.getInstance().getSettings().getLetzteSicherung();
            int days = GlobalData.getInstance().getSettings().getSicherungTage();
            if (last == null || DateUtil.getDiffInDays(DateUtil.getToday(), last) > (long)days) {
                Datensicherung.automatischeSicherungWorker();
                SqLiteDatabase db = new SqLiteDatabase();
                db.setDbSicherung();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, "Die autmatische Datenbank-Sicherung ist fehlgeschlagen! ", e);
        }
    }

    private static void automatischeSicherungWorker() {
        try {
            String dbFile = "./db/cosmiccompass.db";
            File src = new File(dbFile);
            String timestamp = Converter.timeToExactSortableString(new Date());
            String vorgabePfad = GlobalData.getInstance().getSettings().getBackupDir();
            String vorgabeDateiname = "cosmiccompass" + timestamp + ".db";
            String newFilename = vorgabePfad + "/" + vorgabeDateiname;
            File dest = new File(newFilename);
            FileUtils.copyFile((File)src, (File)dest);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public static void manuelleSicherung() {
        try {
            String dbFile = "./db/cosmiccompass.db";
            File src = new File(dbFile);
            String timestamp = Converter.timeToExactSortableString(new Date());
            String vorgabePfad = GlobalData.getInstance().getSettings().getBackupDir();
            String vorgabeDateiname = "cosmiccompass" + timestamp + ".db";
            String newFilename = PopupFileDialog.openSaveDatabaseFileDialog("Bitte w\u00e4hlen Sie ein Verzeichnis f\u00fcr die Sicherung aus", vorgabePfad, vorgabeDateiname);
            if (Util.isEmpty(newFilename)) {
                return;
            }
            File dest = new File(newFilename);
            FileUtils.copyFile((File)src, (File)dest);
            Popup.info("Das Datenbank Backup war erfolgreich!");
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public static void manuelleRuecksicherung() {
        try {
            boolean ret = Popup.question("Achtung, ein Backup Ihrer Daten wird eingespielt.\n\nAlle aktuell vorhandenen Daten werden dabei \u00fcberschrieben.\n\nSind Sie sicher, dass Sie diese Aktion fortsetzen m\u00f6chten?");
            if (!ret) {
                return;
            }
            String vorgabe = "cosmiccompass*.db";
            String srcFilename = PopupFileDialog.openReadDatabaseFileDialog("Bitte w\u00e4hlen Sie eine Sicherungsdatei aus.", vorgabe);
            if (Util.isEmpty(srcFilename)) {
                return;
            }
            Datensicherung.datenruecksicherung(srcFilename);
            Popup.info("Das Backup wurde erfolgreich eingespielt.\n\nBitte starten Sie CosmicCompass neu, bevor Sie weiterarbeiten!");
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public static void datenruecksicherung(String srcFilename) throws IOException, ClassNotFoundException, SQLException, CalculationException {
        String dbFile = "./db/cosmiccompass.db";
        File dest = new File(dbFile);
        File src = new File(srcFilename);
        FileUtils.copyFile((File)src, (File)dest);
        SqLiteDatabase db = new SqLiteDatabase();
        db.excecuteDbUpdateIfRequired();
    }
}

