/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.DateUtil;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Converter {
    private static Log log = LogFactory.getLog(Converter.class);

    public static String file2String(String filename) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
        StringBuffer buffer = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buffer.append(line);
        }
        in.close();
        return buffer.toString();
    }

    public static void string2File(String filename, String data) throws IOException {
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
        BufferedWriter out = new BufferedWriter(streamWriter);
        out.append(data);
        out.close();
    }

    public static Collection<String> file2Collection(String filename, String exclude) throws IOException {
        String line;
        ArrayList<String> collection = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while ((line = in.readLine()) != null) {
            if (exclude != null && !exclude.equals("") && line.startsWith(exclude)) continue;
            collection.add(line);
        }
        in.close();
        return collection;
    }

    public static Collection<String> file2Collection(String filename) throws IOException {
        return Converter.file2Collection(filename, null);
    }

    public static String inputStream2String(InputStream inputStream, String encoding) throws IOException {
        String decodedString;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, encoding));
        StringBuffer buffer = new StringBuffer();
        while ((decodedString = in.readLine()) != null) {
            buffer.append(decodedString);
        }
        in.close();
        return buffer.toString();
    }

    public static String[] dir2SortedArray(String dirName) throws IOException {
        File testDir = new File(dirName);
        Object[] fileListe = testDir.list();
        if (fileListe == null) {
            throw new IOException("Das Verzeichnis " + dirName + " existiert nicht");
        }
        if (fileListe.length == 0) {
            throw new IOException("Im Verzeichnis " + dirName + " befinden sich keine Dateien");
        }
        Arrays.sort(fileListe);
        return fileListe;
    }

    public static String booleanToString(boolean x) {
        return !x ? "false" : "true";
    }

    public static int booleanTo01String(boolean x) {
        return !x ? 0 : 1;
    }

    public static String booleanToGuiString(Boolean x) {
        return x == false ? "Nein" : "Ja";
    }

    public static String booleanToNullString(boolean x) {
        return !x ? "" : "true";
    }

    public static boolean stringToBoolean(String x) {
        return x.equalsIgnoreCase("true") || x.equals("1") || x.equalsIgnoreCase("JA") || x.equalsIgnoreCase("J") || x.equalsIgnoreCase("X");
    }

    public static String dateToSortableString(Date x) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(x);
    }

    public static String dateToShortString(Date x) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("ddMMyy");
        return format.format(x);
    }

    public static String dateToLongString(Date x) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("ddMMyyyy");
        return format.format(x);
    }

    public static String dateToString(Date x) {
        return Converter.dateToString(x, null);
    }

    public static String dateToString(Date x, String timezoneString) {
        if (Util.isEmpty(x)) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        if (!Util.isEmpty(timezoneString)) {
            format.setTimeZone(TimeZone.getTimeZone(timezoneString));
        }
        return format.format(x);
    }

    public static String dateToSqlString(Date x) {
        if (Util.isEmpty(x)) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(x);
    }

    public static String timeToSqlString(Date x) {
        if (Util.isEmpty(x)) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(x);
    }

    public static String timeToUtcSqlString(Date x) {
        if (Util.isEmpty(x)) {
            return "";
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(utc);
        return format.format(x);
    }

    public static String timeToSqLiteString(Date x) {
        if (Util.isEmpty(x)) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return format.format(x);
    }

    public static synchronized String timeToSortableString(Date x) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(x);
    }

    public static synchronized String timeToExactSortableString(Date x) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return format.format(x);
    }

    public static String timeToString(Date x) {
        return Converter.datetimeToString(x, null);
    }

    public static String datetimeToString(Date x, String timezoneString) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (!Util.isEmpty(timezoneString)) {
            format.setTimeZone(TimeZone.getTimeZone(timezoneString));
        }
        return format.format(x);
    }

    public static String datetimeToHHmmString(Date x, String timezoneString) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        if (!Util.isEmpty(timezoneString)) {
            format.setTimeZone(TimeZone.getTimeZone(timezoneString));
        }
        return format.format(x);
    }

    public static String datetimeToCetString(Date x) {
        return Converter.datetimeToGmtString(x, null);
    }

    public static String timeToHHmmString(Date x) {
        return Converter.timeToHHmmString(x, null);
    }

    public static String timeToHHmmString(Date x, String timezoneString) {
        if (x == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        if (!Util.isEmpty(timezoneString)) {
            format.setTimeZone(TimeZone.getTimeZone(timezoneString));
        }
        return format.format(x);
    }

    public static String datetimeToGmtOnlyString(Date d, String timezoneId) {
        DateTime dt = DateUtil.date2JodaDate(d, timezoneId);
        String s = DateUtil.jodaDateTime2LocalHHmmTimeString(dt);
        String offset = Converter.gmtOffsetInHoursToOffsetString(DateUtil.getTimeZoneOffsetInHours(dt, timezoneId));
        s = s + " GMT" + offset;
        return s;
    }

    public static String datetimeToGmtString(Date d, String timezoneId) {
        return Converter.datetimeToGmtOnlyString(d, timezoneId);
    }

    public static String datetimeToGmtOnlyString(Date d, int offsetInMinutes) {
        DateTime dt = new DateTime((Object)d, DateTimeZone.UTC);
        dt = dt.plusMinutes(offsetInMinutes);
        String s = DateUtil.jodaDateTime2LocalHHmmTimeString(dt);
        s = s + " GMT" + Converter.gmtOffsetInMinutesToOffsetString(offsetInMinutes);
        return s;
    }

    public static String datetimeToGmtString(Date d, int offsetInMinutes) {
        return Converter.datetimeToGmtOnlyString(d, offsetInMinutes);
    }

    public static Date stringToDate(String x) {
        return Converter.stringToDate(x, null);
    }

    public static Date stringToUtcDate(String x) {
        return Converter.stringToDate(x, "UTC");
    }

    public static Date stringToDate(String x, String timezoneString) {
        if (Util.isEmpty(x)) {
            return null;
        }
        if (Util.equals(x, "00000000")) {
            return null;
        }
        try {
            SimpleDateFormat format;
            if (x.length() == 8) {
                format = new SimpleDateFormat("yyyyMMdd");
            } else if (x.length() == 10) {
                format = new SimpleDateFormat("dd.MM.yyyy");
            } else if (x.length() == 6) {
                x = x.substring(0, 4) + "20" + x.substring(4);
                format = new SimpleDateFormat("ddMMyyyy");
            } else {
                format = x.length() == 16 ? new SimpleDateFormat("dd.MM.yyyy HH:mm") : (x.length() == 19 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("dd.MM.yyyy"));
            }
            if (!Util.isEmpty(timezoneString)) {
                format.setTimeZone(TimeZone.getTimeZone(timezoneString));
            }
            Date date = format.parse(x);
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String prepareDateString(String text, int threshold) {
        if (text.contains(".") && text.lastIndexOf(".") < 9 && text.lastIndexOf(".") != text.indexOf(".")) {
            String year = text.substring(text.lastIndexOf(".") + 1, text.length());
            if (year.length() > 4) {
                return "";
            }
            if (year.length() == 1) {
                year = "0" + year;
            }
            if (year.length() == 2) {
                String newText;
                text = newText = text.substring(0, text.lastIndexOf(".")) + Converter.formattedYear(year, threshold);
            }
        } else if (!text.contains(".") && text.length() == 8) {
            String newText;
            text = newText = text.substring(0, 2) + "." + text.substring(2, 4) + "." + text.substring(4, 8);
        } else if (text.length() == 6 && !text.contains(".")) {
            String newText;
            text = newText = text.substring(0, 2) + "." + text.substring(2, 4) + Converter.formattedYear(text.substring(4, 6), threshold);
        }
        return text;
    }

    private static String formattedYear(String year, int threshold) {
        String newYear = Integer.parseInt(year) >= threshold ? ".19" + year : ".20" + year;
        return newYear;
    }

    public static Calendar dateToCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date guiStringToDate(String text, int threshold) {
        try {
            String preparedString = Converter.prepareDateString(text, threshold);
            Date date = new SimpleDateFormat("dd.MM.yyyy").parse(preparedString);
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date stringToUtcTime(String x) {
        return Converter.stringToTime(x, "UTC");
    }

    public static Date stringToEtcTime(String x) {
        return Converter.stringToTime(x, "ETC");
    }

    public static Date stringToTime(String x) {
        return Converter.stringToTime(x, null);
    }

    public static Date stringToTime(String x, String timezoneString) {
        SimpleDateFormat format = x.length() == 14 ? new SimpleDateFormat("yyyyMMddHHmmss") : new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        try {
            if (!Util.isEmpty(timezoneString)) {
                format.setTimeZone(TimeZone.getTimeZone(timezoneString));
            }
            Date date = format.parse(x);
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String intToNotNullString(int x) {
        if (x == 0) {
            return "";
        }
        return Integer.toString(x);
    }

    public static String doubleToNotNullString(double x) {
        if (x == 0.0) {
            return "";
        }
        return Formatter.reportNumber(x);
    }

    public static String longToNotNullString(long x) {
        if (x == 0L) {
            return "";
        }
        return Long.toString(x);
    }

    public static String intToString(int x) {
        return Integer.toString(x);
    }

    public static String longToString(long x) {
        return Long.toString(x);
    }

    public static String doubleToString(double x) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(x);
    }

    public static String doubleToLeadingBlankString(double x, int max) {
        DecimalFormat df = new DecimalFormat("0.00");
        return Converter.stringToLeadingBlankString(df.format(x), max);
    }

    public static String intToForceLeading0String(int x, int max) {
        String s = Integer.toString(x);
        int l = s.length();
        if (l < max) {
            while (l < max) {
                s = "0" + s;
                ++l;
            }
        }
        return s;
    }

    public static String intToLeading0String(Integer x, int max) {
        if (x == null || x == 0) {
            return "";
        }
        return Converter.intToForceLeading0String(x, max);
    }

    public static String stringToLeadingBlankString(String s, int max) {
        StringBuffer sb = new StringBuffer();
        int l = s.length();
        if (l < max) {
            while (l < max) {
                sb.append(" ");
                ++l;
            }
        }
        sb.append(s);
        return sb.toString();
    }

    public static String stringToTrailingBlankString(String s, int max) {
        int l = s.length();
        if (l < max) {
            while (l < max) {
                s = s + " ";
                ++l;
            }
        } else if (l > max) {
            s = Util.cutString(s, max);
        }
        return s;
    }

    public static String longToForceLeading0String(long x, int max) {
        String s = Long.toString(x);
        int l = s.length();
        if (l < max) {
            while (l < max) {
                s = "0" + s;
                ++l;
            }
        }
        return s;
    }

    public static String longToLeading0String(long x, int max) {
        if (x == 0L) {
            return "";
        }
        return Converter.longToForceLeading0String(x, max);
    }

    public static String doubleToForceLeading0String(double x, int max) {
        String s = Converter.doubleToString(x);
        int l = s.length();
        if (l < max) {
            while (l < max) {
                s = "0" + s;
                ++l;
            }
        }
        return s;
    }

    public static String doubleToLeading0String(double x, int max) {
        if (x == 0.0) {
            return "";
        }
        return Converter.doubleToForceLeading0String(x, max);
    }

    public static String stringToForceLeading0String(String value, int max) {
        int l;
        if (value == null) {
            value = "";
        }
        if ((l = value.length()) < max) {
            while (l < max) {
                value = "0" + value;
                ++l;
            }
        }
        return value;
    }

    public static String stringToLeading0String(String value, int max) {
        if (Util.isEmpty(value)) {
            return "";
        }
        return Converter.stringToForceLeading0String(value, max);
    }

    public static int stringToInt(String x) {
        if (x == null || "".equals(x)) {
            return 0;
        }
        return Integer.parseInt(x);
    }

    public static long stringToLong(String x) {
        if (x == null || "".equals(x)) {
            return 0L;
        }
        return Long.parseLong(x);
    }

    public static double stringToDouble(String x) {
        if (x == null || "".equals(x)) {
            return 0.0;
        }
        return Double.parseDouble(x);
    }

    public static double germanStringToDouble(String x) {
        x = x.replace(".", "");
        x = x.replace(",", ".");
        return Converter.stringToDouble(x);
    }

    public static int stringToIntIgnoreChars(String x) {
        String text = Converter.stringToNumberStringIgnoreChars(x);
        if (Util.isEmpty(text)) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    public static String stringToNumberStringIgnoreChars(String x) {
        StringBuffer buffer = new StringBuffer();
        for (char c : x.toCharArray()) {
            if (c < '0' || c > '9') continue;
            buffer.append(c);
        }
        String text = buffer.toString();
        return text;
    }

    public static String stringToHex(String input) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < input.getBytes().length; ++i) {
            String hex_data;
            int data = input.getBytes()[i];
            if (data < 0) {
                data += 256;
            }
            if ((hex_data = Integer.toHexString(data)).length() == 1) {
                hex_data = "0" + hex_data;
            }
            res.append(input.charAt(i));
            res.append(" = 0x");
            res.append(hex_data);
            res.append("\n");
            log.info((Object)(input.charAt(i) + " = 0x" + hex_data));
        }
        return res.toString();
    }

    public static double numberToDouble(Object n) {
        try {
            if (n instanceof Double || n instanceof Float) {
                return (Double)n;
            }
            if (n instanceof Long || n instanceof Integer) {
                return new Double(((Long)n).longValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public static String trimLeadingZeros(String source) {
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '0' || Character.isSpaceChar(c)) continue;
            return source.substring(i);
        }
        return source;
    }

    public static String stringToPhonetic(String x, int maxLength) {
        if (x == null) {
            return null;
        }
        String ret = x.toUpperCase().replace("\u00c4", "AE").replace("\u00d6", "OE").replace("\u00dc", "UE").replace("\u00df", "SS");
        if (maxLength > 0 && ret.length() > maxLength) {
            ret = ret.substring(0, maxLength);
        }
        return ret;
    }

    public static String stringToBankFormat(String x, int maxLength) {
        if (x == null) {
            return Converter.stringToTrailingBlankString("", maxLength);
        }
        String ret = Converter.stringToPhonetic(x, maxLength);
        ret = ret.replace(":", "").replace("_", "");
        if (maxLength > 0 && ret.length() > maxLength) {
            ret = ret.substring(0, maxLength);
        }
        ret = ret.toUpperCase();
        return Converter.stringToTrailingBlankString(ret, maxLength);
    }

    public static String stringToKonstRepresetation(String x) {
        if (x == null) {
            return null;
        }
        String s = x.toUpperCase().replace("\u00c4", "AE").replace("\u00d6", "OE").replace("\u00dc", "UE").replace("\u00df", "SS").replace(" ", "");
        s = s.replace("_+", "_PLUS").replace("_-", "_MINUS");
        s = s.replace("-", "_").replace(".", "").replace("(", "").replace(")", "");
        return s;
    }

    public static String stringToStyledText(String x) {
        String undZeichen = "&";
        String kleinerZeichen = "<(?!(br/>|b>|b/>|i>|i/>|u>|u/>|sup>|sup/>|sub>|sub/))";
        if (Util.isEmpty(x)) {
            return x;
        }
        return x.replaceAll(undZeichen, "&amp;").replaceAll(kleinerZeichen, "&lt;").replace("\r\n", "<br/>").replace("\n", "<br/>");
    }

    public static String stringToHtmlText(String x) {
        return x.replaceAll("\u00e4", "&auml;").replaceAll("\u00f6", "&ouml;").replaceAll("\u00fc", "&uuml;").replaceAll("\u00df", "&szlig;").replaceAll("\u00c4", "&Auml;").replaceAll("\u00d6", "&Ouml;").replaceAll("\u00dc", "&Uuml;").replaceAll("\u00a9", "&copy;");
    }

    public static String stringToIntString(String s) {
        if (Util.isEmpty(s)) {
            return s;
        }
        int x = Converter.stringToInt(s);
        return Integer.toString(x);
    }

    public static String stringToLongString(String s) {
        if (Util.isEmpty(s)) {
            return s;
        }
        long x = Converter.stringToLong(s);
        return Long.toString(x);
    }

    public static String stringReplaceMiddle(String x, int pos, String rep) {
        if (x == null) {
            return null;
        }
        if (rep == null || pos - 1 + rep.length() > x.length()) {
            return x;
        }
        if (rep.length() == x.length()) {
            return rep;
        }
        x = x.substring(0, pos - 1) + rep + x.substring(pos - 1 + rep.length());
        return x;
    }

    public static String strip(String s, String quote) {
        return s.replaceAll("^" + quote + "|" + quote + "$", "");
    }

    public static String gmtOffsetInMinutesToOffsetString(int gmtOffsetInMinutes) {
        double offsetInHours = Util.round((double)gmtOffsetInMinutes / 60.0, -10);
        return Converter.gmtOffsetInHoursToOffsetString(offsetInHours);
    }

    public static String gmtOffsetInHoursToOffsetString(double gmtOffsetInHours) {
        DecimalFormat formatter = new DecimalFormat("0.#");
        String s = formatter.format(gmtOffsetInHours);
        if (!s.startsWith("-") && !s.startsWith("+")) {
            s = "+" + s;
        }
        return s;
    }

    public static int gmtStringToGmtOffsetInMinutes(String gmtOffset) {
        double offset = Converter.germanStringToDouble(gmtOffset);
        int ret = (int)(offset * 60.0);
        return ret;
    }

    public static int gmtOffset2GmtOffsetInMinutes(double offset) {
        return (int)Math.round(offset * 60.0);
    }

    public static double gmtOffsetInMinutes2GmtOffset(int minutes) {
        return Util.round((double)minutes / 60.0, -10);
    }
}

