/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.paint.Controlpanel;
import de.cni.common.calculation.AnalyseElement;
import de.cni.common.calculation.AnalyseElementList;
import de.cni.common.calculation.AnalyseResult;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Herrscher;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.RadixHelper;
import de.cni.common.calculation.TextanalyseCalculator;
import de.cni.common.calculation.Tupel;
import de.cni.common.core.Converter;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.MapUtils;
import de.cni.common.core.TexteHandler;
import de.cni.common.core.Util;
import de.cni.common.core.Verschluesselung;
import de.cni.common.datamodel.admin.AnalyseSchluesselThema;
import de.cni.common.exceptions.TechnicalException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TexteDrucken {
    private static Log log = LogFactory.getLog(TexteDrucken.class);
    Verschluesselung verschuesselung = new Verschluesselung();
    boolean core = false;
    int stufe = 0;
    String klasse = "";

    List<AnalyseResult> getAnalyseSchluesselThemaResult(AnalyseSchluesselThema object, Astrodaten ad) {
        String h;
        AnalyseResult result;
        List<Tupel> tkzList;
        String[] array;
        ArrayList<AnalyseResult> resultList = new ArrayList<AnalyseResult>();
        RadixHelper radixHelper = new RadixHelper(ad);
        int dreiGradRegelOffset = 3;
        if (!Util.isEmpty(object.getHaeuser())) {
            for (String h2 : array = object.getHaeuser().split(":")) {
                if (Util.equalsIgnoreCase("AKTUELL", h2 = h2.trim())) {
                    double winkel = radixHelper.getPersonenalterWinkel(ad.date, new Date());
                    h2 = Converter.intToString(radixHelper.getIntFirstHausByWinkel(winkel, dreiGradRegelOffset));
                }
                tkzList = radixHelper.getTkzByHaus(h2);
                for (Tupel tupel : tkzList) {
                    AnalyseResult result2 = new AnalyseResult();
                    result2.setHausFlag(true);
                    result2.setHaus(h2);
                    result2.setTkz(tupel.name);
                    resultList.add(result2);
                }
                List<String> pArray = radixHelper.getPlanetenByHaus(h2, dreiGradRegelOffset);
                for (String planet : pArray) {
                    result = new AnalyseResult();
                    result.setHausFlag(true);
                    result.setHaus(h2);
                    result.setPlanet(planet);
                    result.setTkz(radixHelper.getTkzByPlanet(planet));
                    resultList.add(result);
                }
            }
        }
        if (!Util.isEmpty(object.getTkzs())) {
            for (String tkz : array = object.getTkzs().split(":")) {
                tkz = tkz.trim();
                List<String> pArray = radixHelper.getPlanetenByTkz(tkz);
                List<Tupel> hausList = radixHelper.getHausByTkz(tkz);
                for (Tupel t : hausList) {
                    result = new AnalyseResult();
                    result.setTkzFlag(true);
                    result.setTkz(tkz);
                    result.setHaus(t.name);
                    resultList.add(result);
                }
                for (String planet : pArray) {
                    result = new AnalyseResult();
                    result.setTkzFlag(true);
                    result.setTkz(tkz);
                    h = radixHelper.getHausByPlanet(planet, dreiGradRegelOffset);
                    result.setHaus(h);
                    result.setPlanet(planet);
                    resultList.add(result);
                }
            }
        }
        if (!Util.isEmpty(object.getPlaneten())) {
            for (String planet : array = object.getPlaneten().split(":")) {
                planet = planet.trim();
                AnalyseResult result3 = new AnalyseResult();
                result3.setPlanetFlag(true);
                result3.setPlanet(planet);
                String h3 = radixHelper.getHausByPlanet(planet, dreiGradRegelOffset);
                result3.setHaus(h3);
                result3.setPlanet(planet);
                result3.setTkz(radixHelper.getTkzByPlanet(planet));
                resultList.add(result3);
            }
        }
        if (!Util.isEmpty(object.getHerrscher())) {
            for (String herrscher : array = object.getHerrscher().split(":")) {
                herrscher = herrscher.trim();
                tkzList = new ArrayList<Tupel>();
                if (Util.isInt(herrscher)) {
                    List<Tupel> tupelList = radixHelper.getTkzByHaus(Converter.stringToInt(herrscher));
                    for (Tupel tupel : tupelList) {
                        tkzList.add((Tupel)((Object)tupel.name));
                    }
                } else {
                    String tkz = radixHelper.getTkzByPlanet(herrscher);
                    tkzList.add((Tupel)((Object)tkz));
                }
                for (String string : tkzList) {
                    String planet;
                    planet = Herrscher.getHerrscherPlanet(string);
                    result = new AnalyseResult();
                    result.setPlanet(planet);
                    h = radixHelper.getHausByPlanet(planet, dreiGradRegelOffset);
                    result.setHaus(h);
                    result.setPlanet(planet);
                    result.setTkz(radixHelper.getTkzByPlanet(planet));
                    resultList.add(result);
                }
            }
        }
        return resultList;
    }

    public String drucken(HoroskopCalculator horoskopCalculator, Controlpanel controlpanel) throws TechnicalException {
        TexteHandler textHandler = new TexteHandler(this.core, this.klasse, this.stufe);
        boolean eigeneAnalysetexte = controlpanel.isEigeneAnalysetexte();
        controlpanel.setEigeneAnalysetexte(true);
        TextanalyseCalculator ac = horoskopCalculator.getAstrodaten2() != null ? new TextanalyseCalculator(controlpanel, horoskopCalculator.getAstrodaten1(), horoskopCalculator.getAstrodaten2(), null) : new TextanalyseCalculator(controlpanel, horoskopCalculator.getAstrodaten1());
        AnalyseElementList list = ac.calculateKonstellation(3);
        Map<String, Integer> urlCntMap = new HashMap<String, Integer>();
        HashMap<String, String> urlKeyMap = new HashMap<String, String>();
        String total = "";
        total = total + "<h1>" + horoskopCalculator.getTitle() + "</h1>";
        total = total + "<br><br>";
        for (AnalyseElement a : list.getListAnalyseElement()) {
            String textkey = a.getAnalyse().getTextkey();
            String url = textHandler.getText(textkey, new int[]{0});
            if (!urlCntMap.containsKey(url)) {
                urlCntMap.put(url, 1);
            } else {
                urlCntMap.put(url, urlCntMap.get(url) + 1);
            }
            if (!urlKeyMap.containsKey(url)) {
                urlKeyMap.put(url, textkey);
                continue;
            }
            urlKeyMap.put(url, (String)urlKeyMap.get(url) + ", " + textkey);
        }
        urlCntMap = MapUtils.sortByComparator(urlCntMap, false);
        for (String url : urlCntMap.keySet()) {
            String text;
            if (LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.ADMIN)) {
                int cnt = urlCntMap.get(url);
                total = total + (String)urlKeyMap.get(url) + " (" + cnt + ")";
                total = total + "<br><br>";
                if (!Util.isEmpty(url)) {
                    total = total + url;
                    total = total + "<br><br>";
                }
            } else if (LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.PROFESSIONAL)) {
                int cnt = urlCntMap.get(url);
                total = total + "H\u00e4ufigkeit: " + cnt;
                total = total + "<br><br>";
                if (!Util.isEmpty(url)) {
                    total = total + url;
                    total = total + "<br><br>";
                }
            }
            if (url.startsWith("URL:")) {
                url = url.substring(4);
            }
            if (Util.isEmpty(text = this.getUrlText(url))) continue;
            total = total + text;
            total = total + "<br><br>";
        }
        controlpanel.setEigeneAnalysetexte(eigeneAnalysetexte);
        return total;
    }

    private String getUrlText(String url) {
        if (url.endsWith("html")) {
            try {
                File f = new File(url);
                if (f.exists() && f.isFile()) {
                    String currentDir = System.getProperty("user.dir");
                    String baseTag = "<base href='file://" + currentDir + "/texte/' >";
                    String s = this.verschuesselung.fileToString(url);
                    s = s.replace("<head>", "<head>" + baseTag);
                    return s;
                }
            }
            catch (Exception e) {
                return "URL nicht gefunden: " + url;
            }
            return "";
        }
        return url;
    }
}

