/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.HousesPaintInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.TextanalyseCalculator;
import de.cni.common.calculation.Tupel;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RadixHelper {
    private static Log log = LogFactory.getLog(TextanalyseCalculator.class);
    Astrodaten astrodaten;

    public RadixHelper(Astrodaten astrodaten) {
        this.astrodaten = astrodaten;
    }

    public double[] getGradTkz(String tkzName) {
        double[] result = new double[2];
        double offset = -(this.astrodaten.housesInfo.getAc() + 180.0);
        result[0] = Trigo.grad(offset + (double)Tkz.getGrad(tkzName));
        result[1] = Trigo.grad(offset + (double)Tkz.getGradNext(tkzName));
        return result;
    }

    public double[] getGradHaus(String hausId) {
        return this.getGradHaus(Converter.stringToInt(hausId));
    }

    public double[] getGradHaus(int hausId) {
        double[] result = new double[]{Trigo.grad(this.astrodaten.getHausVonGrad(hausId)), Trigo.grad(this.astrodaten.getHausBisGrad(hausId))};
        return result;
    }

    private boolean hasTkz(double winkel, String tkz) {
        int myTkzId = this.getTkzId(tkz);
        double offset = -(this.astrodaten.housesInfo.getAc() + 180.0);
        String kuerzel = Tkz.name[myTkzId];
        double von = Trigo.grad(offset + (double)Tkz.getGrad(kuerzel));
        double bis = Trigo.grad(offset + (double)Tkz.getGradNext(kuerzel));
        return Trigo.isBetween(winkel, von, bis);
    }

    private boolean hasTkz(String planetName, String tkz) {
        int myTkzId = this.getTkzId(tkz);
        double offset = -(this.astrodaten.housesInfo.getAc() + 180.0);
        String kuerzel = Tkz.name[myTkzId];
        double von = Trigo.grad(offset + (double)Tkz.getGrad(kuerzel));
        double bis = Trigo.grad(offset + (double)Tkz.getGradNext(kuerzel));
        double gradPlanet = this.getGradPlanet(planetName);
        return Trigo.isBetween(gradPlanet, von, bis);
    }

    public String getTkzByPlanet(String planetName) {
        for (String tkz : Constants.tkz) {
            if (!this.hasTkz(planetName, tkz)) continue;
            return tkz;
        }
        return null;
    }

    public String getTkzByWinkel(double winkel) {
        for (String tkz : Constants.tkz) {
            if (!this.hasTkz(winkel, tkz)) continue;
            return tkz;
        }
        return null;
    }

    public String getHausByPlanet(String planetName, int dreiGradOffset) {
        return Converter.intToString(this.getIntFirstHausByPlanet(planetName, dreiGradOffset));
    }

    public int getIntFirstHausByPlanet(String planetName, int dreiGradOffset) {
        return this.getIntFirstHausByWinkel(this.getGradPlanet(planetName), dreiGradOffset);
    }

    public String getHausByWinkel(double winkel, int dreiGradOffset) {
        return Converter.intToString(this.getIntFirstHausByWinkel(winkel, dreiGradOffset));
    }

    public int getIntFirstHausByWinkel(double winkel, int dreiGradOffset) {
        double gradPlanet = Trigo.grad(winkel + (double)dreiGradOffset);
        for (int hausId = 0; hausId <= 12; ++hausId) {
            double bis;
            double von = Trigo.grad(this.astrodaten.getHausVonGrad(hausId));
            if (!Trigo.isBetween(gradPlanet, von, bis = Trigo.grad(this.astrodaten.getHausBisGrad(hausId)))) continue;
            if (hausId == 0) {
                return 12;
            }
            return hausId;
        }
        return 0;
    }

    public int getIntLastHausByPlanet(String planetName, int dreiGradOffset) {
        double gradPlanet = Trigo.grad(this.getGradPlanet(planetName) + (double)dreiGradOffset);
        for (int hausId = 13; hausId >= 1; --hausId) {
            double bis;
            double von = Trigo.grad(this.astrodaten.getHausVonGrad(hausId));
            if (!Trigo.isBetween(gradPlanet, von, bis = Trigo.grad(this.astrodaten.getHausBisGrad(hausId)))) continue;
            if (hausId == 13) {
                return 1;
            }
            return hausId;
        }
        return 0;
    }

    public List<Tupel> getTkzByHaus(String hausId) {
        return this.getTkzByHaus(Converter.stringToInt(hausId));
    }

    public List<Tupel> getTkzByHaus(int hausId) {
        ArrayList<Tupel> result = new ArrayList<Tupel>();
        double vonHaus = this.getGradHaus(hausId)[0];
        double bisHaus = this.getGradHaus(hausId)[1];
        for (String tkz : Constants.tkz) {
            double vonTkz = this.getGradTkz(tkz)[0];
            double bisTkz = this.getGradTkz(tkz)[1];
            if (!Trigo.isBetween(vonTkz, vonHaus, bisHaus) && !Trigo.isBetween(bisTkz, vonHaus, bisHaus) && !Trigo.isBetween(vonHaus, vonTkz, bisTkz) && !Trigo.isBetween(bisHaus, bisTkz, bisTkz)) continue;
            Tupel t = new Tupel();
            t.name = tkz;
            t.von = vonTkz;
            t.bis = bisTkz;
            t.masterVon = vonHaus;
            t.masterBis = bisHaus;
            result.add(t);
        }
        Collections.sort(result);
        return result;
    }

    public List<Tupel> getHausByTkz(String tkz) {
        ArrayList<Tupel> result = new ArrayList<Tupel>();
        double vonTkz = this.getGradTkz(tkz)[0];
        double bisTkz = this.getGradTkz(tkz)[1];
        for (int i = 1; i <= 12; ++i) {
            double vonHaus = this.getGradHaus(i)[0];
            double bisHaus = this.getGradHaus(i)[1];
            if (!Trigo.isBetween(vonHaus, vonTkz, bisTkz) && !Trigo.isBetween(bisHaus, vonTkz, bisTkz) && !Trigo.isBetween(vonTkz, vonHaus, bisHaus) && !Trigo.isBetween(bisTkz, bisHaus, bisHaus)) continue;
            Tupel t = new Tupel();
            t.name = Converter.intToString(i);
            t.von = vonHaus;
            t.bis = bisHaus;
            t.masterVon = vonTkz;
            t.masterBis = bisTkz;
            result.add(t);
        }
        Collections.sort(result);
        return result;
    }

    public double getGradPlanet(String planet) {
        Integer id1;
        HousesInfo hi = this.astrodaten.housesInfo;
        double ac = 180.0;
        double dc = 0.0;
        double mc = hi.getMcAbs();
        double ic = (mc + 180.0) % 360.0;
        if (Util.isEmpty(planet)) {
            // empty if block
        }
        if ((id1 = this.getPlanetId(planet)) == null) {
            // empty if block
        }
        double gradPlanet = 0.0;
        if (id1 == AspektariumCalculator.ID_AC) {
            gradPlanet = ac;
        } else if (id1 == AspektariumCalculator.ID_DC) {
            gradPlanet = dc;
        } else if (id1 == AspektariumCalculator.ID_MC) {
            gradPlanet = mc;
        } else if (id1 == AspektariumCalculator.ID_IC) {
            gradPlanet = ic;
        } else {
            double asc = this.astrodaten.housesInfo.getAc();
            gradPlanet = Trigo.grad(this.astrodaten.planet[id1].getTransferedLongitude(asc));
        }
        return gradPlanet;
    }

    public Integer getPlanetId(String name) {
        for (int i = 0; i < Constants.planeten.length; ++i) {
            if (!Util.equals(name, Constants.planeten[i])) continue;
            return i;
        }
        return null;
    }

    private Integer getTkzId(String name) {
        for (int i = 0; i < Constants.tkz.length; ++i) {
            if (!Util.equals(name, Constants.tkz[i])) continue;
            return i;
        }
        return null;
    }

    private String getAnalysePlanetName(Integer id) {
        if (id >= Constants.planeten.length) {
            return "";
        }
        return Constants.planeten[id];
    }

    public Astrodaten getAstrodaten() {
        return this.astrodaten;
    }

    public Date getCurrentSolarDate(Personendaten personendaten, int jahr) {
        Date date = DateUtil.dateReplaceYear(personendaten.getGeburtsdatum(), jahr);
        Date dateMin = DateUtil.dateAddHours(date, -48);
        Date dateMax = DateUtil.dateAddHours(date, 48);
        Astrodaten adGeburt = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), personendaten.getGeburtsdatum());
        Astrodaten adMin = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), dateMin);
        Astrodaten adMax = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), dateMax);
        double longGeburt = adGeburt.sun.getLongitude();
        double longMin = adMin.sun.getLongitude();
        double longMax = adMax.sun.getLongitude();
        SolarResult res = this.nextRecSolarDate(personendaten, adMin, adMax, longMin, longMax, dateMin, dateMax, longGeburt);
        return res.date;
    }

    private SolarResult nextRecSolarDate(Personendaten personendaten, Astrodaten adMin, Astrodaten adMax, double longMin, double longMax, Date min, Date max, double longGeburt) {
        Date middle = DateUtil.getMiddleDate(min, max);
        Astrodaten adMiddle = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), middle);
        double longMiddle = adMiddle.sun.getLongitude();
        double l1 = Math.abs(longGeburt - longMin);
        double l2 = Math.abs(longGeburt - longMax);
        long diff = DateUtil.getDiffInMillis(min, max);
        if (diff < 30000L) {
            SolarResult res = new SolarResult();
            res.date = middle;
            res.longitude = longMiddle;
            return res;
        }
        SolarResult res = l1 < l2 ? this.nextRecSolarDate(personendaten, adMin, adMiddle, longMin, longMiddle, min, middle, longGeburt) : this.nextRecSolarDate(personendaten, adMiddle, adMax, longMiddle, longMax, middle, max, longGeburt);
        return res;
    }

    public List<String> getPlanetenByTkz(String tkz) {
        ArrayList<String> list = new ArrayList<String>();
        double von = Trigo.grad(this.astrodaten.getTkzVonAbs(tkz));
        double bis = Trigo.grad(this.astrodaten.getTkzBisAbs(tkz));
        for (int planetId = 0; planetId < Constants.planeten.length; ++planetId) {
            String planetName = Constants.planeten[planetId];
            double gradPlanet = Trigo.grad(this.getGradPlanet(planetName));
            if (!Trigo.isBetween(gradPlanet, von, bis)) continue;
            list.add(planetName);
        }
        return list;
    }

    public List<String> getPlanetenByHaus(String haus, int dreiGradRegelOffset) {
        ArrayList<String> list = new ArrayList<String>();
        int hausId = Converter.stringToInt(haus);
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(hausId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(hausId));
        for (int planetId = 0; planetId < Constants.planeten.length; ++planetId) {
            String planetName = Constants.planeten[planetId];
            double gradPlanet = Trigo.grad(this.getGradPlanet(planetName) + (double)dreiGradRegelOffset);
            if (!Trigo.isBetween(gradPlanet, von, bis)) continue;
            list.add(planetName);
        }
        return list;
    }

    public List<String> getEchtePlanetenByHaus(String haus, int dreiGradRegelOffset) {
        ArrayList<String> list = new ArrayList<String>();
        int hausId = Converter.stringToInt(haus);
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(hausId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(hausId));
        for (int planetId = 0; planetId < AspektariumCalculator.anzPlaneten; ++planetId) {
            String planetName = Constants.planeten[planetId];
            double gradPlanet = Trigo.grad(this.getGradPlanet(planetName) + (double)dreiGradRegelOffset);
            if (!Trigo.isBetween(gradPlanet, von, bis)) continue;
            list.add(planetName);
        }
        return list;
    }

    public HousesPaintInfo getHousesPaintInfo() {
        HousesInfo hi = this.astrodaten.housesInfo;
        hi = this.astrodaten.housesInfo;
        HousesPaintInfo hpi = new HousesPaintInfo();
        for (int i = 0; i < HousesPaintInfo.anz; ++i) {
            String tkz;
            hpi.gradVonAbs[i] = hi.getHouseVonGrad(i);
            hpi.gradBisAbs[i] = hi.getHouseBisAbs(i);
            List<Tupel> t = this.getTkzByHaus(i);
            hpi.tkz[i] = tkz = t.get((int)0).name;
            hpi.icon[i] = Tkz.icon[Tkz.getPosition(tkz)];
            double von = hi.getHouse(i);
            hpi.gradVon[i] = Trigo.grad(von) % 30.0;
            hpi.gradBis[i] = 0.0;
        }
        return hpi;
    }

    public double getPersonenalterWinkel(Date geburtsdatum, Date today) {
        double bis;
        int house;
        int personAlter = Util.getDiffInYears(geburtsdatum, today);
        if (personAlter < 0) {
            personAlter = 0;
        }
        if (personAlter > 84) {
            personAlter = 84;
        }
        if ((house = 12 - personAlter / 7) > 12) {
            house = 12;
        }
        if (house < 0) {
            house = 0;
        }
        int restJahre = personAlter % 7;
        double von = this.astrodaten.getHausVonGrad(house);
        if (von > (bis = this.astrodaten.getHausBisGrad(house))) {
            bis += 360.0;
        }
        double winkelbereichHaus = Math.abs(bis - von);
        double winkelSchritte = winkelbereichHaus / 7.0;
        double winkel = Trigo.grad(bis - winkelSchritte * (double)restJahre);
        return winkel;
    }

    private class SolarResult {
        Date date;
        double longitude;

        private SolarResult() {
        }
    }
}

