/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.paint.ClickKoordinaten;
import de.cni.common.astrologie.Jahresring;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.AstrodatenMixer;
import de.cni.common.calculation.AstrodatenMultiMixer;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.SolarDate;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.ObjectCopier;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.TechnicalException;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HoroskopCalculator {
    private Horoskop horoskop;
    private List<IBusinessObject> personendatenList;
    private String gruppe;
    @Deprecated
    private Personendaten pd1;
    @Deprecated
    private Personendaten pd2;
    private Date date1Before;
    private Date date2Before;
    private Date date1;
    private Date date2;
    private boolean date1GmtOffsetManuell;
    private boolean date2GmtOffsetManuell;
    private String date1TimezoneId;
    private String date2TimezoneId;
    private int date1GmtOffsetInMinutes;
    private int date2GmtOffsetInMinutes;
    private String long1;
    private String lat1;
    private String long2;
    private String lat2;
    private Astrodaten astrodaten1;
    private Astrodaten astrodaten2;
    private ClickKoordinaten clickKoordinaten = new ClickKoordinaten(this);
    private int kompositSeptarHaus = 0;
    private int kompositSeptarHaus1 = 0;
    private int kompositSeptarHaus2 = 0;
    public static final String toolTipRadix = "Radix basierend auf Datum, Zeit und Ort";
    public static final String toolTipSolar = "Solar:\nDatum/Uhrzeit in einem anderen Jahr (Vorgabe: aktuelles Jahr),\nan dem die Sonne am Geburtsort den gleichen Stand wie zum Geburtszeitpunkt hat";
    public static final String toolTipSeptar = "Ein Septar ist ein Horoskop, das die 7er Rhythmuslehre nutzt. Es hilft, eine Lebensphase zu deuten, wobei jedes Haus 7 Monate entspricht.";
    public static final String toolTipKomposit = "Ein Composit ist eine Methode der Partnerschaftsastrologie, bei der aus den Horoskopen zweier Personen ein neues, gemeinsames Horoskop erstellt wird. Es hilft, die Schwerpunktthemen einer Beziehung schnell zu erkennen. (Halbsummentechnik)";
    public static final String toolTipKompoTransit = "KompositTransit:\nDarstellung: Mittelwert von zwei Kompositen\nKomposit1: Geburtsdatum, Geburtsort der Personen\nKomposit2: aktuelles Datum, aktueller Wohnort der Personen";
    public static final String toolTipMultiKomposit = "MultiKomposit:\nDarstellung: Mittelwert von mehreren Personen\nParameter:  Name der Gruppe";
    public static final String toolTipProgression = "Die Progression ist eine Methode, bei der ein Tag nach der Geburt einem Lebensjahr entspricht. Sie zeigt die Planetenstellungen zu bestimmten Zeitpunkten im Leben.";
    public static final String toolTipCombine = "Ein Combine erstellt aus den Geburtsdaten ein Horoskop. Es hat einen realen kosmischen Bezug, da es f\u00fcr einen bestimmten Zeitpunkt und Ort berechnet wird.";
    public static final String toolTipDirektion = "Die Sonnenbogendirektion ist eine Prognosemethode, bei der alle Planeten und Achsen pro Jahr um die Strecke verschoben werden, die die Sonne pro Tag nach der Geburt zur\u00fccklegte. Dies basiert auf dem wahren oder mittleren Sonnenbogen.";
    public static final String toolTipKompositSeptar = "KompositSeptar:\nDarstellung: Mittelwert von zwei Personen\nParameter Person1: Geburtsdatum, Geburtsort\nParameter Person2: Geburtsdatum, Geburtsort\nParameter: Haus\nWenn kein Haus angegeben wird, erfolgt die Berechung jeweils f\u00fcr den aktuellen Lebensabschnitts, ansonsten werden beide Sepatare f\u00fcr das vorgebenen Haus berechnet.";
    public static final String toolTipTemposit = "Temposit:\nDarstellung: Mittelwert von Geburts- und aktuellen Daten einer Personen\nParameter1: Geburtsdatum, Geburtsort\nParameter2: Solardatum, Wohnort\n\nSolardatum:  Datum/Uhrzeit in einem anderen Jahr (Vorgabe: aktuelles Jahr),\nan dem die Sonne am Geburtsort den gleichen Stand wie zum Geburtszeitpunkt hat";
    public static final String toolTipSeptosit = "Septosit:\nDarstellung: Mittelwert von Geburts- und aktuellen Daten einer Personen\nParameter1: Geburtsdatum, Geburtsort\nParameter2: Septardatum, Geburtsort\nDas Septardatum berechnet sich wie folgt:\n{Differenz} = {aktuelles Jahr} \u0096 {Geburtsjahr}\n{Berechnungsjahr}  = 12 - {Differenz} / 7 (Beginnend bei Haus 12 und dann R\u00fcckw\u00e4rts)\nDas {Berechnungsjahr}  wird zum Geburtsjahr hinzugez\u00e4hlt und daraus das Solardatum errechnet.\nDieser Zeitpunkt ist in der Berechnung das {Septardatum}, f\u00fcr dessen Zeitpunkt das Horoskop berechnet wird.\n";
    public static final String toolTipSynastrie = "Die Gegen\u00fcberstellung von zwei Personen. Bei einer Synastrie werden zwei Horoskope miteinander verglichen, indem die Planeten des einen Horoskops ins andere eingezeichnet werden.";
    public static final String toolTipTransit = "Ein Transit ist der Zeitraum, in dem ein Planet einen Aspekt zu einem anderen Horoskopfaktor bildet und zeigt den aktuellen Stand der Planeten im Kosmos an.";
    public static final String toolTipAktualitaet = "Der aktuelle Planetenstand in Bezug auf den Ort des Software Inhabers.";

    public ClickKoordinaten getClickKoordinaten() {
        return this.clickKoordinaten;
    }

    public void switchPersonendaten() {
        if (this.horoskop.getPlanetenSaetze() <= 1) {
            return;
        }
        if (this.pd2 != null) {
            Personendaten pd = this.pd2;
            this.pd2 = this.pd1;
            this.pd1 = pd;
        }
        String longitude = this.long2;
        this.long2 = this.long1;
        this.long1 = longitude;
        String latitude = this.lat2;
        this.lat2 = this.lat1;
        this.lat1 = latitude;
        Date date = this.date2;
        this.date2 = this.date1;
        this.date1 = date;
        this.recalculate();
    }

    public void calculateRadix(Personendaten pd1) throws TechnicalException {
        this.horoskop = Horoskop.Radix;
        this.pd1 = pd1;
        this.pd2 = null;
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = null;
        this.date2GmtOffsetManuell = false;
        this.date2TimezoneId = "";
        this.date2GmtOffsetInMinutes = 0;
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum ist nicht vorhanden.");
        }
        this.calculateRadix();
    }

    public void calculateRadix() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
        this.astrodaten2 = null;
    }

    public void calculateSolar(Personendaten pd1) throws TechnicalException {
        this.horoskop = Horoskop.Solar;
        this.pd1 = pd1;
        this.pd2 = null;
        int berechnungsjahr = DateUtil.getCurrentYear();
        int berechnungsmonat = DateUtil.getCurrentMonth();
        int berechnungstag = DateUtil.getCurrentDay();
        if (berechnungsmonat < DateUtil.getMonth(pd1.getGeburtsdatum())) {
            --berechnungsjahr;
        } else if (berechnungsmonat == DateUtil.getMonth(pd1.getGeburtsdatum()) && berechnungstag < DateUtil.getDay(pd1.getGeburtsdatum())) {
            --berechnungsjahr;
        }
        this.date1 = new SolarDate().getCurrentSolarDate(pd1, berechnungsjahr);
        this.date2GmtOffsetManuell = false;
        this.date2TimezoneId = DateTimeZone.getDefault().getID();
        this.date2GmtOffsetInMinutes = 0;
        this.date2 = null;
        this.date2GmtOffsetManuell = false;
        this.date2TimezoneId = "";
        this.date2GmtOffsetInMinutes = 0;
        this.long1 = pd1.getWohnortLongitude();
        this.lat1 = pd1.getWohnortLatitude();
        this.calculateSolar();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das aktuelle Berechnungsdatum ist nicht vorhanden.");
        }
    }

    public void calculateSolar() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
        this.astrodaten2 = null;
    }

    public void calculateSeptar(Personendaten pd1, int haus, Date currentDate) throws TechnicalException {
        this.horoskop = Horoskop.Septar;
        this.pd1 = pd1;
        this.pd2 = null;
        this.date1 = haus == 0 ? this.getInitialSeptarDate(pd1, currentDate) : this.getSeptarDateByHouse(pd1, haus);
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = null;
        this.date2GmtOffsetManuell = false;
        this.date2TimezoneId = "";
        this.date2GmtOffsetInMinutes = 0;
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.calculateSeptar();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das aktuelle Berechnungsdatum ist nicht vorhanden.");
        }
    }

    public void calculateSeptar() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
        this.astrodaten2 = null;
    }

    public void calculateKomposit(Personendaten pd1, Personendaten pd2) throws TechnicalException {
        this.horoskop = Horoskop.Komposit;
        this.date1 = null;
        this.pd1 = pd1;
        this.pd2 = pd2;
        this.date1 = pd1.getGeburtsdatum();
        this.date2 = pd2.getGeburtsdatum();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = pd2.getGeburtsdatum();
        this.date2GmtOffsetManuell = pd2.isGmtOffsetManuell();
        this.date2TimezoneId = pd2.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd2.getLongitude();
        this.lat2 = pd2.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die Geburtskoordinaten der zweiten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das Geburtsdatum der zweiten Person ist nicht vorhanden.");
        }
        this.calculateKomposit();
    }

    private void calculateKomposit() {
        AstrodatenMixer astrodatenMixer = new AstrodatenMixer(this.pd1, this.pd2, this.date1, this.date2);
        this.astrodaten1 = astrodatenMixer.getMixedAstrodaten();
        this.astrodaten2 = null;
    }

    public void calculateKompoTransit(Personendaten pd1, Personendaten pd2, Date currentDate) throws TechnicalException {
        this.horoskop = Horoskop.KompositTransit;
        this.date1 = null;
        this.pd1 = pd1;
        this.pd2 = pd2;
        this.date1 = pd1.getGeburtsdatum();
        this.date2 = pd2.getGeburtsdatum();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = pd2.getGeburtsdatum();
        this.date2GmtOffsetManuell = pd2.isGmtOffsetManuell();
        this.date2TimezoneId = pd2.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd2.getLongitude();
        this.lat2 = pd2.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die Geburtskoordinaten der zweiten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das Geburtsdatum der zweiten Person ist nicht vorhanden.");
        }
        this.date2 = currentDate;
        this.date2GmtOffsetManuell = false;
        this.date2TimezoneId = DateTimeZone.getDefault().getID();
        this.date2GmtOffsetInMinutes = 0;
        this.calculateKompositTransit();
    }

    private void calculateKompositTransit() {
        Date currentDate = this.date2;
        AstrodatenMixer astrodatenMixer1 = new AstrodatenMixer(this.pd1, this.pd2, this.pd1.getGeburtsdatum(), this.pd2.getGeburtsdatum());
        this.astrodaten1 = astrodatenMixer1.getMixedAstrodaten();
        AstrodatenMixer astrodatenMixer2 = new AstrodatenMixer(this.pd1, this.pd2, currentDate, currentDate, true);
        this.astrodaten2 = astrodatenMixer2.getMixedAstrodaten();
        this.astrodaten2.setOffset(this.getOffsetSatz2());
    }

    public void calculateMultiKomposit(String gruppe, List<IBusinessObject> list) throws TechnicalException {
        this.gruppe = gruppe;
        this.horoskop = Horoskop.MultiKomposit;
        this.personendatenList = list;
        this.date1 = null;
        this.pd1 = null;
        this.pd2 = null;
        if (list == null || list.size() == 0) {
            throw new TechnicalException("Es gibt keine Person, die der Gruppe angeh\u00f6rt");
        }
        this.calculateMultiKomposit();
    }

    private void calculateMultiKomposit() {
        AstrodatenMultiMixer astrodatenMixer = new AstrodatenMultiMixer(this.personendatenList);
        this.astrodaten1 = astrodatenMixer.getMixedAstrodaten();
        this.astrodaten2 = null;
    }

    public void calculateKompositSeptar(Personendaten pd1, Personendaten pd2, int haus) throws TechnicalException {
        this.horoskop = Horoskop.KompositSeptar;
        this.date1 = null;
        this.pd1 = pd1;
        this.pd2 = pd2;
        this.kompositSeptarHaus = haus;
        if (haus == 0) {
            Date currentDate = new Date();
            this.date1 = this.getInitialSeptarDate(pd1, currentDate);
            this.date2 = this.getInitialSeptarDate(pd2, currentDate);
            this.kompositSeptarHaus1 = this.getSeptarHaus(pd1.getGeburtsdatum(), this.date1);
            this.kompositSeptarHaus2 = this.getSeptarHaus(pd2.getGeburtsdatum(), this.date2);
        } else {
            this.kompositSeptarHaus1 = haus;
            this.kompositSeptarHaus2 = haus;
            this.date1 = this.getSeptarDateByHouse(pd1, haus);
            this.date2 = this.getSeptarDateByHouse(pd2, haus);
        }
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2GmtOffsetManuell = pd2.isGmtOffsetManuell();
        this.date2TimezoneId = pd2.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd2.getLongitude();
        this.lat2 = pd2.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die Geburtskoordinaten der zweiten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das Geburtsdatum der zweiten Person ist nicht vorhanden.");
        }
        this.calculateKompositSeptar();
    }

    private void calculateKompositSeptar() {
        AstrodatenMixer astrodatenMixer = new AstrodatenMixer(this.pd1, this.pd2, this.date1, this.date2);
        this.astrodaten1 = astrodatenMixer.getMixedAstrodaten();
        this.astrodaten2 = null;
    }

    public void calculateTemposit(Personendaten pd1) throws TechnicalException {
        this.horoskop = Horoskop.Temposit;
        this.date1 = null;
        this.pd1 = pd1;
        this.pd2 = pd1;
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = new SolarDate().getCurrentSolarDate(pd1, DateUtil.getCurrentYear());
        this.date2GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date2TimezoneId = pd1.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd1.getWohnortLongitude();
        this.lat2 = pd1.getWohnortLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die Geburtskoordinaten der zweiten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das Geburtsdatum der zweiten Person ist nicht vorhanden.");
        }
        this.calculateTemposit();
    }

    private void calculateTemposit() {
        AstrodatenMixer astrodatenMixer = new AstrodatenMixer(this.pd1, this.pd2, this.date1, this.date2);
        this.astrodaten1 = astrodatenMixer.getMixedAstrodaten();
        this.astrodaten2 = null;
    }

    public void calculateSeptosit(Personendaten pd1, Date currentDate) throws TechnicalException {
        this.horoskop = Horoskop.Septosit;
        this.date1 = null;
        this.pd1 = pd1;
        this.pd2 = pd1;
        this.date1 = pd1.getGeburtsdatum();
        this.date2 = this.getInitialSeptarDate(pd1, currentDate);
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2GmtOffsetInMinutes = 0;
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = this.getInitialSeptarDate(pd1, currentDate);
        this.date2GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date2TimezoneId = pd1.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd1.getLongitude();
        this.lat2 = pd1.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die Geburtskoordinaten der zweiten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das Geburtsdatum der zweiten Person ist nicht vorhanden.");
        }
        this.calculateSeptosit();
    }

    private void calculateSeptosit() {
        AstrodatenMixer astrodatenMixer = new AstrodatenMixer(this.pd1, this.pd2, this.date1, this.date2);
        this.astrodaten1 = astrodatenMixer.getMixedAstrodaten();
        this.astrodaten2 = null;
    }

    public void calculateSynastrie(Personendaten pd1, Personendaten pd2) throws TechnicalException {
        this.horoskop = Horoskop.Synastrie;
        this.pd1 = pd1;
        this.pd2 = pd2;
        this.date1 = pd1.getGeburtsdatum();
        this.date2 = pd2.getGeburtsdatum();
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = pd2.getGeburtsdatum();
        this.date2GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date2TimezoneId = pd1.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd2.getLongitude();
        this.lat2 = pd2.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die Geburtskoordinaten der zweiten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das Geburtsdatum der zweiten Person ist nicht vorhanden.");
        }
        this.calculateSynastrie();
    }

    private void calculateSynastrie() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
        this.astrodaten2 = new Astrodaten(this.long2, this.lat2, this.date2);
        this.astrodaten2.setOffset(this.getOffsetSatz2());
    }

    public void calculateTransit(Personendaten pd1, Date currentDate) throws TechnicalException {
        this.horoskop = Horoskop.Transit;
        this.pd1 = pd1;
        this.pd2 = null;
        this.date1 = pd1.getGeburtsdatum();
        this.date2 = currentDate;
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = currentDate;
        this.date2GmtOffsetManuell = false;
        this.date2TimezoneId = DateTimeZone.getDefault().getID();
        this.date2GmtOffsetInMinutes = 0;
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd1.getWohnortLongitude();
        this.lat2 = pd1.getWohnortLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordianten der Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die aktuellen Wohnort Koordinaten der Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das aktuelle Vergleichsdatum ist nicht vorhanden.");
        }
        this.calculateTransit();
    }

    private void calculateTransit() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
        this.astrodaten2 = new Astrodaten(this.long2, this.lat2, this.date2);
        this.astrodaten2.setOffset(this.getOffsetSatz2());
    }

    public void calculateAktualitaet(Personendaten pd1, Date currentDate) throws TechnicalException {
        this.horoskop = Horoskop.Aktualitaet;
        this.pd1 = pd1;
        this.pd2 = null;
        this.date1 = currentDate;
        this.date2 = null;
        this.date1 = currentDate;
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.long1 = pd1.getAktuellLongitude();
        this.lat1 = pd1.getAktuellLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Bitte zun\u00e4chste den Reiter 'aktueller Ort' ausf\u00fcllen, sonst ist eine Berechnung nicht m\u00f6glich.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das aktuelle Datum ist nicht vorhanden.");
        }
        this.calculateAktualitaet();
    }

    private void calculateAktualitaet() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
    }

    public void calculateCombine(Personendaten pd1, Personendaten pd2) throws TechnicalException {
        this.horoskop = Horoskop.Combine;
        this.date1 = null;
        this.pd1 = pd1;
        this.pd2 = pd2;
        this.date1 = pd1.getGeburtsdatum();
        this.date2 = pd2.getGeburtsdatum();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.date2 = pd2.getGeburtsdatum();
        this.date2GmtOffsetManuell = pd2.isGmtOffsetManuell();
        this.date2TimezoneId = pd2.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd2.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.long2 = pd2.getLongitude();
        this.lat2 = pd2.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.long2) || Util.isEmpty(this.lat2)) {
            throw new TechnicalException("Die Geburtskoordinaten der zweiten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        if (Util.isEmpty(this.date2)) {
            throw new TechnicalException("Das Geburtsdatum der zweiten Person ist nicht vorhanden.");
        }
        this.calculateCombine();
    }

    private void calculateCombine() {
        this.date1 = Util.calculateAverage(this.pd1.getGeburtsdatum(), this.pd2.getGeburtsdatum());
        String latitude = Util.calculateAverage(this.pd1.getLatitude(), this.pd2.getLatitude());
        String longitude = Util.calculateAverage(this.pd1.getLongitude(), this.pd2.getLongitude());
        this.setRelevantDate(this.date1);
        this.lat1 = latitude;
        this.long1 = longitude;
        this.astrodaten1 = new Astrodaten(longitude, latitude, this.date1);
    }

    public void calculateProgression(Personendaten pd1, Date currentDate) throws TechnicalException {
        double alter;
        this.horoskop = Horoskop.Progression;
        this.pd1 = pd1;
        this.pd2 = null;
        this.date1 = currentDate;
        this.date2 = null;
        this.date1 = currentDate;
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        double tage = alter = Util.getExactDiffInYears(pd1.getGeburtsdatum());
        long milli = (long)(tage * 24.0 * 60.0 * 60.0 * 1000.0);
        this.date1 = DateUtil.dateAddMilliseconds(pd1.getGeburtsdatum(), milli);
        this.setRelevantDate(this.date1);
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das aktuelle Datum ist nicht vorhanden.");
        }
        this.calculateProgression();
    }

    private void calculateProgression() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
    }

    public void calculateDirektion(Personendaten pd1, Date currentDate) throws TechnicalException {
        this.horoskop = Horoskop.Direktion;
        this.pd1 = pd1;
        this.pd2 = new Personendaten();
        this.pd2.setLatitude(pd1.getLatitude());
        this.pd2.setLongitude(pd1.getLongitude());
        this.pd2.setGeburtsdatum(pd1.getGeburtsdatum());
        ObjectCopier.getInstance().copyCorrespondingFields(this.pd2, pd1);
        this.date1 = pd1.getGeburtsdatum();
        this.date1GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date1TimezoneId = pd1.getTimezoneId();
        this.date1GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.long1 = pd1.getLongitude();
        this.lat1 = pd1.getLatitude();
        this.date2 = currentDate;
        this.date2GmtOffsetManuell = pd1.isGmtOffsetManuell();
        this.date2TimezoneId = pd1.getTimezoneId();
        this.date2GmtOffsetInMinutes = pd1.getGmtOffsetInMinutes();
        this.long2 = pd1.getLongitude();
        this.lat2 = pd1.getLatitude();
        if (Util.isEmpty(this.long1) || Util.isEmpty(this.lat1)) {
            throw new TechnicalException("Die Geburtskoordinaten der ersten Person sind nicht vorhanden.");
        }
        if (Util.isEmpty(this.date1)) {
            throw new TechnicalException("Das Geburtsdatum der ersten Person ist nicht vorhanden.");
        }
        this.calculateDirektion();
    }

    private void calculateDirektion() {
        this.astrodaten1 = new Astrodaten(this.long1, this.lat1, this.date1);
        this.astrodaten2 = new Astrodaten(this.long1, this.lat1, this.date1);
        Date d1 = this.date1;
        Date d2 = this.date2;
        double diffInYears = DateUtil.getExactDiffInYears(d1, d2);
        Date d3 = DateUtil.addExactDays(d1, diffInYears);
        System.out.println("Neues Datum = " + Converter.datetimeToCetString(d3));
        Astrodaten astrodatenTmp = new Astrodaten(this.long1, this.lat1, d3);
        double winkel1 = this.astrodaten1.getPlanet(0);
        double winkel2 = astrodatenTmp.getPlanet(0);
        System.out.println("Sonne 1 = " + winkel1);
        System.out.println("Sonne 2 = " + winkel2);
        double diff = Trigo.alphaDiff(winkel1, winkel2);
        this.movePlanets(this.astrodaten2, diff);
        System.out.println("Diff = " + diff);
    }

    private void movePlanets(Astrodaten astrodaten, double diff) {
        for (int i = 0; i < PlanetInfo.REAL_PLANET_MAX; ++i) {
            astrodaten.planet[i].setLongitude(astrodaten.planet[i].getLongitude() + diff);
        }
    }

    private void recalculate() {
        switch (this.horoskop) {
            case Radix: {
                this.calculateRadix();
                break;
            }
            case Solar: {
                this.calculateSolar();
                break;
            }
            case Septar: {
                this.calculateSeptar();
                break;
            }
            case Komposit: {
                this.calculateKomposit();
                break;
            }
            case KompositTransit: {
                this.calculateKompositTransit();
                break;
            }
            case MultiKomposit: {
                this.calculateMultiKomposit();
                break;
            }
            case KompositSeptar: {
                this.calculateKompositSeptar();
                break;
            }
            case Temposit: {
                this.calculateTemposit();
                break;
            }
            case Septosit: {
                this.calculateSeptosit();
                break;
            }
            case Synastrie: {
                this.calculateSynastrie();
                break;
            }
            case Transit: {
                this.calculateTransit();
                break;
            }
            case Aktualitaet: {
                this.calculateAktualitaet();
                break;
            }
            case Combine: {
                this.calculateCombine();
                break;
            }
            case Progression: {
                this.calculateProgression();
                break;
            }
            case Direktion: {
                this.calculateDirektion();
            }
        }
    }

    public double getOffsetSatz2() {
        if (this.astrodaten1 == null) {
            return 0.0;
        }
        if (this.astrodaten2 == null) {
            return 0.0;
        }
        double offset = Trigo.grad(360.0 - this.astrodaten1.housesInfo.getAc() + this.astrodaten2.housesInfo.getAc());
        return offset;
    }

    public void setNewDate(Date date) {
        if (date == null) {
            return;
        }
        if (this.horoskop == Horoskop.Radix || this.horoskop == Horoskop.Aktualitaet || this.horoskop == Horoskop.Solar || this.horoskop == Horoskop.Komposit || this.horoskop == Horoskop.MultiKomposit || this.horoskop == Horoskop.KompositSeptar) {
            this.date1Before = date;
            this.date1 = date;
        } else {
            this.date2Before = date;
            this.date2 = date;
        }
        this.recalculate();
    }

    public void decreaseDateSmall() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateWithTimeAddDays(date, -1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void decreaseDateMinute() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateAddMinutes(date, -1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void decreaseDateHour() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateAddHours(date, -1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void decreaseDateMonth() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateAddMonths(date, -1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void increaseDateMinute() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateAddMinutes(date, 1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void increaseDateHour() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateAddHours(date, 1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void increaseDateMonth() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateAddMonths(date, 1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void increaseDateSmall() {
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateWithTimeAddDays(date, 1);
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void decreaseDateBig() throws TechnicalException {
        Date dateBackup;
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateWithTimeAddYears(date, -1);
        if (this.horoskop == Horoskop.Septar) {
            dateBackup = date = this.getRelevantDate();
            date = new SolarDate().increaseSolarDate(this.pd1, date);
            try {
                this.getSeptarHaus(this.pd1.getGeburtsdatum(), date);
            }
            catch (Exception e) {
                date = dateBackup;
            }
        }
        if (this.horoskop == Horoskop.Solar) {
            date = this.getRelevantDate();
            date = new SolarDate().decreaseSolarDate(this.pd1, date);
        }
        if (this.horoskop == Horoskop.Temposit) {
            date = this.getRelevantDate();
            date = new SolarDate().decreaseSolarDate(this.pd1, date);
        }
        if (this.horoskop == Horoskop.Septosit) {
            dateBackup = date = this.getRelevantDate();
            date = new SolarDate().increaseSolarDate(this.pd1, date);
            try {
                this.getSeptarHaus(this.pd1.getGeburtsdatum(), date);
            }
            catch (Exception e) {
                date = dateBackup;
            }
        }
        this.setRelevantDate(date);
        this.recalculate();
    }

    public void increaseDateBig() throws TechnicalException {
        Date dateBackup;
        this.date1Before = this.date1;
        this.date2Before = this.date2;
        Date date = this.getRelevantDate();
        date = DateUtil.dateWithTimeAddYears(date, 1);
        if (this.horoskop == Horoskop.Septar) {
            dateBackup = date = this.getRelevantDate();
            date = new SolarDate().decreaseSolarDate(this.pd1, date);
            try {
                this.getSeptarHaus(this.pd1.getGeburtsdatum(), date);
            }
            catch (Exception e) {
                date = dateBackup;
            }
        }
        if (this.horoskop == Horoskop.Solar) {
            date = this.getRelevantDate();
            date = new SolarDate().increaseSolarDate(this.pd1, date);
        }
        if (this.horoskop == Horoskop.Temposit) {
            date = this.getRelevantDate();
            date = new SolarDate().increaseSolarDate(this.pd1, date);
        }
        if (this.horoskop == Horoskop.Septosit) {
            dateBackup = date = this.getRelevantDate();
            date = new SolarDate().decreaseSolarDate(this.pd1, date);
            try {
                this.getSeptarHaus(this.pd1.getGeburtsdatum(), date);
            }
            catch (Exception e) {
                date = dateBackup;
            }
        }
        this.setRelevantDate(date);
        this.recalculate();
    }

    private int getSeptarHaus(Date geburtsdatum, Date berechnungsDatum) throws TechnicalException {
        int haus = Jahresring.getSeptarHausNr(geburtsdatum, berechnungsDatum);
        if (haus < 1 || haus > 12) {
            throw new TechnicalException("F\u00fcr dieses Jahr ist eine Berechnung nicht m\u00f6glich");
        }
        return haus;
    }

    public void undoDateChange() {
        this.date1 = this.date1Before;
        this.date2 = this.date2Before;
        this.recalculate();
    }

    public Date getRelevantDate() {
        this.horoskop.getPlanetenSaetze();
        if (this.horoskop == Horoskop.Radix || this.horoskop == Horoskop.Aktualitaet || this.horoskop == Horoskop.Solar || this.horoskop == Horoskop.Septar || this.horoskop == Horoskop.Combine || this.horoskop == Horoskop.Progression) {
            return this.date1;
        }
        if (this.horoskop == Horoskop.Synastrie || this.horoskop == Horoskop.Transit || this.horoskop == Horoskop.Komposit || this.horoskop == Horoskop.Temposit || this.horoskop == Horoskop.Septosit || this.horoskop == Horoskop.KompositTransit) {
            return this.date2;
        }
        if (this.horoskop == Horoskop.KompositSeptar) {
            return null;
        }
        return null;
    }

    public int getRelevantGmtOffsetInMinutes() {
        this.horoskop.getPlanetenSaetze();
        if (this.horoskop == Horoskop.Radix || this.horoskop == Horoskop.Aktualitaet || this.horoskop == Horoskop.Solar || this.horoskop == Horoskop.Septar || this.horoskop == Horoskop.Combine || this.horoskop == Horoskop.Progression) {
            if (this.date1GmtOffsetManuell) {
                return this.date1GmtOffsetInMinutes;
            }
            DateTime dt = DateUtil.date2JodaDate(this.date1, this.date1TimezoneId);
            int offset = Converter.gmtOffset2GmtOffsetInMinutes(DateUtil.getTimeZoneOffsetInHours(dt, this.date1TimezoneId));
            return offset;
        }
        if (this.horoskop == Horoskop.Synastrie || this.horoskop == Horoskop.Transit || this.horoskop == Horoskop.Komposit || this.horoskop == Horoskop.Temposit || this.horoskop == Horoskop.Septosit || this.horoskop == Horoskop.KompositTransit) {
            if (this.date2GmtOffsetManuell) {
                return this.date2GmtOffsetInMinutes;
            }
            DateTime dt = DateUtil.date2JodaDate(this.date2, this.date2TimezoneId);
            int offset = Converter.gmtOffset2GmtOffsetInMinutes(DateUtil.getTimeZoneOffsetInHours(dt, this.date2TimezoneId));
            return offset;
        }
        if (this.horoskop == Horoskop.KompositSeptar) {
            return 0;
        }
        return 0;
    }

    private void setRelevantDate(Date date) {
        if (this.horoskop == Horoskop.Radix || this.horoskop == Horoskop.Aktualitaet || this.horoskop == Horoskop.Solar || this.horoskop == Horoskop.Septar || this.horoskop == Horoskop.Combine || this.horoskop == Horoskop.Progression || this.horoskop == Horoskop.Direktion) {
            this.date1 = date;
        } else if (this.horoskop == Horoskop.Synastrie || this.horoskop == Horoskop.Transit || this.horoskop == Horoskop.Komposit || this.horoskop == Horoskop.Temposit || this.horoskop == Horoskop.Septosit || this.horoskop == Horoskop.KompositTransit) {
            this.date2 = date;
        }
    }

    public String getTitle() {
        String title = this.horoskop.name;
        if (this.horoskop == Horoskop.MultiKomposit) {
            title = title + ", Berechnung f\u00fcr die Gruppe " + this.gruppe;
            return title;
        }
        if (this.horoskop != Horoskop.Synastrie && this.horoskop != Horoskop.Komposit && this.horoskop != Horoskop.MultiKomposit && this.horoskop != Horoskop.Temposit && this.horoskop != Horoskop.KompositSeptar) {
            title = title + ", Berechnung f\u00fcr " + Converter.datetimeToGmtString(this.getRelevantDate(), this.getRelevantGmtOffsetInMinutes());
        }
        if (this.horoskop == Horoskop.Septar || this.horoskop == Horoskop.Septosit) {
            title = title + this.getAdditionalSeptarTitle(this.pd1.getGeburtsdatum(), this.getRelevantDate(), true);
        }
        if (this.horoskop == Horoskop.KompositSeptar && this.kompositSeptarHaus != 0) {
            title = title + ", Berechnung f\u00fcr " + this.getAdditionalKompositSeptarTitle(true, 1);
        }
        if (this.horoskop == Horoskop.KompositSeptar && this.kompositSeptarHaus == 0) {
            title = title + ", Berechnung f\u00fcr " + this.getAdditionalKompositSeptarTitle(true, 1) + " / " + this.getAdditionalKompositSeptarTitle(true, 2);
        }
        if (this.horoskop == Horoskop.Combine) {
            title = title + ", Ort: " + Util.latLong2dms(this.lat1, this.long1);
        }
        if (this.pd1 != null) {
            title = title + "\n" + this.pd1.toString();
            if (this.horoskop == Horoskop.Transit || this.horoskop == Horoskop.Solar) {
                title = title + "\nWohnort: " + this.pd1.getWohnort() + ", " + Util.latLong2dms(this.pd1.getWohnortLatitude(), this.pd1.getWohnortLongitude()) + ", " + Converter.datetimeToCetString(this.date2);
            }
            if (this.horoskop == Horoskop.Aktualitaet) {
                title = title + "\naktueller Ort: " + this.pd1.getAktuellOrt() + ", " + Util.latLong2dms(this.pd1.getAktuellLatitude(), this.pd1.getAktuellLongitude()) + ", " + Converter.datetimeToCetString(this.date2);
            }
            if (this.horoskop == Horoskop.KompositTransit) {
                title = title + ", Wohnort: " + this.pd1.getWohnort();
            }
        }
        if (this.pd2 != null) {
            if (this.horoskop == Horoskop.Temposit) {
                title = title + "\nSolar-Datum " + Converter.timeToString(this.date2);
            } else if (this.horoskop != Horoskop.Septosit) {
                title = title + "\n" + this.pd2.toString();
            }
            if (this.horoskop == Horoskop.KompositTransit) {
                title = title + ", Wohnort: " + this.pd2.getWohnort();
            }
        }
        return title;
    }

    public Date getInitialSeptarDate(Personendaten pd, Date currentDate) throws TechnicalException {
        int jahrDiff = Util.getDiffInYears(pd.getGeburtsdatum(), currentDate);
        int berechnungsjahr = 11 - jahrDiff / 7;
        if (berechnungsjahr < 0) {
            berechnungsjahr = 0;
        }
        Date septarDate = new SolarDate().getCurrentSolarDate(pd, DateUtil.getYear(pd.getGeburtsdatum()) + berechnungsjahr);
        return septarDate;
    }

    public Date getSeptarDateByHouse(Personendaten pd, int house) throws TechnicalException {
        int berechnungsjahr = house - 1;
        if (berechnungsjahr < 0) {
            berechnungsjahr = 0;
        }
        Date septarDate = new SolarDate().getCurrentSolarDate(pd, DateUtil.getYear(pd.getGeburtsdatum()) + berechnungsjahr);
        return septarDate;
    }

    public String getAdditionalSeptarTitle(Date geburt, Date aktuell, boolean oneLine) {
        try {
            int haus = this.getSeptarHaus(geburt, aktuell);
            int min = 7 * (13 - haus - 1);
            int max = 7 * (13 - haus);
            if (oneLine) {
                return ", Lebensabschnitt " + min + " - " + max + " Jahre (Haus " + haus + ")";
            }
            return "Lebensabschnitt " + min + " - " + max + " Jahre\n(Haus " + haus + ")";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getAdditionalKompositSeptarTitle(boolean oneLine, int person) {
        try {
            int haus = person == 2 ? this.kompositSeptarHaus2 : this.kompositSeptarHaus1;
            int min = 7 * (13 - haus - 1);
            int max = 7 * (13 - haus);
            if (oneLine) {
                return "Lebensabschnitt " + min + " - " + max + " Jahre (Haus " + haus + ")";
            }
            return "Lebensabschnitt " + min + " - " + max + " Jahre\n(Haus " + haus + ")";
        }
        catch (Exception e) {
            return "";
        }
    }

    public Horoskop getHoroskop() {
        return this.horoskop;
    }

    public Personendaten getPd1() {
        return this.pd1;
    }

    public Personendaten getPd2() {
        return this.pd2;
    }

    public Date getDate1() {
        return this.date1;
    }

    public Date getDate2() {
        return this.date2;
    }

    public String getLong1() {
        return this.long1;
    }

    public String getLat1() {
        return this.lat1;
    }

    public String getLong2() {
        return this.long2;
    }

    public String getLat2() {
        return this.lat2;
    }

    public Astrodaten getAstrodaten1() {
        return this.astrodaten1;
    }

    public Astrodaten getAstrodaten2() {
        return this.astrodaten2;
    }

    public List<IBusinessObject> getPersonendatenList() {
        return this.personendatenList;
    }

    public String getGruppe() {
        return this.gruppe;
    }

    public void setPersonendatenList(List<IBusinessObject> personendatenList) {
        this.personendatenList = personendatenList;
    }

    public void setGruppe(String gruppe) {
        this.gruppe = gruppe;
    }
}

