/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.Calculator;
import de.cni.common.astrologie.EphPlanetInfo;
import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.PlanetInfo;
import java.util.Date;
import swisseph.SweDate;

public class BaseCalculator {
    public static int PLANET_CNT = 10;
    private Calculator calc = new Calculator();
    public static char HOUSSYSTEM_PLACIDUS_KUERZEL = "P".charAt(0);
    public static char HOUSSYSTEM_H_KUERZEL = "H".charAt(0);
    public static char HOUSSYSTEM_KOCH_KUERZEL = "K".charAt(0);
    public static char HOUSSYSTEM_CAMPANUS_KUERZEL = "C".charAt(0);
    public static char HOUSSYSTEM_A_KUERZEL = "A".charAt(0);
    public static char HOUSSYSTEM_E_KUERZEL = "E".charAt(0);
    public static char HOUSSYSTEM_VEHLOW_KUERZEL = "V".charAt(0);
    public static char HOUSSYSTEM_AXIAL_KUERZEL = "X".charAt(0);
    public static char HOUSSYSTEM_AZIMUTHAL_KUERZEL = "H".charAt(0);
    public static char HOUSSYSTEM_POLICH_KUERZEL = "P".charAt(0);
    public static char HOUSSYSTEM_ALCABITIUS_KUERZEL = "N".charAt(0);
    public static char HOUSSYSTEM_PLACIDUS_NAME = "Placidus".charAt(0);
    public static char HOUSSYSTEM_H_NAME = "H".charAt(0);
    public static char HOUSSYSTEM_KOCH_NAME = "Koch".charAt(0);
    public static char HOUSSYSTEM_CAMPANUS_NAME = "Campanus".charAt(0);
    public static char HOUSSYSTEM_A_NAME = "A".charAt(0);
    public static char HOUSSYSTEM_E_NAME = "E".charAt(0);
    public static char HOUSSYSTEM_VEHLOW_NAME = "Vehlow".charAt(0);
    public static char HOUSSYSTEM_AXIAL_NAME = "Axial".charAt(0);
    public static char HOUSSYSTEM_AZIMUTHAL_NAME = "Azimuthal".charAt(0);
    public static char HOUSSYSTEM_POLICH_NAME = "Polich".charAt(0);
    public static char HOUSSYSTEM_ALCABITIUS_NAME = "Alcabitius".charAt(0);

    public PlanetInfo calculatePlanet(Date date, int planetId, double ac) {
        SweDate sd = this.calc.calcSweDate(date);
        PlanetInfo planetInfo = this.calc.calc(sd, planetId);
        if (planetId == 12) {
            planetInfo.setLongitude(planetInfo.getLongitude() + ac);
        }
        return planetInfo;
    }

    public PlanetInfo[] calculateAllPlanets(Date date, double ac) {
        PlanetInfo[] planetInfo = new PlanetInfo[PlanetInfo.PLANET_MAX];
        SweDate sd = this.calc.calcSweDate(date);
        for (int i = 0; i < PlanetInfo.PLANET_MAX; ++i) {
            planetInfo[i] = this.calc.calc(sd, i);
            if (i != 12) continue;
            planetInfo[i].setLongitude(planetInfo[i].getLongitude() + ac);
        }
        return planetInfo;
    }

    public EphPlanetInfo[] calculateAllEphPlanets(Date date) {
        EphPlanetInfo[] ephPlanetInfo = new PlanetInfo[EphPlanetInfo.PLANET_MAX];
        SweDate sd = this.calc.calcSweDate(date);
        for (int i = 0; i < EphPlanetInfo.PLANET_MAX; ++i) {
            ephPlanetInfo[i] = this.calc.calc(sd, i);
        }
        return ephPlanetInfo;
    }

    public HousesInfo calculateAllHouses(Date date, double latitude, double longitude, int housesystem) {
        SweDate sd = this.calc.calcSweDate(date);
        HousesInfo housesInfo = this.calc.houses(sd, latitude, longitude, housesystem);
        return housesInfo;
    }
}

