/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.AstroHelper;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.AstrodatenMixer;
import de.cni.common.calculation.BaseCalculator;
import de.cni.common.core.Constants;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.List;

public class AstrodatenMultiMixer {
    protected BaseCalculator baseCalculator = new BaseCalculator();
    String gruppe;
    List<IBusinessObject> personendatenList;
    Personendaten pdx;
    public PlanetInfo[] planetInfoX;
    public PlanetInfo sunX;
    public PlanetInfo moonX;
    public HousesInfo housesInfoX;
    public double gluecksfaktorX;
    public int[] bahnX;
    public PlanetInfo[] planetInfo1;
    public HousesInfo housesInfo1;
    public PlanetInfo sun1;
    public PlanetInfo moon1;
    public double gluecksfaktor1;
    public int[] bahn1;

    public Personendaten getMixedPersonendaten() {
        this.pdx = new Personendaten();
        this.pdx.setVirtuell(true);
        this.pdx.setNachname("Gruppe: " + this.gruppe);
        return this.pdx;
    }

    public Astrodaten getMixedAstrodaten() {
        return Astrodaten.newInstance(this);
    }

    public AstrodatenMultiMixer(List<IBusinessObject> personendatenList) {
        this.personendatenList = personendatenList;
        this.calculate();
    }

    private void calculate() {
        this.calculateAveragePlanetInfo();
    }

    private void calculateAveragePlanetInfo() {
        int i;
        this.planetInfoX = new PlanetInfo[Constants.planeten.length];
        this.housesInfoX = new HousesInfo();
        int size = this.personendatenList.size();
        double[][] latitude = new double[Constants.planeten.length][size];
        double[][] longitude = new double[Constants.planeten.length][size];
        double[][] distance = new double[Constants.planeten.length][size];
        double[][] distanceSpeed = new double[Constants.planeten.length][size];
        double[][] latitudeSpeed = new double[Constants.planeten.length][size];
        double[][] longitudeSpeed = new double[Constants.planeten.length][size];
        double[] housesInfo_ac = new double[size];
        double[] housesInfo_acAbs = new double[size];
        double[] housesInfo_mc = new double[size];
        double[] housesInfo_mcAbs = new double[size];
        double[][] housesInfo_vonRel = new double[HousesInfo.anz][size];
        double[][] housesInfo_vonAbs = new double[HousesInfo.anz][size];
        double[][] housesInfo_bisAbs = new double[HousesInfo.anz][size];
        int nr = 0;
        for (IBusinessObject obj : this.personendatenList) {
            int i2;
            Personendaten pd = (Personendaten)obj;
            this.housesInfo1 = this.baseCalculator.calculateAllHouses(pd.getGeburtsdatum(), Double.parseDouble(pd.getLatitude()), Double.parseDouble(pd.getLongitude()), BaseCalculator.HOUSSYSTEM_PLACIDUS_KUERZEL);
            this.planetInfo1 = this.baseCalculator.calculateAllPlanets(pd.getGeburtsdatum(), this.housesInfo1.getAc());
            for (i2 = 0; i2 < Constants.planeten.length; ++i2) {
                latitude[i2][nr] = this.planetInfo1[i2].getLatitude();
                longitude[i2][nr] = this.planetInfo1[i2].getLongitude();
                distance[i2][nr] = this.planetInfo1[i2].getDistance();
                distanceSpeed[i2][nr] = this.planetInfo1[i2].getDistanceSpeed();
                latitudeSpeed[i2][nr] = this.planetInfo1[i2].getLatitudeSpeed();
                longitudeSpeed[i2][nr] = this.planetInfo1[i2].getLongitudeSpeed();
            }
            housesInfo_ac[nr] = this.housesInfo1.getAc();
            housesInfo_acAbs[nr] = this.housesInfo1.getAcAbs();
            housesInfo_mc[nr] = this.housesInfo1.getMc();
            housesInfo_mcAbs[nr] = this.housesInfo1.getMcAbs();
            i2 = 1;
            while (true) {
                if (i2 >= HousesInfo.anz) break;
                housesInfo_vonRel[i2][nr] = this.housesInfo1.houseVonRel[i2];
                housesInfo_vonAbs[i2][nr] = this.housesInfo1.houseVonAbs[i2];
                housesInfo_bisAbs[i2][nr] = this.housesInfo1.houseBisAbs[i2];
                ++i2;
            }
            ++nr;
        }
        for (i = 0; i < Constants.planeten.length; ++i) {
            this.planetInfoX[i] = new PlanetInfo(i);
            this.planetInfoX[i].setLatitude(Trigo.averageGrad(latitude[i]));
            this.planetInfoX[i].setLongitude(Trigo.averageGrad(longitude[i]));
            this.planetInfoX[i].setDistance(Util.average(distance[i]));
            this.planetInfoX[i].setDistanceSpeed(Util.average(distanceSpeed[i]));
            this.planetInfoX[i].setLatitudeSpeed(Util.average(latitudeSpeed[i]));
            this.planetInfoX[i].setLongitudeSpeed(Util.average(longitudeSpeed[i]));
        }
        this.sunX = this.planetInfoX[0];
        this.moonX = this.planetInfoX[1];
        this.bahnX = new int[Constants.planeten.length];
        this.housesInfoX.setAc(Trigo.averageGrad(housesInfo_ac));
        this.housesInfoX.setAcAbs(Trigo.averageGrad(housesInfo_acAbs));
        this.housesInfoX.setMc(Trigo.averageGrad(housesInfo_mc));
        this.housesInfoX.setMcAbs(Trigo.averageGrad(housesInfo_mcAbs));
        for (i = 1; i < HousesInfo.anz; ++i) {
            this.housesInfoX.houseVonRel[i] = Trigo.averageGrad(housesInfo_vonRel[i]);
            this.housesInfoX.houseVonAbs[i] = Trigo.averageGrad(housesInfo_vonAbs[i]);
            this.housesInfoX.houseBisAbs[i] = Trigo.averageGrad(housesInfo_bisAbs[i]);
        }
        double acX = this.housesInfoX.getAc();
        double mcX = this.housesInfoX.getMc();
        this.acDrehen(this.housesInfoX, this.getTkzByPlanet(mcX), this.getTkzByPlanet(acX));
    }

    private void acDrehen(HousesInfo housesInfo, String tkzMc, String tkzAc) {
        if (!AstrodatenMixer.isTkzValid(tkzMc, tkzAc)) {
            double ac = Trigo.grad(this.housesInfoX.getAc() + 180.0);
            this.housesInfoX.setAc(ac);
        }
    }

    private void mcDrehen(HousesInfo housesInfo) {
        double acX = this.housesInfoX.getAc();
        double mcX = this.housesInfoX.getMc();
        double mcXAbs = this.housesInfoX.getMcAbs();
        String tkzMc = this.getTkzByPlanet(mcX);
        String tkzMcAbs = this.getTkzByPlanet(mcXAbs);
        mcX = this.housesInfoX.getMc();
        acX = this.housesInfoX.getAc();
        double mcAbs = FormatterGradzahlen.transfer(mcX, acX);
        this.housesInfoX.setMcAbs(mcAbs);
    }

    public String getTkzByPlanet(double winkel) {
        for (String tkz : Constants.tkz) {
            if (!this.hasTkz(winkel, tkz)) continue;
            return tkz;
        }
        return null;
    }

    public boolean hasTkz(double winkel, String tkz) {
        int myTkzId = AstroHelper.getTkzId(tkz);
        String kuerzel = Tkz.name[myTkzId];
        double von = Tkz.getGrad(kuerzel);
        double bis = Tkz.getGradNext(kuerzel);
        return Trigo.isBetween(winkel, von, bis);
    }
}

