/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.util.Resources;
import de.cni.client.paint.Controlpanel;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.astrologie.AspektariumPlanet;
import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.Aspektarium;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.OrbisCache;
import de.cni.common.calculation.RadixHelper;
import de.cni.common.core.Constants;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AspektariumCalculator {
    private static Log log = LogFactory.getLog(AspektariumCalculator.class);
    public static final int anzPlaneten = PlanetInfo.REAL_PLANET_MAX;
    public static final int maxObjekte = anzPlaneten + 4;
    public static int ID_AC = anzPlaneten + 0;
    public static int ID_DC = anzPlaneten + 1;
    public static int ID_MC = anzPlaneten + 2;
    public static int ID_IC = anzPlaneten + 3;
    Horoskop horoskop;
    Controlpanel controlpanel;

    public AspektariumCalculator(Horoskop horoskop, Controlpanel controlpanel) {
        this.horoskop = horoskop;
        this.controlpanel = controlpanel;
    }

    private AspektariumPlanet[] initializeAspektariumPlanetListe(Astrodaten astrodaten, double offset) {
        HousesInfo hi = astrodaten.housesInfo;
        AspektariumPlanet[] aspektariumPlanetListe = new AspektariumPlanet[maxObjekte];
        double acRel = hi.getAc();
        double mcRel = hi.getMc();
        double dcRel = Trigo.grad(acRel + 180.0);
        double icRel = Trigo.grad(mcRel + 180.0);
        double acAbs = hi.getAcAbs();
        double mcAbs = hi.getMcAbs();
        double dcAbs = Trigo.grad(acAbs + 180.0);
        double icAbs = Trigo.grad(mcAbs + 180.0);
        RadixHelper rp = new RadixHelper(astrodaten);
        for (int i = 0; i < anzPlaneten; ++i) {
            int tkzId = this.getTkz(astrodaten, i);
            int hausNr = rp.getIntLastHausByPlanet(Constants.planeten[i], 0);
            int hausNr3Grad = rp.getIntLastHausByPlanet(Constants.planeten[i], 3);
            aspektariumPlanetListe[i] = new AspektariumPlanet(i, Constants.planeten[i], PlanetInfo.getPlanetIcon(i), offset, astrodaten.getPlanetAbs(i), astrodaten.getPlanet(i), astrodaten.isRetrogradeDirection(i), Tkz.name[tkzId], Tkz.icon[tkzId], hausNr, hausNr3Grad);
        }
        int haus = rp.getIntLastHausByPlanet(Constants.planeten[13], 0);
        aspektariumPlanetListe[AspektariumCalculator.ID_AC] = new AspektariumPlanet(anzPlaneten + 0, "AC", Resources.ICON.PLANET_AC, offset, acAbs, acRel, false, Tkz.name[this.getTkz(astrodaten, ID_AC)], Tkz.icon[this.getTkz(astrodaten, ID_AC)], haus, haus);
        haus = rp.getIntLastHausByPlanet(Constants.planeten[14], 0);
        aspektariumPlanetListe[AspektariumCalculator.ID_DC] = new AspektariumPlanet(anzPlaneten + 1, "DC", Resources.ICON.PLANET_DC, offset, dcAbs, dcRel, false, Tkz.name[this.getTkz(astrodaten, ID_DC)], Tkz.icon[this.getTkz(astrodaten, ID_DC)], haus, haus);
        haus = rp.getIntLastHausByPlanet(Constants.planeten[15], 0);
        aspektariumPlanetListe[AspektariumCalculator.ID_MC] = new AspektariumPlanet(anzPlaneten + 2, "MC", Resources.ICON.PLANET_MC, offset, mcAbs, mcRel, false, Tkz.name[this.getTkz(astrodaten, ID_MC)], Tkz.icon[this.getTkz(astrodaten, ID_MC)], haus, haus);
        haus = rp.getIntLastHausByPlanet(Constants.planeten[16], 0);
        aspektariumPlanetListe[AspektariumCalculator.ID_IC] = new AspektariumPlanet(anzPlaneten + 3, "IC", Resources.ICON.PLANET_IC, offset, icAbs, icRel, false, Tkz.name[this.getTkz(astrodaten, ID_IC)], Tkz.icon[this.getTkz(astrodaten, ID_IC)], haus, haus);
        log.debug((Object)("AC (rel)=" + Trigo.grad(hi.getAc())));
        log.debug((Object)("AC (abs)" + Trigo.grad(hi.getAcAbs())));
        log.debug((Object)("MC (rel)" + Trigo.grad(hi.getMc())));
        log.debug((Object)("MC (abs)" + Trigo.grad(hi.getMcAbs())));
        return aspektariumPlanetListe;
    }

    public Aspektarium berechneAspekte(Astrodaten astrodaten) {
        return this.berechneAspekteWorker(astrodaten, astrodaten, 0.0, this.controlpanel.getOrbisCache(), false);
    }

    public Aspektarium berechneInterAspekte(Astrodaten astrodaten, Astrodaten astrodaten2, double offsetSatz2) {
        return this.berechneAspekteWorker(astrodaten, astrodaten2, offsetSatz2, this.controlpanel.getInterOrbisCache(), true);
    }

    private Aspektarium berechneAspekteWorker(Astrodaten astrodaten1, Astrodaten astrodaten2, double offsetSatz2, OrbisCache oc, boolean inter) {
        Aspektarium aspektarium = new Aspektarium(maxObjekte);
        AspektariumPlanet[] planetenListe1 = this.initializeAspektariumPlanetListe(astrodaten1, 0.0);
        AspektariumPlanet[] planetenListe2 = this.initializeAspektariumPlanetListe(astrodaten2, offsetSatz2);
        aspektarium.setPlanetListe(planetenListe1);
        aspektarium.setInterPlanetListe(planetenListe2);
        for (int i = 0; i < maxObjekte; ++i) {
            for (int j = 0; j < maxObjekte; ++j) {
                aspektarium.setAspekt(i, j, AspektTyp.empty);
                if (i == 10 || i == 12 || i == 11 || j == 10 || j == 12 || j == 11) continue;
                double alphaDiff = Trigo.alphaDiff(planetenListe1[i].winkelAbs, planetenListe2[j].winkelAbs);
                if (i == ID_AC && j == 0) {
                    log.debug((Object)("i=" + i + ", j=" + j + " --> diff=" + alphaDiff));
                    log.debug((Object)("rel: i-Winkel = " + aspektarium.getPlanet((int)i).winkel + ", jWinkel = " + aspektarium.getPlanet((int)j).winkel));
                    log.debug((Object)("abs:i-Winkel = " + aspektarium.getPlanet((int)i).winkelAbs + ", jWinkel = " + aspektarium.getPlanet((int)j).winkelAbs));
                }
                this.berechneAspekteWorker(aspektarium, i, j, alphaDiff, AspektTyp.konjunktion, this.controlpanel.isKonjunktion(), oc);
                this.berechneAspekteWorker(aspektarium, i, j, alphaDiff, AspektTyp.sextil, this.controlpanel.isSextil(), oc);
                this.berechneAspekteWorker(aspektarium, i, j, alphaDiff, AspektTyp.quadrat, this.controlpanel.isQuadrat(), oc);
                this.berechneAspekteWorker(aspektarium, i, j, alphaDiff, AspektTyp.trigon, this.controlpanel.isTrigon(), oc);
                this.berechneAspekteWorker(aspektarium, i, j, alphaDiff, AspektTyp.opposition, this.controlpanel.isOpposition(), oc);
                this.berechneAspekteWorker(aspektarium, i, j, alphaDiff, AspektTyp.quinkunx, this.controlpanel.isQuinkunx(), oc);
                if (!inter || this.horoskop.zweiterAcMc || this.controlpanel.isZweiterAcMc() || !Util.equals(j, new int[]{ID_AC, ID_MC, ID_IC, ID_DC})) continue;
                aspektarium.setAspekt(i, j, AspektTyp.empty);
                aspektarium.setAbweichung(i, j, 0.0);
            }
        }
        return aspektarium;
    }

    private void berechneAspekteWorker(Aspektarium aspektarium, int i, int j, double alphaDiff, AspektTyp aspektTyp, boolean useIt, OrbisCache myOrbisCache) {
        if (!useIt) {
            return;
        }
        int toleranz1 = myOrbisCache.getValue(this.horoskop.ordinal(), aspektTyp.ordinal(), i);
        int toleranz2 = myOrbisCache.getValue(this.horoskop.ordinal(), aspektTyp.ordinal(), j);
        int toleranz = Math.max(toleranz1, toleranz2);
        aspektarium.setWinkel(i, j, alphaDiff);
        if (this.isInRange(alphaDiff, aspektTyp.winkelbeziehung, toleranz)) {
            double abweichung = Math.abs(alphaDiff) - aspektTyp.winkelbeziehung;
            aspektarium.setAbweichung(i, j, abweichung);
            aspektarium.setAspekt(i, j, aspektTyp);
        }
    }

    private boolean isInRange(double alphaDiff, double alpha, int toleranz) {
        return alphaDiff <= alpha + (double)toleranz && alphaDiff >= alpha - (double)toleranz;
    }

    private int getTkz(Astrodaten astrodaten, int planetId) {
        HousesInfo housesInfo = astrodaten.housesInfo;
        double ac = 180.0;
        double dc = 0.0;
        double mc = Trigo.grad(housesInfo.getMcAbs());
        double ic = Trigo.grad(mc + 180.0);
        double gradPlanet = 0.0;
        if (planetId == anzPlaneten) {
            gradPlanet = ac;
        } else if (planetId == anzPlaneten + 1) {
            gradPlanet = dc;
        } else if (planetId == anzPlaneten + 2) {
            gradPlanet = mc;
        } else if (planetId == anzPlaneten + 3) {
            gradPlanet = ic;
        } else {
            double asc = astrodaten.housesInfo.getAc();
            gradPlanet = Trigo.grad(astrodaten.planet[planetId].getTransferedLongitude(asc));
        }
        double offset = -(astrodaten.housesInfo.getAc() + 180.0);
        for (int i = 0; i < 12; ++i) {
            double bis;
            String kuerzel = Tkz.name[i];
            double von = Trigo.grad(offset + (double)Tkz.getGrad(kuerzel));
            if (!(von <= (bis = Trigo.grad(offset + (double)Tkz.getGradNext(kuerzel))) ? gradPlanet >= von && gradPlanet <= bis : gradPlanet >= von || gradPlanet <= bis)) continue;
            return i;
        }
        return -1;
    }
}

