/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.astrologie;

import de.cni.common.calculation.Astrodaten;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Trigo;
import java.util.Date;

public class Jahresring {
    public double getWinkel(Date geburtsdatum, Date currentDate, Astrodaten astrodaten) {
        Date d2;
        currentDate = DateUtil.getDateWithoutTime(currentDate);
        int day1 = DateUtil.getDay(geburtsdatum);
        int month1 = DateUtil.getMonth(geburtsdatum);
        int day2 = DateUtil.getDay(currentDate);
        int month2 = DateUtil.getMonth(currentDate);
        if (day1 == 29 && month1 == 2 && day2 == 28 && month2 == 2) {
            geburtsdatum = DateUtil.dateAddDays(geburtsdatum, -1);
            --day1;
        }
        int house = this.getHouseByDate(day1, month1, day2, month2);
        Date d1 = this.getBeginnDateByHouse(geburtsdatum, currentDate, house);
        int daysOffset = 0;
        daysOffset = day1 > day2 ? day1 - day2 : day2 - day1;
        int nextHouse = house - 1;
        if (nextHouse == 0) {
            nextHouse = 12;
        }
        if (DateUtil.compareDateWithoutTime(d1, d2 = this.getBeginnDateByHouse(geburtsdatum, currentDate, nextHouse)) > 0) {
            d2 = DateUtil.dateAddYears(d2, 1);
        }
        int unitsPerHouse = (int)DateUtil.getDiffInDays(d1, d2) - 1;
        daysOffset = (int)DateUtil.getDiffInDays(d1, currentDate) - 1;
        double von = astrodaten.housesInfo.getHouseVonAbs(house);
        double bis = astrodaten.housesInfo.getHouseBisAbs(house);
        double offsetWinkel = Trigo.grad(bis - von) * (double)daysOffset / (double)unitsPerHouse;
        double winkel = bis - offsetWinkel;
        return Trigo.grad(winkel);
    }

    public int getHouseByDate(int day1, int month1, int day2, int month2) {
        if (month2 < month1 || month2 != month1 || day2 < day1) {
            // empty if block
        }
        int house = month1 + 12 - month2;
        if (day2 < day1) {
            ++house;
        }
        if (house > 12) {
            house -= 12;
        }
        if (house < 1) {
            house = 12;
        }
        return house;
    }

    public int getHouseByDateObsolete(int day1, int month1, int day2, int month2) {
        Date d2;
        int year1;
        int year2 = year1 = DateUtil.getCurrentYear();
        Date d1 = DateUtil.getDate(year1, month1, day1);
        int monate = DateUtil.getRoundedDiffInMonth(d1, d2 = DateUtil.getDate(year2, month2, day2));
        if (monate < 0) {
            monate += 12;
        }
        int house = 12 - (monate %= 13);
        return house;
    }

    public Date getBeginnDateByHouse(Date geburtsdatum, Date currentDate, int house) {
        int month;
        boolean currentIsAfter;
        int day1 = DateUtil.getDay(geburtsdatum);
        int month1 = DateUtil.getMonth(geburtsdatum);
        int year1 = DateUtil.getYear(currentDate);
        day1 = Math.min(DateUtil.getDaysPerMonat(year1, month1), day1);
        Date startDate = DateUtil.newDate(day1, month1, year1);
        boolean bl = currentIsAfter = DateUtil.compareDateWithoutTime(startDate, currentDate) > 0;
        if (currentIsAfter) {
            --year1;
        }
        if ((month = month1 + 12 - house) > 12) {
            month -= 12;
            ++year1;
        }
        day1 = Math.min(DateUtil.getDaysPerMonat(year1, month), day1);
        Date d = DateUtil.newDate(day1, month, year1);
        return d;
    }

    public long getEinheitenProHaus(Date startpunkt, int haus) {
        int year2;
        int day1 = DateUtil.getDay(startpunkt);
        int month1 = DateUtil.getMonth(startpunkt) + 12 - haus;
        int year1 = DateUtil.getDay(startpunkt);
        int day2 = day1;
        int month2 = DateUtil.getNextMonth(month1);
        year2 = month2 > month1 ? (year2 = year1) : year1 + 1;
        int maxDays2 = DateUtil.getDaysPerMonat(year2, month2);
        if (day2 > maxDays2) {
            day2 = maxDays2;
        }
        return DateUtil.getDiffInDays(day1, month1, year1, day2, month2, year2);
    }

    public static double getSeptarwinkel(Date geburtsdatum, int septarNr, int monat) {
        Date dateCurrent = DateUtil.dateAddMonths(geburtsdatum, 12 * septarNr * 7 + monat);
        Date dateMin = DateUtil.dateAddYears(geburtsdatum, septarNr * 7);
        Date dateMax = DateUtil.dateAddYears(geburtsdatum, (septarNr + 1) * 7);
        long current = dateCurrent.getTime();
        long min = dateMin.getTime();
        long max = dateMax.getTime();
        long intervallLength = max - min;
        long position = current - min;
        double winkel = Trigo.grad(360L * position / intervallLength);
        return winkel;
    }

    public static double getSeptarwinkel(Date geburtsdatum, int septarNr) {
        Date dateCurrent = DateUtil.getToday();
        Date dateMin = DateUtil.dateAddYears(geburtsdatum, (septarNr - 1) * 7);
        Date dateMax = DateUtil.dateAddYears(geburtsdatum, septarNr * 7);
        long current = dateCurrent.getTime();
        long min = dateMin.getTime();
        long max = dateMax.getTime();
        if (current < min || current > max) {
            return -1.0;
        }
        long intervallLength = max - min;
        long position = current - min;
        double winkel = Trigo.grad(360.0 * (double)position / (double)intervallLength);
        return winkel;
    }

    public static int getSeptarHausNr(Date geburtsdatum, Date berechnungsdatum) {
        return DateUtil.getRoundedDiffInYears(geburtsdatum, berechnungsdatum) + 1;
    }

    public static int getSeptarNr(Date geburtsdatum, Date berechnungsdatum) {
        return 13 - Jahresring.getSeptarHausNr(geburtsdatum, berechnungsdatum);
    }
}

