/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.reporting;

import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.reporting.IReportClientFacade;
import de.cni.client.reporting.MyJasperViewer;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.GlobalData;
import de.cni.common.core.JasperPrinterFacade;
import de.cni.common.core.Mappings;
import de.cni.common.core.Util;
import de.cni.common.datamodel.batch.ReportSpec;
import de.cni.common.datamodel.enumtypes.ReportParameter;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JasperClientFacade
implements IReportClientFacade {
    private static Log log = LogFactory.getLog(JasperClientFacade.class);
    ApplicationProperties props = ApplicationProperties.getInstance();
    Connection conn = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperPrint generateJasperPrint(ReportSpec reportSpec) throws SQLException, JRException {
        try {
            long start = System.currentTimeMillis();
            String url = this.props.getProperty("jdbc.url");
            String user = this.props.getProperty("jdbc.user");
            String pwd = this.props.getProperty("jdbc.pwd");
            String templatesDir = this.props.getProperty("report.dir.client");
            reportSpec.addParameter(ReportParameter.MAPPINGS, Mappings.getInstance());
            reportSpec.addParameter(ReportParameter.REPORT_DIR, templatesDir + File.separator);
            JasperReport jasperReport = null;
            try {
                File sourceFile = new File(templatesDir + "/" + reportSpec.getReportinfo().getVorlage() + ".jasper");
                jasperReport = (JasperReport)JRLoader.loadObject((File)sourceFile);
                log.debug((Object)("Jasper-Report laden - Dauer= " + (System.currentTimeMillis() - start) + "ms"));
            }
            catch (Exception e) {
                log.error((Object)e);
                jasperReport = JasperCompileManager.compileReport((String)(templatesDir + "/" + reportSpec.getReportinfo().getVorlage() + ".jrxml"));
                log.debug((Object)("Jasper-Report Template erzeugen - Dauer= " + (System.currentTimeMillis() - start) + "ms"));
            }
            JREmptyDataSource emptyDatasource = new JREmptyDataSource(1);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportSpec.getParameters(), (JRDataSource)emptyDatasource);
            log.debug((Object)("Jasper-Report Erzeugung - Dauer= " + (System.currentTimeMillis() - start) + "ms"));
            JasperPrint jasperPrint2 = jasperPrint;
            return jasperPrint2;
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                this.conn = null;
            }
        }
    }

    @Override
    public boolean runOnlineJdbcReport(ReportSpec reportSpec) {
        try {
            log.debug((Object)"runOnlineJdbcReport - Beginn");
            long start = System.currentTimeMillis();
            JasperPrint jasperPrint = this.generateJasperPrint(reportSpec);
            log.debug((Object)"jasperPrint-Objekt wurde erfolgreich erstellt");
            if (jasperPrint == null || jasperPrint.getPages() == null || jasperPrint.getPages().size() == 0) {
                ErrorHandler.handleError(log, "Das Dokument hat keine Seiten.");
                return false;
            }
            if (GlobalData.getInstance().isWindows()) {
                log.debug((Object)"Customized JasperViewer f\u00fcr Windows \u00f6ffnen ...");
                MyJasperViewer jasperViewer = new MyJasperViewer(jasperPrint);
                MyJasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
                log.debug((Object)"Customized JasperViewer f\u00fcr MAC fertig");
                jasperViewer.dispose();
            } else {
                log.debug((Object)"Original JasperViewer f\u00fcr MAC \u00f6ffnen ...");
                JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
                log.debug((Object)"Original JasperViewer f\u00fcr MAC fertig");
            }
            log.debug((Object)("Jasper-Report Viewer aufschalten - Dauer= " + (System.currentTimeMillis() - start) + "ms"));
            log.debug((Object)"runOnlineJdbcReport - Ende");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            String message = e.getMessage();
            if (e instanceof JRException && e.getCause() != null) {
                message = message + ". " + Util.NotNull(e.getCause().getMessage());
            }
            ErrorHandler.handleError(log, "Technischer Fehler beim Anzeigen des Dokuments.\n" + message);
            return false;
        }
    }

    @Override
    public boolean saveReport(ReportSpec reportSpec) {
        try {
            log.debug((Object)"saveReport - Beginn");
            JasperPrint jasperPrint = this.generateJasperPrint(reportSpec);
            String filename = reportSpec.getFilename();
            if (Util.isEmpty(filename)) {
                filename = reportSpec.getReportinfo().getArchivname();
            }
            this.save(jasperPrint, filename);
            log.debug((Object)"saveReport - Ende");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            String message = e.getMessage();
            if (e instanceof JRException && e.getCause() != null) {
                message = message + ". " + Util.NotNull(e.getCause().getMessage());
            }
            ErrorHandler.handleError(log, "Technischer Fehler beim Anzeigen des Dokuments.\n" + message);
            return false;
        }
    }

    public void save(JasperPrint jasperPrint, String filename) throws JRException {
        log.debug((Object)("Report als PDF speichern unter '" + filename + "'"));
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)filename);
        exporter.exportReport();
    }

    @Override
    public void print(ReportSpec reportSpec) throws Exception {
        log.debug((Object)"print - Beginn");
        JasperPrinterFacade jasperPrinterFacade = new JasperPrinterFacade();
        JasperPrint jasperPrint = this.generateJasperPrint(reportSpec);
        jasperPrinterFacade.print(jasperPrint, reportSpec, GlobalData.getInstance().getParameterStore().getBooleanValue("DRUCKER-AKTIVIERT"));
        log.debug((Object)"print - Ende");
    }
}

