/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.paint;

import de.cni.client.paint.Disposer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;

public class PaintUtil {
    public static void saveAsJpeg(Control control, String file) {
        PaintUtil.saveImage(control, file, 4);
    }

    public static void saveAsPng(Control control, String file) {
        PaintUtil.saveImage(control, file, 5);
    }

    public static void saveAsGif(Control control, String file) {
        PaintUtil.saveImage(control, file, 2);
    }

    public static void saveAsTiff(Control control, String file) {
        PaintUtil.saveImage(control, file, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImage(Control control, String file, int format) {
        Image image = null;
        GC gc = null;
        try {
            gc = new GC((Drawable)control);
            image = new Image((Device)control.getDisplay(), control.getSize().x, control.getSize().y);
            gc.copyArea(image, 0, 0);
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            if (format == 4) {
                loader.save(file + ".jpg", format);
            } else if (format == 5) {
                loader.save(file + ".png", format);
            } else if (format == 2) {
                loader.save(file + ".gif", format);
            } else if (format == 6) {
                loader.save(file + ".tiff", format);
            }
        }
        catch (Throwable throwable) {
            Disposer.dispose(gc);
            Disposer.dispose(image);
            throw throwable;
        }
        Disposer.dispose(gc);
        Disposer.dispose(image);
    }
}

