/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.paint;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.ReportjobController;
import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.popup.filter.PopupHoroskopPictureDialog;
import de.cni.client.gui.util.AWTBufferedImageSWTImage;
import de.cni.client.paint.AstroLeinwand;
import de.cni.client.paint.Controlpanel;
import de.cni.client.paint.Disposer;
import de.cni.client.paint.PaintRawData;
import de.cni.common.astrologie.HousesPaintInfo;
import de.cni.common.calculation.Aspektarium;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Grundstruktur;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.TextanalyseCalculator;
import de.cni.common.calculation.VierElemente;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.ObjectCopier;
import de.cni.common.core.Util;
import de.cni.common.datamodel.DocumentParameter;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.TechnicalException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class DocumentCreator {
    private static Log log = LogFactory.getLog(DocumentCreator.class);
    Personendaten personendaten1;
    Personendaten personendaten2;
    Astrodaten astrodaten1;
    Astrodaten astrodaten2;
    Image image;
    int x = 1000;
    int y = 1000;
    String IMAGE_FILE = "io/image.png";
    Aspektarium aspektarium1;
    Aspektarium aspektarium2;
    Aspektarium interaspektarium;
    VierElemente vierElemente;
    Grundstruktur grundstruktur1;
    Grundstruktur grundstruktur2;
    HousesPaintInfo housesPaintInfo;
    Date date;
    Controlpanel controlpanel;
    HoroskopCalculator horoskopCalculator;

    public DocumentCreator(HoroskopCalculator hc, Controlpanel controlpanel) {
        this.controlpanel = controlpanel;
        this.horoskopCalculator = hc;
        this.astrodaten1 = hc.getAstrodaten1();
        this.astrodaten2 = hc.getAstrodaten2();
    }

    public DocumentCreator setSize(int x, int y) {
        int maxX = Display.getDefault().getClientArea().width - 250;
        int maxY = Display.getDefault().getClientArea().height - 0;
        if (x == 0 && y == 0 || x > maxX || y > maxY) {
            int size;
            x = size = Math.min(maxX, maxY);
            y = size;
        }
        this.x = x;
        this.y = y;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentCreator createDocument() throws TechnicalException {
        DocumentCreator documentCreator;
        GC gc = null;
        try {
            this.date = this.astrodaten1.date;
            this.setSize(this.x, this.y);
            if (this.astrodaten1 == null) {
                throw new TechnicalException("Es wurden keine Planetendaten \u00fcbergeben");
            }
            PaintRawData paintRawData = new PaintRawData(this.x, this.y, this.horoskopCalculator.getTitle() + "_" + Converter.dateToSortableString(new Date()));
            paintRawData.getObjectList().add(this.controlpanel);
            paintRawData.getObjectList().add(this.horoskopCalculator);
            paintRawData.setSizeX(this.x);
            paintRawData.setSizeX(this.y);
            AstroLeinwand leinwand = new AstroLeinwand(paintRawData);
            leinwand.setPaperVersion(true);
            Disposer.dispose(this.image);
            this.image = new Image((Device)MainApplicationWindow.getInstance().getShell().getDisplay(), this.x, this.y);
            gc = new GC((Drawable)this.image);
            leinwand.initialize(gc);
            leinwand.writeCopyright();
            leinwand.paint();
            leinwand.finalize();
            AspektariumCalculator aspektariumCalculator = new AspektariumCalculator(this.horoskopCalculator.getHoroskop(), this.controlpanel);
            this.aspektarium1 = aspektariumCalculator.berechneAspekte(this.astrodaten1);
            if (this.controlpanel.isAspekte2() && this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1) {
                this.aspektarium2 = aspektariumCalculator.berechneAspekte(this.astrodaten2);
            }
            if (this.controlpanel.isInterAspekte() && this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1) {
                this.interaspektarium = aspektariumCalculator.berechneInterAspekte(this.astrodaten1, this.astrodaten2, this.astrodaten2.offset);
            }
            this.controlpanel.setHoroskopCalculator(this.horoskopCalculator);
            TextanalyseCalculator cal = new TextanalyseCalculator(this.controlpanel, this.astrodaten1);
            cal.calculateVierElemente();
            this.vierElemente = cal.getVierElemente();
            this.grundstruktur1 = cal.getGrundstruktur(0);
            this.grundstruktur2 = cal.getGrundstruktur(3);
            this.housesPaintInfo = cal.getHousesPaintInfo();
            documentCreator = this;
        }
        catch (Throwable throwable) {
            Disposer.dispose(gc);
            throw throwable;
        }
        Disposer.dispose(gc);
        return documentCreator;
    }

    public void saveImage(String filename) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{this.image.getImageData()};
        loader.save(this.IMAGE_FILE, 5);
    }

    public void popupHoroskop() {
        PopupHoroskopPictureDialog ppd = new PopupHoroskopPictureDialog(this.horoskopCalculator, MainApplicationWindow.getInstance().getShell(), this.x, this.y);
        ppd.open();
    }

    public void popupJasperViewer(int reportNr) {
        this.saveImage(this.IMAGE_FILE);
        DocumentParameter documentParameter = new DocumentParameter();
        documentParameter = this.getDocumentParameter();
        if (reportNr == 1) {
            documentParameter.printRadixKlein = false;
            documentParameter.printRadixGross = true;
            documentParameter.printGrundstruktur = true;
        } else {
            documentParameter.printRadixKlein = true;
            documentParameter.printRadixGross = false;
            documentParameter.printGrundstruktur = false;
        }
        BufferedImage awtImage = AWTBufferedImageSWTImage.convertToAWT(this.image.getImageData());
        documentParameter.filename = this.IMAGE_FILE;
        documentParameter.image = awtImage;
        if (this.horoskopCalculator.getRelevantDate() != null) {
            documentParameter.datum = DateUtil.getPrintableTimeString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes());
        }
        HashMap<String, Object> presetParameters = new HashMap<String, Object>();
        presetParameters.put("DOCUMENT_PARAMETER", documentParameter);
        ReportjobController reportjobController = new ReportjobController();
        reportjobController.startBatch(reportNr, true, presetParameters, true, "");
    }

    public void saveJasperDokument(int reportNr) {
        this.saveImage(this.IMAGE_FILE);
        DocumentParameter documentParameter = new DocumentParameter();
        documentParameter = this.getDocumentParameter();
        if (reportNr == 1) {
            documentParameter.printRadixKlein = false;
            documentParameter.printRadixGross = true;
            documentParameter.printGrundstruktur = true;
        } else {
            documentParameter.printRadixKlein = true;
            documentParameter.printRadixGross = false;
            documentParameter.printGrundstruktur = false;
        }
        BufferedImage awtImage = AWTBufferedImageSWTImage.convertToAWT(this.image.getImageData());
        documentParameter.filename = this.IMAGE_FILE;
        documentParameter.image = awtImage;
        if (this.horoskopCalculator.getRelevantDate() != null) {
            documentParameter.datum = DateUtil.getPrintableTimeString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes());
        }
        HashMap<String, Object> presetParameters = new HashMap<String, Object>();
        presetParameters.put("DOCUMENT_PARAMETER", documentParameter);
        ReportjobController reportjobController = new ReportjobController();
        String vorgabe = this.getDocumentParameter().getHoroskopName() + "_" + this.getDocumentParameter().getPersonName();
        String filename = PopupFileDialog.openPdfFileDialog(vorgabe);
        if (filename == null) {
            return;
        }
        reportjobController.startBatch(reportNr, true, presetParameters, false, filename);
    }

    public DocumentParameter getDocumentParameter() {
        DocumentParameter documentParameter = new DocumentParameter();
        Personendaten pd1 = null;
        Personendaten pd2 = null;
        if (this.horoskopCalculator.getPd1() != null) {
            pd1 = new Personendaten();
            ObjectCopier.getInstance().copyBusinessObject(pd1, this.horoskopCalculator.getPd1());
            if (this.controlpanel.isInvisible()) {
                pd1.setVorname("");
                pd1.setNachname(pd1.getAnonymeBezeichnung());
            } else if (this.controlpanel.isAnonym()) {
                pd1.setVorname("");
                if (!Util.isEmpty(pd1.getAnonymeBezeichnung())) {
                    pd1.setNachname(pd1.getAnonymeBezeichnung());
                } else {
                    pd1.setNachname("Person A");
                }
            }
        }
        if (this.horoskopCalculator.getPd2() != null) {
            pd2 = new Personendaten();
            ObjectCopier.getInstance().copyBusinessObject(pd2, this.horoskopCalculator.getPd2());
            if (this.controlpanel.isInvisible()) {
                pd2.setVorname("");
                pd2.setNachname(pd2.getAnonymeBezeichnung());
            } else if (this.controlpanel.isAnonym()) {
                pd2.setVorname("");
                if (!Util.isEmpty(pd1.getAnonymeBezeichnung())) {
                    pd2.setNachname(pd2.getAnonymeBezeichnung());
                } else {
                    pd2.setNachname("Person B");
                }
            }
        }
        documentParameter.horoskop = this.horoskopCalculator.getHoroskop();
        documentParameter.title = this.horoskopCalculator.getTitle();
        documentParameter.pd1 = pd1;
        documentParameter.pd2 = pd2;
        documentParameter.settings = this.controlpanel != null ? this.controlpanel : GlobalData.getInstance().getSettings();
        documentParameter.iconDirAspekte = "icons/standard/standard/Aspekte/";
        documentParameter.iconDirPlaneten = "icons/standard/standard/Planeten/";
        documentParameter.iconDirPlaneten2 = "icons/standard/red/Planeten/";
        documentParameter.iconDirTkz = "icons/standard/standard/Tkz/";
        documentParameter.inter = this.controlpanel.isInterAspekte() && this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1;
        documentParameter.aspektarium1 = this.aspektarium1;
        documentParameter.aspektarium2 = this.aspektarium2;
        documentParameter.interaspektarium = this.interaspektarium;
        documentParameter.vierElemente = this.vierElemente;
        documentParameter.grundstruktur1 = this.grundstruktur1;
        documentParameter.grundstruktur2 = this.grundstruktur2;
        documentParameter.housesPaintInfo = this.housesPaintInfo;
        documentParameter.logo = this.getLogo();
        this.fillPersonenbeschreibung(documentParameter);
        return documentParameter;
    }

    public String getLogo() {
        String logo = GlobalData.getInstance().getSettings().getLogoFile();
        File f = FileUtils.getFile((String[])new String[]{logo});
        if (f.isFile()) {
            return logo;
        }
        return "./reports/logo.png";
    }

    private void fillPersonenbeschreibung(DocumentParameter d) {
        d.horoskopName = this.horoskopCalculator.getHoroskop().getName();
        d.planetenSaetze = this.horoskopCalculator.getHoroskop().getPlanetenSaetze();
        Personendaten pd1 = d.getPd1();
        Personendaten pd2 = d.getPd2();
        if (pd1 != null) {
            d.person1Name = pd1.getName();
            d.person1Block = pd1.geburtToBlock();
        }
        switch (this.horoskopCalculator.getHoroskop()) {
            case Radix: {
                d.paintPerson2Red = false;
                d.person2Name = "";
                d.person2Block = "Berechnung f\u00fcr\n" + Converter.datetimeToGmtString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes());
                break;
            }
            case Septar: {
                d.paintPerson2Red = false;
                d.person2Name = "";
                d.person2Block = "Berechnung f\u00fcr\n" + Converter.datetimeToGmtString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes());
                d.person2Block = d.person2Block + "\n" + this.horoskopCalculator.getAdditionalSeptarTitle(pd1.getGeburtsdatum(), this.horoskopCalculator.getRelevantDate(), false);
                break;
            }
            case Solar: {
                d.paintPerson2Red = false;
                d.person2Block = "Berechnung f\u00fcr\n" + Converter.datetimeToGmtString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes());
                d.person2Block = pd1.wohnortToBlock(this.horoskopCalculator.getRelevantDate());
                break;
            }
            case Komposit: {
                d.paintPerson2Red = false;
                d.person2Name = pd2.getName();
                d.person2Block = pd2.geburtToBlock();
                break;
            }
            case KompositTransit: {
                d.person1Block = d.person1Block + "\n" + pd1.wohnortToBlock(this.horoskopCalculator.getRelevantDate());
                d.paintPerson2Red = false;
                d.person2Name = pd2.getName();
                d.person2Block = pd2.geburtToBlock() + "\n" + pd2.wohnortToBlock(this.horoskopCalculator.getRelevantDate());
                break;
            }
            case KompositSeptar: {
                d.paintPerson2Red = false;
                d.person2Name = pd2.getName();
                d.person2Block = pd2.geburtToBlock();
                d.person1Block = d.person1Block + "\n" + this.horoskopCalculator.getAdditionalKompositSeptarTitle(false, 1);
                d.person2Block = d.person2Block + "\n" + this.horoskopCalculator.getAdditionalKompositSeptarTitle(false, 2);
                break;
            }
            case MultiKomposit: {
                d.paintPerson2Red = false;
                d.person2Name = "";
                d.person2Block = "";
                d.person1Block = "\nGruppe: " + this.horoskopCalculator.getGruppe();
                break;
            }
            case Temposit: {
                d.paintPerson2Red = false;
                d.person2Name = "";
                d.person2Block = "Berechnung f\u00fcr\n" + Converter.datetimeToGmtString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes());
                break;
            }
            case Septosit: {
                d.paintPerson2Red = false;
                d.person2Name = "";
                d.person2Block = "Berechnung f\u00fcr\n" + Converter.datetimeToGmtString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes());
                d.person2Block = d.person2Block + "\n" + this.horoskopCalculator.getAdditionalSeptarTitle(pd1.getGeburtsdatum(), this.horoskopCalculator.getRelevantDate(), false);
                break;
            }
            case Synastrie: {
                d.paintPerson2Red = true;
                d.person2Name = pd2.getName();
                d.person2Block = pd2.geburtToBlock();
                if (Util.equals(pd2.getGeburtsdatum(), this.horoskopCalculator.getRelevantDate())) break;
                d.person2Block = d.person2Block + "\n<b>Berechnung f\u00fcr\n" + Converter.datetimeToGmtString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes()) + "</b>";
                break;
            }
            case Transit: {
                d.paintPerson2Red = true;
                d.person2Name = "";
                d.person2Block = pd1.wohnortToBlock(this.horoskopCalculator.getRelevantDate());
                break;
            }
            case Aktualitaet: {
                d.paintPerson2Red = true;
                d.person2Name = "";
                d.person2Block = pd1.aktuellToBlock(this.horoskopCalculator.getRelevantDate());
                break;
            }
            case Combine: {
                d.paintPerson2Red = false;
                d.person2Name = pd2.getName();
                d.person2Block = pd2.geburtToBlock();
                break;
            }
            case Progression: {
                d.paintPerson2Red = false;
                d.person2Name = "";
                d.person2Block = "\n<b>Berechnung f\u00fcr\n" + Converter.datetimeToGmtString(this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getRelevantGmtOffsetInMinutes()) + "</b>";
                break;
            }
            case Direktion: {
                d.paintPerson2Red = false;
                d.person2Name = pd2.getName();
                d.person2Block = pd2.geburtToBlock();
            }
        }
        d.personName = Formatter.append(d.getPerson1Name(), d.getPerson2Name(), " / ");
    }
}

