/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.IWrapper;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.Converter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StyledTextWrapper
implements IWrapper<StyledText> {
    protected String id;
    protected boolean emptyAllowed = true;
    protected StyledText widget;
    protected int leadingZeros = 0;
    protected String value;
    protected boolean active = true;
    protected Font defaultFont = null;

    public StyledTextWrapper() {
        this.widget = null;
        this.active = false;
    }

    public StyledTextWrapper(Brand[] brands, Composite parent, int style) {
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            this.widget = new StyledText(parent, style);
            this.widget.setFont(GlobalData.getInstance().getDefaultFont());
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    public void setValue(String text) {
        this.value = Util.NotNull(text);
        if (this.widget != null) {
            this.widget.setText(this.value);
        }
    }

    public void setValue(int text) {
        if (this.leadingZeros > 0) {
            this.setValue(Converter.intToLeading0String(text, this.leadingZeros));
        } else if (this.emptyAllowed) {
            this.setValue(Converter.intToNotNullString(text));
        } else {
            this.setValue(Converter.intToString(text));
        }
    }

    public void setValue(long text) {
        if (this.leadingZeros > 0) {
            this.setValue(Converter.longToLeading0String(text, this.leadingZeros));
        } else if (this.emptyAllowed) {
            this.setValue(Converter.longToNotNullString(text));
        } else {
            this.setValue(Converter.longToString(text));
        }
    }

    public String getValue() {
        if (this.widget != null) {
            this.value = this.widget.getText();
        }
        return this.value;
    }

    public int getIntValue() {
        return Converter.stringToInt(this.getValue());
    }

    public long getLongValue() {
        return Converter.stringToLong(this.getValue());
    }

    @Override
    public Control getControlWidget() {
        return this.widget;
    }

    public void setToolTipText(String text) {
        if (this.widget != null) {
            this.widget.setToolTipText(text);
        }
    }

    @Override
    public StyledText getWidget() {
        return this.widget;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
    }

    public int getLeadingZeros() {
        return this.leadingZeros;
    }

    public void setLeadingZeros(int leadingZeros) {
        this.leadingZeros = leadingZeros;
    }

    @Override
    public void setFocus() {
        if (this.widget != null) {
            this.widget.setFocus();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

