/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupMultipleTextfieldDialog;
import de.cni.client.gui.popup.filter.PopupSearchReplaceDialog;
import de.cni.client.gui.popup.filter.PopupTabTextfieldDialog;
import de.cni.client.gui.popup.filter.PopupTextfieldDialog;
import de.cni.client.gui.popup.filter.PopupTimeDialog;
import de.cni.client.gui.popup.filter.PopupValueDialog;
import de.cni.client.gui.popup.filter.PopupWordDialog;
import de.cni.client.gui.popup.page.NotizTile;
import de.cni.client.gui.popup.page.PopupTileDialog;
import de.cni.client.gui.util.DialogShell;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.core.ActiveXInterface;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.GlobalData;
import de.cni.common.core.ServerConnection;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.Notiz;
import de.cni.common.datamodel.admin.DokumentVorlage;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Popup {
    private static Log log = LogFactory.getLog(Popup.class);
    public static int tripleQuestionJa = 0;
    public static int tripleQuestionNein = 1;
    public static int tripleQuestionAbbrechen = 2;

    public static String valuePopup(String name, String value, boolean isInteger) {
        PopupValueDialog dialog = new PopupValueDialog(MainApplicationWindow.getInstance().getShell(), name, value, isInteger);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            value = dialog.getBusinessObject();
            return value;
        }
        return null;
    }

    public static String valuePopup(String title, String message, String name, String value, boolean isInteger, int limit) {
        PopupValueDialog dialog = new PopupValueDialog(MainApplicationWindow.getInstance().getShell(), title, message, name, value, isInteger, limit);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            value = dialog.getBusinessObject();
            return value;
        }
        return null;
    }

    public static String[] searchReplacePopup(String value1, String value2, boolean isInteger) {
        PopupSearchReplaceDialog dialog = new PopupSearchReplaceDialog(MainApplicationWindow.getInstance().getShell(), value1, value2, isInteger);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String v1 = dialog.getValue1();
            String v2 = dialog.getValue2();
            return new String[]{v1, v2};
        }
        return null;
    }

    public static String textfieldPopup(String name, String value) {
        PopupTextfieldDialog dialog = new PopupTextfieldDialog(MainApplicationWindow.getInstance().getShell(), 0, name, value);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            value = dialog.getBusinessObject();
            return value;
        }
        if (dialog.getReturnCode() == 2) {
            return "";
        }
        return null;
    }

    public static boolean textfieldPopupWithSaveButton(String name, String value) {
        PopupTextfieldDialog dialog = new PopupTextfieldDialog(MainApplicationWindow.getInstance().getShell(), 0, name, value, true, true);
        dialog.open();
        return dialog.getReturnCode() == 3;
    }

    public static Date timePopup(String name, Date value) {
        PopupTimeDialog dialog = new PopupTimeDialog(MainApplicationWindow.getInstance().getShell(), name, value);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            value = dialog.getBusinessObject();
            return value;
        }
        if (dialog.getReturnCode() == 2) {
            return null;
        }
        return null;
    }

    public static Notiz notizPopup(Notiz notiz) {
        try {
            PopupTileDialog ppd = new PopupTileDialog(new NotizTile(), notiz, MainApplicationWindow.getInstance().getShell(), PopupTileDialog.Mode.SAVE, null);
            ppd.setMinSizeX(MainApplicationWindow.getInstance().getWidth() * 3 / 4);
            ppd.setMinSizeY(300);
            ppd.open();
            if (ppd.getButtonPressedId() == 0) {
                return null;
            }
            if (ppd.getButtonPressedId() == 2) {
                return new Notiz();
            }
            notiz = (Notiz)ppd.getBusinessObject();
            return notiz;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            return null;
        }
    }

    public static void info(String text) {
        MainApplicationWindow.getInstance().popupInfo(text);
    }

    public static void infoCourier(String text) {
        DialogShell ds = new DialogShell(MainApplicationWindow.getInstance().getShell());
        ds.open(text);
    }

    public static void notImplemented() {
        MainApplicationWindow.getInstance().popupInfo("Diese Funktion steht momentan leider noch nicht zur Verf\u00fcgung.\nSie wird aber in K\u00fcrze verf\u00fcgbar sein.");
    }

    public static boolean question(String text) {
        return MainApplicationWindow.getInstance().popupQuestion(text);
    }

    public static int tripleQuestion(String text) {
        return MainApplicationWindow.getInstance().popupTripleQuestion(text);
    }

    public static void warning(String text) {
        MainApplicationWindow.getInstance().popupWarning(text);
    }

    public static void error(String text) {
        MainApplicationWindow.getInstance().popupError(text);
    }

    public static void infoPopup(String name, String value, int len) {
        PopupTextfieldDialog dialog = new PopupTextfieldDialog(MainApplicationWindow.getInstance().getShell(), len, name, value, true);
        dialog.open();
    }

    public static void infoPopup(String name1, String name2, String value1, String value2, int len) {
        PopupMultipleTextfieldDialog dialog = new PopupMultipleTextfieldDialog(MainApplicationWindow.getInstance().getShell(), len, name1, name2, value1, value2, true);
        dialog.open();
    }

    public static void tabInfoPopup(String name1, String name2, String name3, String name4, String value1, String value2, String value3, String value4, int len) {
        PopupTabTextfieldDialog dialog = new PopupTabTextfieldDialog(MainApplicationWindow.getInstance().getShell(), len, name1, name2, name3, name4, value1, value2, value3, value4, true);
        dialog.open();
    }

    public static void popupWord(int bereich, Object dataObject) {
        try {
            String templatename = null;
            DokumentVorlage filter = new DokumentVorlage();
            filter.setBereich(bereich);
            List<IBusinessObject> dokumentvorlageList = ServerConnection.getInstance().getReportVerwaltung().select(filter);
            if (dokumentvorlageList == null || dokumentvorlageList.size() == 0) {
                Popup.info("Es sind keine Dokumentvorlagen hinterlegt");
                return;
            }
            if (dokumentvorlageList.size() == 1) {
                templatename = ((DokumentVorlage)dokumentvorlageList.get(0)).getTemplate();
            } else {
                PopupWordDialog dialog = new PopupWordDialog(MainApplicationWindow.getInstance().getShell(), dokumentvorlageList, dataObject);
                dialog.open();
                if (dialog.getReturnCode() == 1) {
                    templatename = dialog.getTemplatename();
                } else {
                    return;
                }
            }
            String pfad = GlobalData.getInstance().getParameterStore().getStringValue("PFAD-WORD");
            pfad = ApplicationProperties.getInstance().getProperty("client.dir.wordtemplates", "word_templates");
            String filename = System.getProperty("user.dir") + File.separator + pfad + File.separator + templatename + ".dot";
            log.debug((Object)("\u00d6ffnen des Word-Templates '" + filename + "'"));
            ActiveXInterface.OpenMicrosoftWord(filename, dataObject, true);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public static int intPopup(String name) {
        return 0;
    }

    public static enum PopupName {
        LEER(0, ""),
        PID(1, "PID"),
        MAKLERNR(2, "MAKLERNR");

        int id;
        String name;

        private PopupName(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static String[] getNameArray() {
            String[] nameArray = new String[PopupName.values().length];
            int i = 0;
            for (PopupName popupName : PopupName.values()) {
                nameArray[i++] = popupName.getName();
            }
            return nameArray;
        }

        public static String getNameById(int id) {
            for (PopupName popupName : PopupName.values()) {
                if (popupName.getId() != id) continue;
                return popupName.getName();
            }
            return null;
        }

        public static int getIdByName(String name) {
            for (PopupName popupName : PopupName.values()) {
                if (!popupName.getName().equals(name)) continue;
                return popupName.getId();
            }
            return 0;
        }

        public static PopupName getPopupName(int id) {
            for (PopupName jobtyp : PopupName.values()) {
                if (jobtyp.getId() != id) continue;
                return jobtyp;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

