/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.TextWrapper;
import de.cni.common.calculation.OrbisCache;

public class OrbisMediator {
    public static final int anzHoroskope = OrbisCache.anzHoroskope;
    public static final int anzAspekte = OrbisCache.anzAspekte;
    public static final int anzPlaneten = OrbisCache.anzPlaneten;
    private TextWrapper[][][] orbisTextWrapperArray = new TextWrapper[anzHoroskope][anzAspekte][anzPlaneten];
    OrbisCache orbisCache = new OrbisCache();

    public void setOrbisTextWrapper(int horoskopId, int aspektId, int planetId, TextWrapper t) {
        this.orbisTextWrapperArray[horoskopId][aspektId][planetId] = t;
    }

    public String getValue() {
        for (int horoskopId = 0; horoskopId < anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                    if (this.orbisTextWrapperArray[horoskopId][aspektId][planetId] != null) {
                        this.orbisCache.setValue(horoskopId, aspektId, planetId, this.orbisTextWrapperArray[horoskopId][aspektId][planetId].getIntValue());
                        continue;
                    }
                    this.orbisCache.setValue(horoskopId, aspektId, planetId, 0);
                }
            }
        }
        return this.orbisCache.object2string();
    }

    public void setValue(String dbString) {
        this.orbisCache.string2object(dbString);
        this.refreshGui();
    }

    public void refreshGui() {
        for (int horoskopId = 0; horoskopId < anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                    if (this.orbisTextWrapperArray[horoskopId][aspektId][planetId] == null) continue;
                    this.orbisTextWrapperArray[horoskopId][aspektId][planetId].setValue(this.orbisCache.getValue(horoskopId, aspektId, planetId));
                }
            }
        }
    }

    public OrbisCache getOrbisCache() {
        return this.orbisCache;
    }
}

