/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.IWrapper;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.Domain;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Mappings;
import de.cni.common.core.Util;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CComboWrapper
implements IWrapper<CCombo> {
    private static Log log = LogFactory.getLog(CComboWrapper.class);
    private int VISIBLE_ITEM_COUNT = 20;
    private int VISIBLE_LENGTH_LIMIT = 0;
    String id;
    CCombo widget;
    Domain domain;
    int value;
    boolean active = true;
    boolean langtext = true;
    Font defaultFont = GlobalData.getInstance().getDefaultFont();

    public CComboWrapper(Brand[] brands, Composite parent, Domain domain, boolean langtext, int style) throws MappingException {
        this(brands, parent, domain, langtext, 0, style);
    }

    public CComboWrapper(Brand[] brands, Composite parent, Domain domain, boolean langtext, int visibleLengthLimit, int style) throws MappingException {
        this.langtext = langtext;
        this.domain = domain;
        this.VISIBLE_LENGTH_LIMIT = visibleLengthLimit;
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            this.widget = this.newCCombo(parent, style);
            String[] list = null;
            list = langtext ? Mappings.getInstance().getDomainLangtextArray(domain, this.VISIBLE_LENGTH_LIMIT) : Mappings.getInstance().getDomainKurztextArray(domain);
            this.widget.setItems(list);
            this.widget.setVisibleItemCount(this.VISIBLE_ITEM_COUNT);
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    public CComboWrapper(Brand[] brands, Composite parent, String[] list, int style) {
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            this.widget = this.newCCombo(parent, style);
            this.widget.setItems(list);
            this.widget.setVisibleItemCount(this.VISIBLE_ITEM_COUNT);
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    private CCombo newCCombo(Composite parent, int style) {
        this.widget = new CCombo(parent, style);
        this.widget.setFont(this.defaultFont);
        return this.widget;
    }

    @Override
    public Control getControlWidget() {
        return this.widget;
    }

    public void onContentChanged() {
        try {
            if (!this.langtext) {
                int id = Mappings.getInstance().getDomainIdFromKurztext(this.domain, this.widget.getText());
                String text = Mappings.getInstance().getDomainLangtext(this.domain, id);
                this.widget.setToolTipText(text);
            } else if (this.VISIBLE_LENGTH_LIMIT > 0) {
                int id = this.getValue();
                String text = Mappings.getInstance().getDomainLangtext(this.domain, id);
                this.widget.setToolTipText(text);
            }
        }
        catch (Exception e) {
            log.error((Object)("Tooltip kann nicht ermittelt werden. " + e.getMessage()));
        }
    }

    public void setValue(int key) throws MappingException {
        if (this.widget != null) {
            if (this.langtext) {
                this.widget.setText(Mappings.getInstance().getDomainLangtext(this.domain, key, this.VISIBLE_LENGTH_LIMIT));
            } else {
                this.widget.setText(Mappings.getInstance().getDomainKurztext(this.domain, key));
            }
        }
    }

    public void setValueByText(String text) throws MappingException {
        if (this.widget != null) {
            this.widget.setText(text);
        }
    }

    public int getValue() throws MappingException {
        int index = 0;
        if (this.widget != null) {
            index = this.widget.getSelectionIndex();
            if (index < 0) {
                index = 0;
            }
            this.value = Mappings.getInstance().getDomainIdArray(this.domain)[index];
        }
        return this.value;
    }

    public int getValueByText() throws MappingException {
        if (this.widget != null) {
            this.value = Mappings.getInstance().getDomainIdFromText(this.domain, this.widget.getText());
        }
        return this.value;
    }

    public int getSelectionIndex() throws MappingException {
        int index = 0;
        if (this.widget != null) {
            index = this.widget.getSelectionIndex();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public String getStringValue() {
        String value = null;
        if (this.widget != null) {
            value = this.widget.getText();
        }
        return value;
    }

    public String setStringValue(String value) {
        if (this.widget != null) {
            this.widget.setText(Util.NotNull(value));
        }
        return value;
    }

    @Override
    public CCombo getWidget() {
        return this.widget;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setFocus() {
        if (this.widget != null) {
            this.widget.setFocus();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

