/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.tiles.table.templates.ITableDetailToogleListener;
import de.cni.client.gui.util.Resources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AdvancedGroup
extends Group {
    Label title = null;
    Composite content = null;
    ITableDetailToogleListener listener = null;
    Button button;

    public AdvancedGroup(Composite parent, int style, String label, ITableDetailToogleListener listener) {
        super(parent, style);
        this.listener = listener;
        this.createCenteredTitle(label);
    }

    protected void checkSubclass() {
    }

    private void createCenteredTitle(String name) {
        GridLayout layout = new GridLayout(1, false);
        AdvancedGroup parent = this;
        if (this.listener != null) {
            Composite c = this.createRowComposite(this, 2, 1);
            this.button = new Button(c, 8);
            this.button.setImage(Resources.getInstance().getImage(Resources.ICON.BIG_LIST));
            parent = c;
        }
        this.title = new Label((Composite)parent, 0);
        this.title.setText(name);
        this.title.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        this.content = new Composite((Composite)this, 0);
        this.content.setLayoutData((Object)new GridData(4, 128, true, true));
        this.content.setLayout((Layout)layout);
        if (this.listener != null) {
            this.title.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    AdvancedGroup.this.listener.tableDetailToogle(null);
                }
            });
            if (this.button != null) {
                this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AdvancedGroup.this.listener.tableDetailToogle(null);
                    }
                });
            }
        }
    }

    public Composite createRowComposite(AdvancedGroup parent, int columns, int span) {
        Composite rowComposite = new Composite((Composite)parent, 0);
        GridLayout rowLayout = new GridLayout();
        rowLayout.numColumns = columns;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        GridData rowData1 = new GridData(768);
        rowData1.horizontalSpan = span;
        rowData1.horizontalAlignment = 4;
        rowData1.grabExcessHorizontalSpace = true;
        rowComposite.setLayout((Layout)rowLayout);
        rowComposite.setLayoutData((Object)rowData1);
        return rowComposite;
    }

    public void setText(String text) {
        this.title.setText(text);
    }

    public String getText() {
        return this.title.getText();
    }

    public Composite getContentComposite() {
        return this.content;
    }
}

