/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.tree.templates;

import de.cni.client.gui.action.toolbar.DropDownAction;
import de.cni.client.gui.action.toolbar.IDropDownNewable;
import de.cni.client.gui.tiles.tree.templates.ContentProvider;
import de.cni.client.gui.tiles.tree.templates.ITreeController;
import de.cni.client.gui.tiles.tree.templates.TreeViewerFilter;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.GuiElements;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.GlobalData;
import de.cni.common.datamodel.IBusinessTreeObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;

public class TreeViewerTile {
    private static Log log = LogFactory.getLog(TreeViewerTile.class);
    WidgetFactory guiUtil = new WidgetFactory();
    ITreeController treeController;
    String grouptext;
    boolean withDeleteButton = true;
    boolean withCancelButton = true;
    ButtonWrapper deleteButton = null;
    ButtonWrapper cancelButton = null;
    TreeViewer treeViewer;
    TreeViewerFilter treeViewerFilter = new TreeViewerFilter();
    String canceledText;
    boolean presetCancelFlag = false;

    public TreeViewerTile(ITreeController treeController, String grouptext, String canceledText, boolean presetCancelFlag) {
        this.treeController = treeController;
        this.grouptext = grouptext;
        this.canceledText = canceledText;
        this.presetCancelFlag = presetCancelFlag;
    }

    public void createContent(Composite parent, int height, ILabelProvider labelProvider) {
        Group group = GuiContainer.newFillGroup(parent, this.grouptext, 1, 1);
        this.treeViewerFilter.setWithCanceled(this.presetCancelFlag);
        this.treeViewer = new TreeViewer((Composite)group, 772);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.addFilter((ViewerFilter)this.treeViewerFilter);
        this.treeViewer.getTree().setFont(GlobalData.getInstance().getDefaultFont());
        this.createButtons((Composite)group);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IBusinessTreeObject o = (IBusinessTreeObject)((ITreeSelection)e.getSelection()).getFirstElement();
                if (!TreeViewerTile.this.treeViewer.getExpandedState((Object)o)) {
                    TreeViewerTile.this.treeViewer.expandToLevel((Object)o, 1);
                } else {
                    TreeViewerTile.this.treeViewer.collapseToLevel((Object)o, 1);
                }
                TreeViewerTile.this.treeController.doubleClick(o);
            }
        });
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ITreeSelection selection = (ITreeSelection)e.getSelection();
                if (selection.getFirstElement() == null) {
                    return;
                }
                IBusinessTreeObject o = (IBusinessTreeObject)selection.getFirstElement();
                TreeViewerTile.this.treeController.selectionChanged(o, selection.size());
            }
        });
    }

    public void createButtons(Composite parent) {
        Composite buttonsComposite = GuiContainer.newComposite(parent, 3);
        if (this.withDeleteButton) {
            this.deleteButton = this.guiUtil.createPushButton(buttonsComposite, "Zeile l\u00f6schen", Resources.ICON.SMALL_REMOVE);
            this.deleteButton.setId(GuiElements.BUTTON_DELETE, this.guiUtil);
            this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeViewerTile.this.treeController.deleteCurrentObject();
                }
            });
        }
        if (this.withCancelButton) {
            Label l = new Label(buttonsComposite, 0);
            l.setText("   " + this.canceledText);
            this.cancelButton = this.guiUtil.createCheckbox(buttonsComposite, "Auch geschlossene/stornierte Elemente anzeigen?");
            this.guiUtil.enablingRegistry.removeFromDisableList((Control)this.cancelButton.getWidget());
            this.guiUtil.enablingRegistry.removeFromEnableList((Control)this.cancelButton.getWidget());
            this.cancelButton.setValue(this.presetCancelFlag);
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeViewerTile.this.treeViewerFilter.setWithCanceled(TreeViewerTile.this.cancelButton.getValue());
                    if (!TreeViewerTile.this.treeController.withCanceledPressed()) {
                        TreeViewerTile.this.cancelButton.setValue(!TreeViewerTile.this.cancelButton.getValue());
                    }
                }
            });
        }
    }

    public void refreshButtons() {
        if (this.treeController.getSelectedObjects().size() > 0) {
            this.guiUtil.enableOneWidget(this.deleteButton);
        } else {
            this.guiUtil.disableOneWidget(this.deleteButton);
        }
    }

    public void setData() {
        log.debug((Object)"TreeViewer - setData() - Start");
        this.treeViewer.setInput(this.treeController.getObjectList());
        log.debug((Object)"TreeViewer - setData() - Ende");
    }

    public void setChangedFlag(boolean flag) {
        this.guiUtil.setChanged(flag);
    }

    public List<IBusinessTreeObject> getSelectedObjects() {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        return selection.toList();
    }

    public void setEnabled(boolean enabled) {
        this.guiUtil.setEnabled(enabled);
    }

    public boolean isDataChanged() {
        return this.guiUtil.isChanged();
    }

    public void setSelection(Object object) {
        IBusinessTreeObject businessTreeObject = (IBusinessTreeObject)object;
        if (businessTreeObject != null) {
            this.treeViewer.refresh();
            if (GlobalData.getInstance().isExpandTree()) {
                this.treeViewer.expandAll();
            } else {
                this.treeViewer.collapseAll();
            }
            StructuredSelection selection = new StructuredSelection((Object)businessTreeObject);
            this.treeViewer.setSelection((ISelection)selection, true);
        }
    }

    public void registerPopupManager(final IDropDownNewable controller) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DropDownAction.fillContextMenu(TreeViewerTile.this.treeViewer.getControl(), manager, controller);
            }
        });
        Menu popupmenu = manager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getTree().setMenu(popupmenu);
    }

    public boolean withCanceledItems() {
        return this.cancelButton.getValue();
    }
}

