/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table.templates;

import de.cni.client.gui.tiles.table.templates.ITableComposite;
import de.cni.client.gui.tiles.table.templates.ITableController;
import de.cni.client.gui.tiles.table.templates.ITableListener;
import de.cni.client.gui.tiles.table.templates.ITableViewerSorter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.widgets.Composite;

public abstract class TableController
implements ITableController {
    private static Log log = LogFactory.getLog(TableController.class);
    static final int BUTTON_UP = 1;
    static final int BUTTON_DOWN = 2;
    static final int BUTTON_ADD = 4;
    static final int BUTTON_DELETE = 8;
    protected ITableComposite tableComposite;
    protected ITableController.PageSelectionStatus pageSelectionStatus;
    protected Object selectedObject;
    protected String groupname;
    protected String[] columnNameArray;
    protected int[] columnWidthArray;
    protected int[] alignmentArray;
    protected int height = 80;
    protected List objectList;
    protected ITableListener listener;

    @Override
    public void registerListener(ITableListener listener) {
        this.listener = listener;
    }

    public Composite createContent(Composite parent) {
        if (parent == null) {
            return null;
        }
        return this.createContent(parent, this.height);
    }

    @Override
    public Composite createContent(Composite parent, int height) {
        this.tableComposite = this.createTableComposite();
        Composite c = this.tableComposite.createContent(parent, height);
        this.tableComposite.refreshButtons();
        return c;
    }

    public List<Object> getSelectedObjects() {
        return this.tableComposite.getSelectedObjects();
    }

    @Override
    public void selectionChanged(Object firstObject, int cnt) {
        if (this.listener != null) {
            this.listener.selectionChanged(firstObject, cnt);
        }
        if (cnt == 0) {
            this.pageSelectionStatus = ITableController.PageSelectionStatus.noSelection;
        } else if (cnt == 1) {
            this.selectedObject = firstObject;
            this.pageSelectionStatus = ITableController.PageSelectionStatus.oneLineSelected;
        } else {
            this.pageSelectionStatus = ITableController.PageSelectionStatus.multiLinesSelected;
        }
        this.tableComposite.refreshButtons();
    }

    public void abortSelection() {
        this.selectedObject = null;
    }

    @Override
    public ITableController.PageSelectionStatus getPageSelectionStatus() {
        return this.pageSelectionStatus;
    }

    @Override
    public List<?> getObjectList() {
        return this.objectList;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.tableComposite == null) {
            return;
        }
        this.tableComposite.setEnabled(enabled);
    }

    public boolean isDataChanged() {
        if (this.tableComposite == null) {
            return false;
        }
        return this.tableComposite.isDataChanged();
    }

    @Override
    public void setSelection(Object object) {
        if (this.tableComposite == null) {
            return;
        }
        this.tableComposite.setSelection(object);
    }

    @Override
    public void doubleClick(Object object) {
        if (this.listener != null) {
            this.listener.doubleClick(object);
        }
    }

    @Override
    public void deleteLine() {
        log.debug((Object)"deleteLine - Start");
        if (this.listener == null || this.listener.deleteLine()) {
            this.objectList.remove(this.selectedObject);
            this.tableComposite.setData();
        }
        log.debug((Object)"deleteLine - Ende");
    }

    @Override
    public void customButton() {
    }

    @Override
    public void setObjectList(List<?> objectList) {
        this.objectList = objectList;
        this.tableComposite.setData();
        this.tableComposite.setChangedFlag(false);
    }

    @Override
    public void setDefaultSort() {
    }

    @Override
    public abstract ITableLabelProvider createLabelProvider();

    @Override
    public abstract ITableViewerSorter createTableViewerSorter();
}

