/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table.templates;

import de.cni.client.gui.tiles.table.templates.ContentProvider;
import de.cni.client.gui.tiles.table.templates.ITableComposite;
import de.cni.client.gui.tiles.table.templates.ITableController;
import de.cni.client.gui.tiles.table.templates.ITableViewerSorter;
import de.cni.client.gui.tiles.table.templates.TableCellModifier;
import de.cni.client.gui.util.AdvancedGroup;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.GlobalData;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public abstract class TableComposite
implements ITableComposite {
    private static Log log = LogFactory.getLog(TableComposite.class);
    boolean autoscale = false;
    ITableController controller;
    ITableViewerSorter tableViewerSorter;
    TableViewer tableViewer = null;
    Composite parent;
    String[] columnNameArray;
    int[] columnWidthArray;
    int[] alignmentArray;
    AdvancedGroup group;
    String grouptext;
    WidgetFactory guiUtil = new WidgetFactory();

    public TableComposite(ITableController controller, String grouptext, String[] columnNameArray, int[] columnWidthArray, int[] alignmentArray) {
        this.controller = controller;
        this.columnNameArray = columnNameArray;
        this.columnWidthArray = columnWidthArray;
        this.alignmentArray = alignmentArray;
        this.grouptext = grouptext;
        this.autoscale = GlobalData.getInstance().isAutoscale();
        if (columnWidthArray != null) {
            this.autoscale = false;
        }
    }

    @Override
    public Composite createContent(Composite parent, int height) {
        this.parent = parent;
        try {
            this.group = GuiContainer.newFillAdvancedGroup(parent, this.grouptext, 1, 1, null);
            Composite composite = GuiContainer.newFillComposite(this.group.getContentComposite(), 1);
            ITableLabelProvider labelProvider = this.controller.createLabelProvider();
            ContentProvider contentProvider = new ContentProvider();
            int format = 68116;
            if (!this.autoscale) {
                format |= 0x100;
            }
            this.tableViewer = new TableViewer(composite, format);
            this.createColumns(this.columnNameArray);
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            if (this.autoscale) {
                composite.setLayout((Layout)tableColumnLayout);
            }
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.tableViewerSorter = this.controller.createTableViewerSorter();
            if (this.tableViewerSorter != null) {
                this.tableViewer.setSorter(this.tableViewerSorter.getViewerSorter());
                this.controller.setDefaultSort();
            }
            this.tableViewer.setInput(this.controller.getObjectList());
            GridData tableGridData = new GridData(1808);
            if (height > 0) {
                tableGridData.heightHint = height;
            }
            Table table = this.tableViewer.getTable();
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            table.setLayoutData((Object)tableGridData);
            composite.setLayoutData((Object)tableGridData);
            table.setFont(GlobalData.getInstance().getDefaultFont());
            String[] columnProperties = new String[this.columnNameArray.length + 1];
            if (this.autoscale) {
                tableColumnLayout.setColumnData((Widget)table.getColumn(0), (ColumnLayoutData)new ColumnWeightData(0));
                table.getColumn(0).setWidth(0);
            } else {
                table.getColumn(0).setWidth(0);
            }
            table.getColumn(0).setResizable(false);
            table.getColumn(0).setMoveable(false);
            table.getColumn(0).setAlignment(16384);
            columnProperties[0] = "0";
            for (int i = 0; i < this.columnNameArray.length; ++i) {
                if (this.columnWidthArray != null && this.columnWidthArray[0] >= 0) {
                    if (this.autoscale) {
                        tableColumnLayout.setColumnData((Widget)table.getColumn(i + 1), (ColumnLayoutData)new ColumnWeightData(this.columnWidthArray[i]));
                    } else {
                        table.getColumn(i + 1).setWidth(this.columnWidthArray[i]);
                    }
                } else if (this.autoscale) {
                    tableColumnLayout.setColumnData((Widget)table.getColumn(i + 1), (ColumnLayoutData)new ColumnWeightData(1));
                } else {
                    table.getColumn(i + 1).pack();
                }
                table.getColumn(i + 1).setMoveable(true);
                table.getColumn(i + 1).setAlignment(this.alignmentArray[i]);
                columnProperties[i + 1] = Integer.toString(i + 1);
            }
            this.tableViewer.setColumnProperties(columnProperties);
            TableCellModifier tcm = this.controller.createCellModifier(this.tableViewer, this.guiUtil);
            if (tcm != null) {
                this.tableViewer.setCellModifier((ICellModifier)tcm);
                this.tableViewer.setCellEditors(tcm.getCellEditors());
            }
            this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    TableComposite.this.controller.doubleClick(selection.getFirstElement());
                }
            });
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    TableComposite.this.controller.selectionChanged(selection.getFirstElement(), selection.size());
                }
            });
            this.createButtons((Composite)this.group);
            return this.group;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, "technischer Fehler beim Erzeugen der Tabelle. ", e);
            e.printStackTrace();
            log.error((Object)("technischer Fehler beim Erzeugen der Tabelle. " + e.getMessage()));
            return null;
        }
    }

    @Override
    public void createColumns(String[] titles) {
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setText("");
        column.getColumn().setResizable(false);
        for (int i = 0; i < titles.length; ++i) {
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setResizable(true);
            final int col = i + 1;
            column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ((ITableViewerSorter)TableComposite.this.tableViewer.getSorter()).setSortColumn(col);
                    TableComposite.this.tableViewer.refresh();
                }
            });
        }
    }

    @Override
    public void setData() {
        if (GlobalData.getInstance().isMacos()) {
            this.tableViewer.getTable().setLinesVisible(false);
            this.tableViewer.getTable().setLinesVisible(true);
        }
        this.tableViewer.setInput(this.controller.getObjectList());
        this.tableViewer.refresh();
        this.setGroupText();
    }

    private void setGroupText() {
        if (this.controller != null && this.controller.getObjectList() != null && this.controller.getObjectList().size() > 0) {
            this.group.setText(this.grouptext + "   (" + this.controller.getObjectList().size() + ")");
        } else {
            this.group.setText(this.grouptext);
        }
    }

    @Override
    public void setChangedFlag(boolean flag) {
        this.guiUtil.setChanged(flag);
    }

    @Override
    public List<Object> getSelectedObjects() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        return selection.toList();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.guiUtil.enableAllWidgets();
        } else {
            this.guiUtil.disableAllWidgets();
        }
    }

    @Override
    public boolean isDataChanged() {
        return this.guiUtil.isChanged();
    }

    @Override
    public void setSelection(Object object) {
        this.tableViewer.refresh();
        if (object != null) {
            StructuredSelection selection = new StructuredSelection(object);
            this.tableViewer.setSelection((ISelection)selection, true);
        }
    }

    @Override
    public abstract void createButtons(Composite var1);

    @Override
    public abstract void refreshButtons();
}

