/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table.templates;

import de.cni.client.gui.tiles.table.templates.ITableComposite;
import de.cni.client.gui.tiles.table.templates.ITableController;
import de.cni.client.gui.tiles.table.templates.TableComposite;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.GuiElements;
import de.cni.client.gui.util.Resources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SortableTableComposite
extends TableComposite
implements ITableComposite {
    boolean withDeleteButton;
    boolean withNewButton;
    boolean withCustomButton;
    ButtonWrapper newLine;
    ButtonWrapper deleteLine;
    ButtonWrapper customButton;
    Resources.ICON customIcon;
    String customTip;

    public SortableTableComposite(ITableController controller, String grouptext, String[] columnNameArray, int[] columnWidthArray, int[] alignmentArray, boolean withNewButton, boolean withDeleteButton) {
        super(controller, grouptext, columnNameArray, columnWidthArray, alignmentArray);
        this.withNewButton = withNewButton;
        this.withDeleteButton = withDeleteButton;
        this.withCustomButton = false;
    }

    public SortableTableComposite(ITableController controller, String grouptext, String[] columnNameArray, int[] columnWidthArray, int[] alignmentArray, boolean withNewButton, boolean withDeleteButton, Resources.ICON customIcon, String customTip) {
        super(controller, grouptext, columnNameArray, columnWidthArray, alignmentArray);
        this.withNewButton = withNewButton;
        this.withDeleteButton = withDeleteButton;
        this.withCustomButton = true;
        this.customIcon = customIcon;
        this.customTip = customTip;
    }

    public void setDefaultSort(int column, boolean direction) {
        this.tableViewerSorter.setSortColumn(column);
        this.tableViewerSorter.setDirection(direction);
    }

    @Override
    public void createButtons(Composite parent) {
        if (!this.withDeleteButton && !this.withNewButton) {
            return;
        }
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.pack = false;
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayout((Layout)buttonLayout);
        if (this.withNewButton) {
            this.newLine = this.guiUtil.createPushButton(buttonsComposite, "Neue Zeile einf\u00fcgen", Resources.ICON.SMALL_ADD);
            this.newLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SortableTableComposite.this.controller.newLine();
                }
            });
        }
        if (this.withDeleteButton) {
            this.deleteLine = this.guiUtil.createPushButton(buttonsComposite, "Zeile l\u00f6schen", Resources.ICON.SMALL_REMOVE);
            this.deleteLine.setId(GuiElements.BUTTON_DELETE, this.guiUtil);
            this.deleteLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SortableTableComposite.this.controller.deleteLine();
                }
            });
        }
        if (this.withCustomButton) {
            this.customButton = this.guiUtil.createPushButton(buttonsComposite, this.customTip, this.customIcon);
            this.customButton.setId(GuiElements.BUTTON_EXECUTE, this.guiUtil);
            this.customButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SortableTableComposite.this.controller.customButton();
                }
            });
        }
    }

    @Override
    public void refreshButtons() {
        if (this.deleteLine != null) {
            if (this.controller.getPageSelectionStatus() == ITableController.PageSelectionStatus.oneLineSelected) {
                this.guiUtil.enableOneWidget(this.deleteLine);
                this.guiUtil.enableOneWidget(this.customButton);
            } else {
                this.guiUtil.disableOneWidget(this.deleteLine);
                this.guiUtil.disableOneWidget(this.customButton);
            }
        }
    }
}

