/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table.templates;

import de.cni.client.gui.tiles.table.templates.ITableController;
import de.cni.client.gui.tiles.table.templates.TableComposite;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.GuiElements;
import de.cni.client.gui.util.Resources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EditableTableComposite
extends TableComposite {
    boolean withSortButtons;
    ButtonWrapper newLine;
    ButtonWrapper deleteLine;
    ButtonWrapper up;
    ButtonWrapper down;

    public EditableTableComposite(ITableController controller, String grouptext, String[] columnNameArray, int[] columnWidthArray, int[] alignmentArray, boolean withSortButtons) {
        super(controller, grouptext, columnNameArray, columnWidthArray, alignmentArray);
        this.withSortButtons = withSortButtons;
    }

    @Override
    public void createButtons(Composite parent) {
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.pack = false;
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayout((Layout)buttonLayout);
        this.newLine = this.guiUtil.createPushButton(buttonsComposite, "Neue Zeile einf\u00fcgen", Resources.ICON.SMALL_ADD);
        this.deleteLine = this.guiUtil.createPushButton(buttonsComposite, "Zeile l\u00f6schen", Resources.ICON.SMALL_REMOVE);
        this.newLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableTableComposite.this.controller.newLine();
            }
        });
        this.deleteLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableTableComposite.this.controller.deleteLine();
            }
        });
        if (this.withSortButtons) {
            this.up = this.guiUtil.createPushButton(buttonsComposite, "Zeile nach oben verschieben", Resources.ICON.SMALL_UP);
            this.down = this.guiUtil.createPushButton(buttonsComposite, "Zeile nach unten verschieben", Resources.ICON.SMALL_DOWN);
            this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableComposite.this.controller.up();
                }
            });
            this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableComposite.this.controller.down();
                }
            });
            this.up.setId(GuiElements.BUTTON_ARROW, this.guiUtil);
            this.down.setId(GuiElements.BUTTON_ARROW, this.guiUtil);
        }
    }

    @Override
    public void refreshButtons() {
        if (this.controller.getPageSelectionStatus() == ITableController.PageSelectionStatus.oneLineSelected) {
            this.guiUtil.enableOneWidget(this.deleteLine);
            if (this.controller.isFirstElement(this.getSelectedObjects().get(0))) {
                this.guiUtil.disableOneWidget(this.up);
            } else {
                this.guiUtil.enableOneWidget(this.up);
            }
            if (this.controller.isLastElement(this.getSelectedObjects().get(0))) {
                this.guiUtil.disableOneWidget(this.down);
            } else {
                this.guiUtil.enableOneWidget(this.down);
            }
        } else {
            this.guiUtil.disableOneWidget(this.deleteLine);
            this.guiUtil.disableOneWidget(this.up);
            this.guiUtil.disableOneWidget(this.down);
        }
    }
}

