/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table;

import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.tiles.table.ColDef;
import de.cni.client.gui.tiles.table.PersonBefundLabelProvider;
import de.cni.client.gui.tiles.table.templates.SortableTableController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.Resources;
import de.cni.client.paint.Controlpanel;
import de.cni.client.paint.DocumentCreator;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.PersonBefund;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ITableLabelProvider;

public class PersonBefundTableController
extends SortableTableController {
    private static Log log = LogFactory.getLog(PersonBefundTableController.class);
    public static final int COLIDX_GRUPPE = 1;
    public static final int COLIDX_UEBERSCHRIFT = 2;
    public static final int COLIDX_TEXT = 3;
    public static final int COLIDX_CNT = 4;
    private PersonendatenController personendatenController;
    ColDef[] colDefArray = new ColDef[]{new ColDef("Datum", 80, 16384), new ColDef("\u00dcberschrift", 200, 16384), new ColDef("Text", 150, 16384)};

    private void initialize() {
        this.height = 60;
        this.groupname = "Befund";
        this.columnNameArray = ColDef.getColumnNameArray(this.colDefArray);
        this.alignmentArray = ColDef.getAlignmentArray(this.colDefArray);
        this.columnWidthArray = ColDef.getColumnWidthArray(this.colDefArray);
    }

    public PersonBefundTableController(PersonendatenController personendatenController) {
        super(true, true, Resources.ICON.TRANSIT, "Transit Horoskop");
        this.initialize();
        this.personendatenController = personendatenController;
    }

    @Override
    public ITableLabelProvider createLabelProvider() {
        return new PersonBefundLabelProvider();
    }

    @Override
    public int compare(int column, Object o1, Object o2) {
        int rc = super.compare(column, o1, o2);
        PersonBefund p1 = (PersonBefund)o1;
        PersonBefund p2 = (PersonBefund)o2;
        switch (column) {
            case 1: {
                rc = Util.compare(p1.getDatum(), p2.getDatum());
            }
        }
        return rc;
    }

    @Override
    public void customButton() {
        try {
            List<Object> l = this.getSelectedObjects();
            if (l == null && l.size() != 1) {
                Popup.info("Sie m\u00fcssen eine Zeile ausw\u00e4hlen");
                return;
            }
            PersonBefund pb = (PersonBefund)l.get(0);
            Personendaten pd = (Personendaten)this.personendatenController.getCurrentBusinessObject();
            if (pb == null || pd == null) {
                Popup.info("Mit den ausgew\u00e4hlten Daten kann kein Transit Horoskop erstellt werden");
                return;
            }
            Date date = pb.getDatum();
            if (date == null) {
                Popup.info("Zum Befund ist kein Datum hinterlegt.");
                return;
            }
            HoroskopCalculator hc = new HoroskopCalculator();
            hc.calculateTransit(pd, date);
            Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());
            DocumentCreator creator = new DocumentCreator(hc, controlpanel).createDocument();
            creator.popupHoroskop();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }
}

