/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table;

import de.cni.client.gui.tiles.table.templates.LabelProvider;
import de.cni.client.gui.util.Resources;
import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.DropdownText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Image;

public class DropdownTextLabelProvider
extends LabelProvider {
    private static Log log = LogFactory.getLog(DropdownTextLabelProvider.class);

    @Override
    public String getColumnText(Object element, int columnIndex) {
        try {
            DropdownText dropdownText = (DropdownText)element;
            if (columnIndex == 1) {
                return Util.NotNull(dropdownText.getDomain());
            }
            if (columnIndex == 2) {
                return Converter.intToNotNullString(dropdownText.getDomainkey());
            }
            if (columnIndex == 3) {
                return null;
            }
            if (columnIndex == 4) {
                return Converter.intToNotNullString(dropdownText.getSortId());
            }
            if (columnIndex == 5) {
                return Util.NotNull(dropdownText.getKurztext());
            }
            if (columnIndex == 6) {
                return Util.NotNull(dropdownText.getLangtext());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return "";
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        try {
            DropdownText dropdownText = (DropdownText)element;
            if (columnIndex == 3) {
                if (dropdownText.isDefaultValue()) {
                    return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_TRUE);
                }
                return Resources.getInstance().getImage(Resources.ICON.BOOLEAN_FALSE);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return null;
    }
}

