/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.templates.treeAndDetail;

import de.cni.common.datamodel.IBusinessTreeObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeManipulator {
    private static Log log = LogFactory.getLog(TreeManipulator.class);

    public static IBusinessTreeObject findInTree(List<IBusinessTreeObject> businessObjectList, IBusinessTreeObject savedBusinessObject) {
        if (businessObjectList == null || savedBusinessObject == null) {
            return null;
        }
        IBusinessTreeObject businessObjectInList = null;
        for (int index = 0; index < businessObjectList.size(); ++index) {
            businessObjectInList = businessObjectList.get(index);
            if (businessObjectInList.getClass() == savedBusinessObject.getClass() && businessObjectInList.isIdentical(savedBusinessObject)) {
                return businessObjectInList;
            }
            IBusinessTreeObject child = TreeManipulator.findInTree(businessObjectInList.getChildren(), savedBusinessObject);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static boolean createOrReplaceInTree(int searchForId, List<IBusinessTreeObject> businessObjectList, IBusinessTreeObject savedBusinessObject) {
        boolean found = false;
        if (businessObjectList == null || savedBusinessObject == null) {
            return found;
        }
        IBusinessTreeObject businessObjectInList = null;
        for (int index = 0; index < businessObjectList.size(); ++index) {
            businessObjectInList = businessObjectList.get(index);
            if (businessObjectInList.getClass() == savedBusinessObject.getClass()) {
                if (businessObjectInList.getId() != searchForId) continue;
                businessObjectList.set(index, savedBusinessObject);
                found = true;
                log.debug((Object)("LockID vorher" + businessObjectInList.getLockId() + " nachher" + savedBusinessObject.getLockId()));
                return found;
            }
            if (!businessObjectInList.replaceChild(searchForId, savedBusinessObject)) continue;
            return true;
        }
        if (!found && businessObjectInList != null && businessObjectInList.getClass() == savedBusinessObject.getClass()) {
            businessObjectList.add(savedBusinessObject);
            found = true;
        }
        return found;
    }

    public static void putToList(List<IBusinessTreeObject> businessObjectList, IBusinessTreeObject newBusinessObject) {
        if (newBusinessObject == null) {
            return;
        }
        if (businessObjectList == null) {
            return;
        }
        IBusinessTreeObject businessObjectInList = null;
        for (int index = 0; index < businessObjectList.size(); ++index) {
            businessObjectInList = businessObjectList.get(index);
            if (!businessObjectInList.isIdentical(newBusinessObject)) continue;
            businessObjectList.set(index, newBusinessObject);
            return;
        }
        businessObjectList.add(newBusinessObject);
    }

    public static boolean removeFromTree(List<IBusinessTreeObject> businessObjectList, IBusinessTreeObject businessTreeObject) {
        IBusinessTreeObject parent = businessTreeObject.getParent();
        if (parent == null) {
            return businessObjectList.remove(businessTreeObject);
        }
        return parent.removeChild(businessTreeObject);
    }
}

