/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.templates.treeAndDetail;

import de.cni.client.gui.action.toolbar.EditAction;
import de.cni.client.gui.action.toolbar.SaveAction;
import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.templates.filter.IFilterHeaderTile;
import de.cni.client.gui.templates.tableAndDetail.IDetailTile;
import de.cni.client.gui.templates.treeAndDetail.ITreeDetailPage;
import de.cni.client.gui.templates.treeAndDetail.ITreeDetailPageController;
import de.cni.client.gui.tiles.tree.templates.ITreeController;
import de.cni.client.gui.util.BusinessObjectStatusTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.common.core.GlobalData;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.IBusinessTreeObject;
import de.cni.common.exceptions.MappingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class TreeDetailPage
implements ITreeDetailPage {
    private static Log log = LogFactory.getLog(TreeDetailPage.class);
    public int treeHeight = 0;
    int[] treeDetailWeights = new int[]{2, 3, 0};
    final int layoutNumColumns = 3;
    ITreeController treeController;
    Composite parent;
    protected ITreeDetailPageController controller;
    IFilterHeaderTile filterHeaderTile;
    IDetailTile detailTile;
    BusinessObjectStatusTile boStatusTile = new BusinessObjectStatusTile();

    public TreeDetailPage(ITreeDetailPageController controller) {
        this.controller = controller;
    }

    public TreeDetailPage(ITreeDetailPageController controller, int treeHeight, int[] weights) {
        this.controller = controller;
        this.treeDetailWeights = weights;
        this.treeHeight = treeHeight;
    }

    public TreeDetailPage(ITreeDetailPageController controller, int treeHeight) {
        this.controller = controller;
        this.treeHeight = treeHeight;
    }

    public TreeDetailPage(ITreeDetailPageController controller, int[] weights) {
        this.controller = controller;
        this.treeDetailWeights = weights;
    }

    public TreeDetailPage(ITreeDetailPageController controller, int treeHeight, int[] weightsHighRes, int[] weightsLowRes) {
        this.controller = controller;
        this.treeDetailWeights = GlobalData.getInstance().isHighResolution() ? weightsHighRes : weightsLowRes;
        this.treeHeight = treeHeight;
    }

    @Override
    public Composite createContent(Composite parent) {
        try {
            this.parent = parent;
            Composite pageComposite = GuiContainer.newFillComposite(parent, 1);
            this.filterHeaderTile = this.createFilterTile(this.controller, this.treeDetailWeights);
            this.filterHeaderTile.createContent(pageComposite);
            GridData detailGridData = new GridData(1808);
            detailGridData.grabExcessHorizontalSpace = true;
            detailGridData.grabExcessVerticalSpace = true;
            SashForm treeDetailSash = new SashForm(pageComposite, 256);
            treeDetailSash.setLayoutData((Object)detailGridData);
            this.treeController = this.createTreeController();
            this.treeController.createContent(treeDetailSash, this.treeHeight);
            this.treeController.registerListener(this.controller);
            Composite rightComposite = GuiContainer.newComposite((Composite)treeDetailSash, 1);
            this.detailTile = this.createDetailTile(this.controller);
            this.detailTile.createContent(rightComposite);
            this.boStatusTile.createContent(rightComposite, this.detailTile.getLabelColumnWidth());
            GuiContainer.newDummy((Composite)treeDetailSash);
            treeDetailSash.setWeights(this.treeDetailWeights);
            this.filterHeaderTile.setFocus();
            return pageComposite;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            return null;
        }
    }

    @Override
    public void handleSelectionChanged() {
        if (this.controller.isPopupMode()) {
            return;
        }
        if (this.controller.getPageSelectionStatus() == IPageController.PageSelectionStatus.noSelection) {
            this.controller.getToolbarWrapper().setEnabled(EditAction.id, false);
        } else if (this.controller.getPageSelectionStatus() == IPageController.PageSelectionStatus.oneLineSelected) {
            this.controller.getToolbarWrapper().setEnabled(EditAction.id, true);
        } else if (this.controller.getPageSelectionStatus() == IPageController.PageSelectionStatus.multiLinesSelected) {
            this.controller.getToolbarWrapper().setEnabled(EditAction.id, false);
        }
    }

    @Override
    public void handleEditChanged() {
        if (this.controller.isPopupMode()) {
            this.detailTile.setEnabled(false);
            this.treeController.setEnabled(false);
            return;
        }
        if (this.controller.getPageEditStatus() == IPageController.PageEditStatus.disabled) {
            this.detailTile.setEnabled(GlobalData.getInstance().isAlwaysEnabled());
            this.controller.getToolbarWrapper().setEnabled(SaveAction.id, GlobalData.getInstance().isAlwaysEnabled());
        } else if (this.controller.getPageEditStatus() == IPageController.PageEditStatus.enabledforNew) {
            this.detailTile.setEnabled(true);
            this.controller.getToolbarWrapper().setEnabled(SaveAction.id, true);
            this.detailTile.enableButtons(true);
        } else if (this.controller.getPageEditStatus() == IPageController.PageEditStatus.enabledforUpdate) {
            this.detailTile.setEnabled(true);
            this.controller.getToolbarWrapper().setEnabled(SaveAction.id, true);
            this.detailTile.enableButtons(true);
        }
    }

    @Override
    public boolean isDataChanged() {
        return this.detailTile.isDataChanged();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.detailTile.setEnabled(enabled);
    }

    @Override
    public void refresh() {
        this.treeController.setObjectList(this.controller.getBusinessObjectList());
        this.setSelection(this.controller.getCurrentBusinessObject());
    }

    @Override
    public void clear() {
        try {
            this.detailTile.setData(this.controller.createNewBusinessObject());
            this.setSelection(this.controller.getCurrentBusinessObject());
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public void setData(List<IBusinessTreeObject> businessObjectList) {
        this.treeController.setObjectList(businessObjectList);
        this.setChanged(false);
    }

    @Override
    public List<IBusinessTreeObject> getData() {
        return this.treeController.getObjectList();
    }

    @Override
    public void setFilter(IBusinessObject object) {
        try {
            this.filterHeaderTile.setPageFilterData(object);
        }
        catch (MappingException e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public IBusinessObject getFilter() {
        try {
            return this.filterHeaderTile.getPageFilterData();
        }
        catch (MappingException e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }

    @Override
    public void setBusinessObject(IBusinessTreeObject object) {
        try {
            this.detailTile.setData(object);
            this.boStatusTile.setData(object);
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    @Override
    public IBusinessTreeObject getBusinessObject() {
        try {
            return (IBusinessTreeObject)this.detailTile.getData();
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            return null;
        }
    }

    @Override
    public List<IBusinessTreeObject> getSelectedBusinessObject() {
        return this.treeController.getSelectedObjects();
    }

    @Override
    public void setSelection(IBusinessTreeObject bo) {
        this.treeController.setSelection(bo);
    }

    @Override
    public void setChanged(boolean flag) {
        this.detailTile.setDataChanged(flag);
    }

    @Override
    public IDetailTile getIDetailTile() {
        return this.detailTile;
    }

    @Override
    public void setIDetailTile(IDetailTile detailTile) {
        this.detailTile = detailTile;
    }

    @Override
    public abstract ITreeController createTreeController();

    @Override
    public abstract IBusinessTreeObject createBusinessObject();

    @Override
    public abstract IFilterHeaderTile createFilterTile(ITreeDetailPageController var1, int[] var2);

    @Override
    public abstract IDetailTile createDetailTile(ITreeDetailPageController var1);

    @Override
    public boolean showCanceled() {
        return this.treeController.withCanceled();
    }

    @Override
    public IFilterHeaderTile getFilterHeaderTile() {
        return this.filterHeaderTile;
    }
}

