/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.page;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.templates.tableAndDetail.IDetailTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.validation.popupselection.ISelectionValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupTileDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupTileDialog.class);
    private int minSizeX;
    private int minSizeY;
    public static final int ABORT_ID = 0;
    public static final int SELECT_ID = 1;
    public final String SAVE_LABEL = "Speichern";
    public final String SELECT_LABEL = "\u00dcbernehmen";
    public final String ABORT_LABEL = "Abbrechen";
    public final String CLOSE_LABEL = "Beenden";
    private IDetailTile tile;
    private Object initObject;
    private IBusinessObject businessObject;
    private ISelectionValidator validator;
    int buttonPressedId;
    Mode mode = Mode.EDIT;

    public PopupTileDialog(IDetailTile tile, Object initObject, Shell shell, Mode mode, ISelectionValidator validator) {
        super(shell);
        this.tile = tile;
        this.initObject = initObject;
        this.validator = validator;
        this.mode = mode;
    }

    public void setMinSizeX(int minSizeX) {
        this.minSizeX = minSizeX;
    }

    public void setMinSizeY(int minSizeY) {
        this.minSizeY = minSizeY;
    }

    protected void buttonPressed(int buttonId) {
        this.buttonPressedId = buttonId;
        if (buttonId == 1) {
            try {
                this.businessObject = this.tile.getData();
            }
            catch (Exception e) {
                this.businessObject = null;
                ErrorHandler.handleError(log, e);
            }
            if (this.validator != null && !this.validator.isSelectionValid(this.businessObject)) {
                MainApplicationWindow.getInstance().popupError(this.validator.getErrorText());
                return;
            }
        }
        this.close();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Details");
        return contents;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        if (this.minSizeX > 0) {
            shellSize.x = this.minSizeX;
        }
        if (this.minSizeY > 0) {
            shellSize.y = this.minSizeY;
        }
        return shellSize;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        try {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.tile.createContent(composite);
            this.tile.setData((IBusinessObject)this.initObject);
            return composite;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.mode == Mode.EDIT) {
            this.createButton(parent, 1, "\u00dcbernehmen", false);
            this.createButton(parent, 0, "Abbrechen", false);
        } else if (this.mode == Mode.SAVE) {
            this.createButton(parent, 1, "Speichern", false);
            this.createButton(parent, 0, "Abbrechen", false);
        } else {
            this.createButton(parent, 0, "Beenden", false);
            this.getButton(0).setFocus();
        }
    }

    public IBusinessObject getBusinessObject() {
        return this.businessObject;
    }

    public void setBusinessObject(IBusinessObject businessObject) {
        this.businessObject = businessObject;
    }

    public int getButtonPressedId() {
        return this.buttonPressedId;
    }

    public static enum Mode {
        SHOW,
        EDIT,
        SAVE;

    }
}

