/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.page;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.tiles.table.templates.ITableController;
import de.cni.client.gui.tiles.table.templates.ITableListener;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.validation.popupselection.ISelectionValidator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupTableDialog
extends TitleAreaDialog
implements ITableListener {
    private int minSizeX;
    private int minSizeY;
    public static final int ABORT_ID = 0;
    public static final int SELECT_ID = 1;
    public static final int EMPTY_ID = 2;
    private String ueberschrift = "Ergebnis Liste der Suche";
    private String SELECT_LABEL = "\u00dcbernehmen";
    private String ABORT_LABEL = "Abbrechen";
    private String CLOSE_LABEL = "Beenden";
    private String EMPTY_LABEL = "Keinen";
    private ITableController controller;
    private IBusinessObject businessObject;
    private ISelectionValidator validator;
    int buttonPressedId;
    Mode mode = Mode.SELECT;
    List<IBusinessObject> objectList;
    boolean withEmpty = true;

    public PopupTableDialog(ITableController controller, List<IBusinessObject> objectList, Shell shell, Mode mode, ISelectionValidator validator) {
        super(shell);
        this.controller = controller;
        this.validator = validator;
        this.mode = mode;
        this.objectList = objectList;
        controller.registerListener(this);
    }

    public void setMinSizeX(int minSizeX) {
        this.minSizeX = minSizeX;
    }

    public void setMinSizeY(int minSizeY) {
        this.minSizeY = minSizeY;
    }

    @Override
    public void doubleClick(Object object) {
        this.buttonPressed(1);
    }

    protected void buttonPressed(int buttonId) {
        List<?> objectList;
        this.buttonPressedId = buttonId;
        if (buttonId == 1 && (objectList = this.controller.getSelectedObjects()).size() > 0) {
            this.businessObject = (IBusinessObject)objectList.get(0);
            if (this.validator != null && !this.validator.isSelectionValid(this.businessObject)) {
                MainApplicationWindow.getInstance().popupError(this.validator.getErrorText());
                return;
            }
        }
        this.close();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.ueberschrift);
        return contents;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        if (this.minSizeX > 0) {
            shellSize.x = this.minSizeX;
        }
        if (this.minSizeY > 0) {
            shellSize.y = this.minSizeY;
        }
        return shellSize;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.controller.createContent(parent, MainApplicationWindow.getInstance().getHeight() * 2 / 3);
        this.controller.setObjectList(this.objectList);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.mode == Mode.SELECT) {
            this.createButton(parent, 1, this.SELECT_LABEL, false);
            if (this.withEmpty) {
                this.createButton(parent, 2, this.EMPTY_LABEL, false);
            }
            this.createButton(parent, 0, this.ABORT_LABEL, false);
        } else {
            this.createButton(parent, 0, this.CLOSE_LABEL, false);
        }
    }

    public IBusinessObject getBusinessObject() {
        return this.businessObject;
    }

    public void setBusinessObject(IBusinessObject businessObject) {
        this.businessObject = businessObject;
    }

    public int getButtonPressedId() {
        return this.buttonPressedId;
    }

    @Override
    public boolean deleteLine() {
        return false;
    }

    @Override
    public boolean newLine() {
        return false;
    }

    @Override
    public void selectionChanged(Object firstObject, int cnt) {
    }

    public boolean isWithEmpty() {
        return this.withEmpty;
    }

    public void setWithEmpty(boolean withEmpty) {
        this.withEmpty = withEmpty;
    }

    public String getABORT_LABEL() {
        return this.ABORT_LABEL;
    }

    public String getCLOSE_LABEL() {
        return this.CLOSE_LABEL;
    }

    public String getEMPTY_LABEL() {
        return this.EMPTY_LABEL;
    }

    public void setABORT_LABEL(String abort_label) {
        this.ABORT_LABEL = abort_label;
    }

    public void setCLOSE_LABEL(String close_label) {
        this.CLOSE_LABEL = close_label;
    }

    public void setEMPTY_LABEL(String empty_label) {
        this.EMPTY_LABEL = empty_label;
    }

    public String getSELECT_LABEL() {
        return this.SELECT_LABEL;
    }

    public void setSELECT_LABEL(String select_label) {
        this.SELECT_LABEL = select_label;
    }

    public String getUeberschrift() {
        return this.ueberschrift;
    }

    public void setUeberschrift(String ueberschrift) {
        this.ueberschrift = ueberschrift;
    }

    public static enum Mode {
        SHOW,
        SELECT,
        EDIT;

    }
}

