/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupTokenReplacerTile;
import de.cni.client.gui.util.ErrorHandler;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupTokenReplacerDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupTokenReplacerDialog.class);
    public static final int DRUCKEN_ID = 1;
    public static final int SPEICHERN_ID = 2;
    public static final int EMAIL_ID = 3;
    public static final int ABORT_ID = 4;
    private PopupTokenReplacerTile tile = null;
    private String text;
    private Map<String, String> tokenmap;

    public PopupTokenReplacerDialog(Shell parentShell, Map<String, String> tokenmap, String text) {
        super(parentShell);
        this.text = text;
        this.tokenmap = tokenmap;
        this.tile = new PopupTokenReplacerTile(text, tokenmap);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Variable Textstellen ausf\u00fcllen");
        this.setMessage("Bitte geben Sie die Werte f\u00fcr die variablen Textstellen ein.", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.text = null;
            this.setReturnCode(buttonId);
            if (buttonId == 1 || buttonId == 2 || buttonId == 3) {
                this.tokenmap = this.tile.getData();
                if (!this.tile.isValid(this.tokenmap)) {
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public Map<String, String> getTokenmap() {
        return this.tokenmap;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Drucken", true);
        this.createButton(parent, 2, "Speichern", false);
        this.createButton(parent, 4, "Abbrechen", false);
    }
}

