/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupTextfieldTile;
import de.cni.client.gui.util.ErrorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupTextfieldDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupTextfieldDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    public static final int SAVE_ID = 3;
    PopupTextfieldTile tile = null;
    String value;
    boolean onlyInfoPopup;
    boolean withSaveButton;
    int limit = 0;

    public PopupTextfieldDialog(Shell parentShell, int limit, String name, String value) {
        super(parentShell);
        this.value = value;
        this.tile = new PopupTextfieldTile(name);
        this.onlyInfoPopup = false;
        this.limit = limit;
    }

    public PopupTextfieldDialog(Shell parentShell, int limit, String name, String value, boolean onlyInfoPopup) {
        super(parentShell);
        this.value = value;
        this.tile = new PopupTextfieldTile(name);
        this.onlyInfoPopup = onlyInfoPopup;
    }

    public PopupTextfieldDialog(Shell parentShell, int limit, String name, String value, boolean onlyInfoPopup, boolean withSaveButton) {
        super(parentShell);
        this.value = value;
        this.onlyInfoPopup = onlyInfoPopup;
        this.withSaveButton = withSaveButton;
        this.tile = new PopupTextfieldTile(name);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Daten erfassen");
            this.setMessage("Bitte erg\u00e4nzen Sie die Daten.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite, this.limit);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.value);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.value = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.value = this.tile.getData();
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public String getBusinessObject() {
        return this.value;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 2, "Leer", false);
            this.createButton(parent, 1, "Abbrechen", false);
        }
        if (this.withSaveButton) {
            this.createButton(parent, 3, "Speichern", false);
        }
    }
}

