/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.personendaten.ReportjobController;
import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.popup.filter.PopupHoroskopPictureDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.StyledTextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.client.paint.ColorFactory;
import de.cni.client.paint.Controlpanel;
import de.cni.client.paint.DocumentCreator;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.core.Util;
import de.cni.common.datamodel.DocumentParameter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupTextColumnDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupHoroskopPictureDialog.class);
    private WidgetFactory guiUtil = new WidgetFactory(3);
    public static final int PRINT_ID = 3;
    public static final String PRINT_LABEL = "Drucken";
    public static final int SAVE_ID = 2;
    public static final String SAVE_LABEL = "Speichern";
    public static final int CLOSE_ID = 0;
    public static final String CLOSE_LABEL = "OK";
    boolean withTabs = true;
    boolean withSymbols;
    String[] ueberschriftListe = new String[]{"Horoskop 1", "Aspektarium 1", "Horoskop 2", "Aspektarium 2", "Inter-Aspektarium"};
    String[] textListe;
    int[] astrodatenTabStops = new int[]{75, 240};
    int[] aspektariumTabStopsWithSymbols = new int[]{20, 70, 80, 100, 150, 170, 190, 230, 260, 310};
    int[] aspektariumTabStopsWithoutSymbols = new int[]{50, 70, 130, 150, 230, 260, 310};
    HoroskopCalculator horoskopCalculator;
    Controlpanel controlpanel;
    int size = 0;

    public PopupTextColumnDialog(Shell parentShell, HoroskopCalculator horoskopCalculator, Controlpanel controlpanel, boolean withTabs, boolean withSymbols, String ... text) {
        super(parentShell);
        this.controlpanel = controlpanel;
        this.horoskopCalculator = horoskopCalculator;
        this.withSymbols = withSymbols;
        this.textListe = text;
        if (this.textListe != null) {
            for (int i = 0; i < this.textListe.length; ++i) {
                if (Util.isEmpty(this.textListe[i])) continue;
                ++this.size;
            }
        }
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Rohdaten");
        CTabFolder tabFolder = GuiContainer.newCTabFolder(parent);
        Composite master = null;
        if (!this.withTabs) {
            master = GuiContainer.newFillComposite(parent, this.size);
        }
        if (this.textListe == null) {
            return tabFolder;
        }
        for (int i = 0; i < this.textListe.length; ++i) {
            if (Util.isEmpty(this.textListe[i])) continue;
            if (this.withTabs) {
                CTabItem tabItem1 = new CTabItem(tabFolder, 0);
                tabItem1.setText(this.ueberschriftListe[i]);
                Composite tab1 = GuiContainer.newCTabItemComposite(tabFolder, tabItem1, 1);
                master = GuiContainer.newFillComposite(tab1, 1);
            }
            StyledTextWrapper t = this.guiUtil.createScrollTextBlock1(master, this.ueberschriftListe[i], 450, this.withTabs ? 700 : 330, 0);
            if (i == 0 || i == 2) {
                t.getWidget().setTabStops(this.astrodatenTabStops);
            }
            if (i == 1 || i == 3 || i == 4) {
                t.getWidget().setTabStops(this.withSymbols ? this.aspektariumTabStopsWithSymbols : this.aspektariumTabStopsWithoutSymbols);
            }
            t.setValue(this.textListe[i]);
            if (i != 4) continue;
            String text = this.textListe[i];
            int offset = 0;
            while (text.contains("-") && text.contains("=")) {
                int pos1 = text.indexOf("-") + 1;
                int pos2 = text.indexOf("=");
                int len = pos2 - pos1;
                StyleRange styleRange = new StyleRange();
                styleRange.start = offset + pos1;
                styleRange.length = len;
                styleRange.foreground = ColorFactory.getInstance().colorRed;
                t.getWidget().setStyleRange(styleRange);
                int pos3 = text.indexOf("\n") + 1;
                text = this.textListe[i].substring(offset += pos3);
            }
        }
        return tabFolder;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, SAVE_LABEL, false);
        this.createButton(parent, 3, PRINT_LABEL, false);
        this.createButton(parent, 0, CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.setReturnCode(buttonId);
            if (buttonId == 0) {
                this.closePopup();
                return;
            }
            if (buttonId == 2) {
                this.save(buttonId);
            }
            if (buttonId == 3) {
                this.print(buttonId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    private boolean closePopup() throws Exception {
        try {
            return super.close();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    private void print(int id) {
        try {
            Map<String, Object> presetParameters = this.generateParameters();
            ReportjobController reportjobController = new ReportjobController();
            reportjobController.startBatch(3, true, presetParameters, true, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    private void save(int id) {
        try {
            Map<String, Object> presetParameters = this.generateParameters();
            ReportjobController reportjobController = new ReportjobController();
            DocumentParameter documentParameter = (DocumentParameter)presetParameters.get("DOCUMENT_PARAMETER");
            String vorgabe = "Datenblatt_" + documentParameter.getHoroskopName() + "_" + documentParameter.getPersonName();
            String filename = PopupFileDialog.openPdfFileDialog(vorgabe);
            if (!Util.isEmpty(filename)) {
                reportjobController.startBatch(3, true, presetParameters, false, filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    private Map<String, Object> generateParameters() {
        HashMap<String, Object> presetParameters = new HashMap<String, Object>();
        DocumentCreator documentCreator = new DocumentCreator(this.horoskopCalculator, this.controlpanel);
        DocumentParameter documentParameter = documentCreator.getDocumentParameter();
        presetParameters.put("DOCUMENT_PARAMETER", documentParameter);
        presetParameters.put("UEBERSCHRIFT_ARRAY", this.ueberschriftListe);
        presetParameters.put("TEXT_ARRAY", this.textListe);
        return presetParameters;
    }
}

