/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.AstroCombo;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Analyse;
import de.cni.common.datamodel.admin.CoreAnalyse;
import de.cni.common.datamodel.admin.CustomAnalyse;
import de.cni.common.datamodel.admin.PersonendatenZusatzfilter;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PopupPersonendatenZusatzfilterTile {
    private static Log log = LogFactory.getLog(PopupPersonendatenZusatzfilterTile.class);
    private static int COLUMNS = 9;
    private static int MAXLINES = 4;
    PersonendatenZusatzfilter personendatenZusatzfilter = null;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(1);
    AstroCombo astroCombo;
    ButtonWrapper addButton;
    ButtonWrapper[] removeButton = new ButtonWrapper[MAXLINES];
    Composite parent;
    Composite group;
    boolean core = true;
    ComboWrapper[] planet1 = new ComboWrapper[MAXLINES];
    ComboWrapper[] planet2 = new ComboWrapper[MAXLINES];
    ComboWrapper[] tkz1 = new ComboWrapper[MAXLINES];
    ComboWrapper[] tkz2 = new ComboWrapper[MAXLINES];
    ComboWrapper[] aspekt = new ComboWrapper[MAXLINES];
    ComboWrapper[] haus = new ComboWrapper[MAXLINES];
    ComboWrapper[] text = new ComboWrapper[MAXLINES];

    protected PopupPersonendatenZusatzfilterTile(PersonendatenZusatzfilter personendatenZusatzfilter, boolean core) {
        if (personendatenZusatzfilter == null) {
            personendatenZusatzfilter = new PersonendatenZusatzfilter(core);
        }
        if (personendatenZusatzfilter.getAnalyse().size() == 0) {
            personendatenZusatzfilter.getAnalyse().add(core ? new CoreAnalyse() : new CustomAnalyse());
        }
        this.personendatenZusatzfilter = personendatenZusatzfilter;
        this.astroCombo = new AstroCombo(core);
    }

    protected void createContent(Composite parent) throws MappingException {
        this.parent = parent;
        Composite spacer = GuiContainer.newSpacer(parent);
        this.group = GuiContainer.newFillComposite(spacer);
        Composite c = GuiContainer.newComposite(this.group, COLUMNS);
        this.createHeader(c);
        for (int i = 0; i < this.personendatenZusatzfilter.getAnalyse().size(); ++i) {
            this.createLine(c, i);
        }
        if (this.getNumOfLines() > 0) {
            if (this.getNumOfLines() < MAXLINES) {
                this.guiUtil.enableOneWidget(this.addButton);
            } else {
                this.guiUtil.disableOneWidget(this.addButton);
            }
            if (this.getNumOfLines() > 1) {
                this.guiUtil.enableOneWidget(this.removeButton[0]);
            } else {
                this.guiUtil.disableOneWidget(this.removeButton[0]);
            }
        }
        this.setData(this.personendatenZusatzfilter);
    }

    private int getNumOfLines() {
        if (this.personendatenZusatzfilter == null || this.personendatenZusatzfilter.getAnalyse() == null) {
            return 0;
        }
        return this.personendatenZusatzfilter.getAnalyse().size();
    }

    private void createHeader(Composite c) {
        this.guiUtil.createLeftAllignedLabel(c, "Planet 1");
        this.guiUtil.createLeftAllignedLabel(c, "Tkz 1");
        this.guiUtil.createLeftAllignedLabel(c, "Planet 2");
        this.guiUtil.createLeftAllignedLabel(c, "Tkz 2");
        this.guiUtil.createLeftAllignedLabel(c, "Aspekt");
        this.guiUtil.createLeftAllignedLabel(c, "Haus");
        this.guiUtil.createLeftAllignedLabel(c, "Thematik");
        this.guiUtil.createLeftAllignedLabel(c, "");
        this.guiUtil.createLeftAllignedLabel(c, "");
    }

    private void createLine(Composite c, final int i) {
        this.planet1[i] = this.astroCombo.createPlanetenCombo(this.guiUtil, c);
        this.tkz1[i] = this.astroCombo.createTkzCombo(this.guiUtil, c);
        this.planet2[i] = this.astroCombo.createPlanetenCombo(this.guiUtil, c);
        this.tkz2[i] = this.astroCombo.createTkzCombo(this.guiUtil, c);
        this.aspekt[i] = this.astroCombo.createAspektCombo(this.guiUtil, c);
        this.haus[i] = this.astroCombo.createHausCombo(this.guiUtil, c);
        this.text[i] = this.astroCombo.createTextCombo(this.guiUtil, c);
        this.removeButton[i] = this.guiUtil.createPushButton(c, "Zeile l\u00f6schen", Resources.ICON.SMALL_REMOVE);
        this.removeButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupPersonendatenZusatzfilterTile.this.removeLine(i);
            }
        });
        if (i == this.getNumOfLines() - 1) {
            this.addButton = this.guiUtil.createPushButton(c, "neue Zeile", Resources.ICON.SMALL_ADD);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PopupPersonendatenZusatzfilterTile.this.addLine();
                }
            });
        } else {
            this.guiUtil.createLeftAllignedLabel(c, "");
        }
    }

    private void addLine() {
        if (this.getNumOfLines() < MAXLINES) {
            this.getData();
            this.personendatenZusatzfilter.getAnalyse().add(Analyse.newInstance(this.core));
            this.refreshLayout();
        } else {
            Popup.info("Es sind max. " + MAXLINES + "Zeilen m\u00f6glich.");
        }
    }

    private void removeLine(int lineNumber) {
        try {
            if (this.personendatenZusatzfilter == null || this.personendatenZusatzfilter.getAnalyse() == null || this.personendatenZusatzfilter.getAnalyse().size() < lineNumber) {
                return;
            }
            this.getData();
            this.personendatenZusatzfilter.getAnalyse().remove(lineNumber);
            this.refreshLayout();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    private void refreshLayout() {
        try {
            for (Control c : this.parent.getChildren()) {
                c.dispose();
            }
            this.createContent(this.parent);
            this.parent.layout();
            this.parent.getParent().redraw();
            this.group.layout();
            this.group.getParent().layout();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    protected PersonendatenZusatzfilter getData() {
        for (int i = 0; i < this.getNumOfLines(); ++i) {
            Analyse a = this.personendatenZusatzfilter.getAnalyse().get(i);
            a.setPlanet1(this.astroCombo.getValueAsString(this.planet1[i]));
            a.setPlanet2(this.astroCombo.getValueAsString(this.planet2[i]));
            a.setTkz1(this.astroCombo.getValueAsString(this.tkz1[i]));
            a.setTkz2(this.astroCombo.getValueAsString(this.tkz2[i]));
            a.setAspekt(this.astroCombo.getValueAsString(this.aspekt[i]));
            a.setHaus(this.astroCombo.getValueAsString(this.haus[i]));
            a.setText1(this.astroCombo.getValueAsString(this.text[i]));
        }
        return this.personendatenZusatzfilter;
    }

    protected void setData(PersonendatenZusatzfilter personendatenZusatzfilter) {
        this.personendatenZusatzfilter = personendatenZusatzfilter;
        for (int i = 0; i < this.getNumOfLines(); ++i) {
            Analyse a = personendatenZusatzfilter.getAnalyse().get(i);
            this.astroCombo.setValueAsString(this.planet1[i], a.getPlanet1());
            this.astroCombo.setValueAsString(this.planet2[i], a.getPlanet2());
            this.astroCombo.setValueAsString(this.tkz1[i], a.getTkz1());
            this.astroCombo.setValueAsString(this.tkz2[i], a.getTkz2());
            this.astroCombo.setValueAsString(this.aspekt[i], a.getAspekt());
            this.astroCombo.setValueAsString(this.haus[i], a.getHaus());
            this.astroCombo.setValueAsString(this.text[i], a.getText1());
        }
    }

    public void enable(boolean flag) {
        if (flag) {
            // empty if block
        }
    }
}

