/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupPersonendatenTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupPersonendatenDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupPersonendatenDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    private PopupPersonendatenTile tile = new PopupPersonendatenTile();
    private boolean onlyInfoPopup = false;
    private List<Personendaten> pList = null;

    public PopupPersonendatenDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Radix zweier Personen vergleichen");
            this.setMessage("Bitte w\u00e4hlen sie zwei Personen aus.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.pList);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.pList = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.pList = this.tile.getData();
                if (!this.isValid()) {
                    Popup.warning("Sie m\u00fcssen zwei Personen ausw\u00e4hlen!");
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    private boolean isValid() {
        return this.pList != null && this.pList.size() == 2 && this.pList.get(0) != null && this.pList.get(0).getId() != 0 && this.pList.get(1) != null && this.pList.get(1).getId() != 0;
    }

    public List<Personendaten> getpList() {
        return this.pList;
    }

    public void setpList(List<Personendaten> pList) {
        this.pList = pList;
    }
}

